/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.asm.rules.rename;

import io.papermc.asm.ClassProcessingContext;
import io.papermc.asm.rules.RewriteRule;
import io.papermc.asm.rules.rename.FixedClassRemapper;
import io.papermc.asm.util.DescriptorUtils;
import java.lang.constant.ClassDesc;
import java.lang.constant.MethodTypeDesc;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.SimpleRemapper;

public final class RenameRule
implements RewriteRule {
    private final Remapper remapper;

    public static Builder builder() {
        return new Builder();
    }

    public RenameRule(Remapper remapper) {
        this.remapper = remapper;
    }

    @Override
    public ClassVisitor createVisitor(int api, ClassVisitor parent, ClassProcessingContext context) {
        return new FixedClassRemapper(api, parent, this.remapper);
    }

    public static final class Builder
    implements io.papermc.asm.util.Builder<RenameRule> {
        private final Map<String, String> mappings = new HashMap<String, String>();

        private Builder() {
        }

        public Builder methodByDesc(Iterable<ClassDesc> owners, String legacyMethodName, MethodTypeDesc desc, String newMethodName) {
            for (ClassDesc owner : owners) {
                this.methodByDesc(owner, legacyMethodName, desc, newMethodName);
            }
            return this;
        }

        public Builder methodByDesc(ClassDesc owner, String legacyMethodName, MethodTypeDesc desc, String newMethodName) {
            return this.methodByInternal(DescriptorUtils.toOwner(owner), legacyMethodName, desc.descriptorString(), newMethodName);
        }

        public Builder methodByInternal(Iterable<String> owners, String legacyMethodName, MethodTypeDesc desc, String newMethodName) {
            for (String owner : owners) {
                this.methodByInternal(owner, legacyMethodName, desc.descriptorString(), newMethodName);
            }
            return this;
        }

        public Builder methodByInternal(String owner, String legacyMethodName, String desc, String newMethodName) {
            this.mappings.put("%s.%s%s".formatted(owner, legacyMethodName, desc), newMethodName);
            return this;
        }

        public Builder fieldsByDesc(Iterable<ClassDesc> owners, String legacyFieldName, String newFieldName) {
            for (ClassDesc owner : owners) {
                this.fieldByDesc(owner, legacyFieldName, newFieldName);
            }
            return this;
        }

        public Builder fieldByDesc(ClassDesc owner, String legacyFieldName, String newFieldName) {
            return this.fieldByInternal(DescriptorUtils.toOwner(owner), legacyFieldName, newFieldName);
        }

        public Builder fieldByInternal(Iterable<String> owners, String legacyFieldName, String newFieldName) {
            for (String owner : owners) {
                this.fieldByInternal(owner, legacyFieldName, newFieldName);
            }
            return this;
        }

        public Builder fieldByInternal(String owner, String legacyFieldName, String newFieldName) {
            this.mappings.put("%s.%s".formatted(owner, legacyFieldName), newFieldName);
            return this;
        }

        public Builder annotationAttribute(ClassDesc owner, String legacyName, String newName) {
            return this.annotationAttribute(owner.descriptorString(), legacyName, newName);
        }

        public Builder annotationAttribute(String ownerDescriptor, String legacyName, String newName) {
            if (!ownerDescriptor.startsWith("L") || !ownerDescriptor.endsWith(";")) {
                throw new IllegalArgumentException("Invalid owner descriptor: %s".formatted(ownerDescriptor));
            }
            this.mappings.put("%s.%s".formatted(ownerDescriptor, legacyName), newName);
            return this;
        }

        public Builder type(String legacyType, ClassDesc newType) {
            this.mappings.put(legacyType, DescriptorUtils.toOwner(newType));
            return this;
        }

        public Builder type(String legacyType, String newType) {
            this.mappings.put(legacyType, newType);
            return this;
        }

        @Override
        public RenameRule build() {
            return new RenameRule((Remapper)new SimpleRemapper(Map.copyOf(this.mappings)));
        }
    }
}

