/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry.data;

import io.papermc.paper.registry.RegistryBuilder;
import io.papermc.paper.registry.RegistryBuilderFactory;
import io.papermc.paper.registry.TypedKey;
import io.papermc.paper.registry.data.SoundEventRegistryEntry;
import io.papermc.paper.registry.holder.RegistryHolder;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import org.bukkit.MusicInstrument;
import org.bukkit.Sound;
import org.checkerframework.checker.index.qual.Positive;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

@ApiStatus.Experimental
@ApiStatus.NonExtendable
public interface InstrumentRegistryEntry {
    @Contract(pure=true)
    public RegistryHolder<Sound, SoundEventRegistryEntry> soundEvent();

    @Contract(pure=true)
    public @Positive float duration();

    @Contract(pure=true)
    public @Positive float range();

    @Contract(pure=true)
    public Component description();

    @ApiStatus.Experimental
    @ApiStatus.NonExtendable
    public static interface Builder
    extends InstrumentRegistryEntry,
    RegistryBuilder<MusicInstrument> {
        @Contract(value="_ -> this", mutates="this")
        public Builder soundEvent(TypedKey<Sound> var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder soundEvent(Consumer<RegistryBuilderFactory<Sound, ? extends SoundEventRegistryEntry.Builder>> var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder soundEvent(RegistryHolder<Sound, SoundEventRegistryEntry> var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder duration(@Positive float var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder range(@Positive float var1);

        @Contract(value="_ -> this", mutates="this")
        public Builder description(Component var1);
    }
}

