/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.collect.Maps;
import java.util.Map;
import org.bukkit.Sound;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public enum Instrument {
    PIANO(0, Sound.BLOCK_NOTE_BLOCK_HARP),
    BASS_DRUM(1, Sound.BLOCK_NOTE_BLOCK_BASEDRUM),
    SNARE_DRUM(2, Sound.BLOCK_NOTE_BLOCK_SNARE),
    STICKS(3, Sound.BLOCK_NOTE_BLOCK_HAT),
    BASS_GUITAR(4, Sound.BLOCK_NOTE_BLOCK_BASS),
    FLUTE(5, Sound.BLOCK_NOTE_BLOCK_FLUTE),
    BELL(6, Sound.BLOCK_NOTE_BLOCK_BELL),
    GUITAR(7, Sound.BLOCK_NOTE_BLOCK_GUITAR),
    CHIME(8, Sound.BLOCK_NOTE_BLOCK_CHIME),
    XYLOPHONE(9, Sound.BLOCK_NOTE_BLOCK_XYLOPHONE),
    IRON_XYLOPHONE(10, Sound.BLOCK_NOTE_BLOCK_IRON_XYLOPHONE),
    COW_BELL(11, Sound.BLOCK_NOTE_BLOCK_COW_BELL),
    DIDGERIDOO(12, Sound.BLOCK_NOTE_BLOCK_DIDGERIDOO),
    BIT(13, Sound.BLOCK_NOTE_BLOCK_BIT),
    BANJO(14, Sound.BLOCK_NOTE_BLOCK_BANJO),
    PLING(15, Sound.BLOCK_NOTE_BLOCK_PLING),
    ZOMBIE(16, Sound.BLOCK_NOTE_BLOCK_IMITATE_ZOMBIE),
    SKELETON(17, Sound.BLOCK_NOTE_BLOCK_IMITATE_SKELETON),
    CREEPER(18, Sound.BLOCK_NOTE_BLOCK_IMITATE_CREEPER),
    DRAGON(19, Sound.BLOCK_NOTE_BLOCK_IMITATE_ENDER_DRAGON),
    WITHER_SKELETON(20, Sound.BLOCK_NOTE_BLOCK_IMITATE_WITHER_SKELETON),
    PIGLIN(21, Sound.BLOCK_NOTE_BLOCK_IMITATE_PIGLIN),
    CUSTOM_HEAD(22, null);

    private final byte type;
    private final Sound sound;
    private static final Map<Byte, Instrument> BY_DATA;

    private Instrument(int type, Sound sound) {
        this.type = (byte)type;
        this.sound = sound;
    }

    @Nullable
    public Sound getSound() {
        return this.sound;
    }

    @ApiStatus.Internal
    public byte getType() {
        return this.type;
    }

    @ApiStatus.Internal
    @Nullable
    public static Instrument getByType(byte type) {
        return BY_DATA.get(type);
    }

    static {
        BY_DATA = Maps.newHashMap();
        for (Instrument instrument : Instrument.values()) {
            BY_DATA.put(instrument.getType(), instrument);
        }
    }
}

