/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.entity;

import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Entity;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.entity.EntityEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class EntityChangeBlockEvent
extends EntityEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final Block block;
    private final BlockData to;
    private boolean cancelled;

    @ApiStatus.Internal
    public EntityChangeBlockEvent(@NotNull Entity entity, @NotNull Block block, @NotNull BlockData to) {
        super(entity);
        this.block = block;
        this.to = to;
    }

    @NotNull
    public Block getBlock() {
        return this.block;
    }

    @NotNull
    public Material getTo() {
        return this.to.getMaterial();
    }

    @NotNull
    public BlockData getBlockData() {
        return this.to.clone();
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

