/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.world;

import org.bukkit.World;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.world.WorldEvent;
import org.bukkit.generator.structure.Structure;
import org.bukkit.util.BoundingBox;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class AsyncStructureSpawnEvent
extends WorldEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final Structure structure;
    private final BoundingBox boundingBox;
    private final int chunkX;
    private final int chunkZ;
    private boolean cancelled;

    @ApiStatus.Internal
    public AsyncStructureSpawnEvent(@NotNull World world, @NotNull Structure structure, @NotNull BoundingBox boundingBox, int chunkX, int chunkZ) {
        super(world, true);
        this.structure = structure;
        this.boundingBox = boundingBox;
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
    }

    @NotNull
    public Structure getStructure() {
        return this.structure;
    }

    @NotNull
    public BoundingBox getBoundingBox() {
        return this.boundingBox.clone();
    }

    public int getChunkX() {
        return this.chunkX;
    }

    public int getChunkZ() {
        return this.chunkZ;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

