/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.base.Preconditions;
import io.papermc.paper.InternalAPIBridge;
import io.papermc.paper.world.flag.FeatureDependant;
import java.util.function.UnaryOperator;
import net.kyori.adventure.translation.Translatable;
import org.bukkit.GameRules;
import org.bukkit.Keyed;
import org.bukkit.MinecraftExperimental;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public abstract class GameRule<T>
implements Translatable,
FeatureDependant,
Keyed {
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> ANNOUNCE_ADVANCEMENTS = GameRules.SHOW_ADVANCEMENT_MESSAGES;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> COMMAND_BLOCK_OUTPUT = GameRules.COMMAND_BLOCK_OUTPUT;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> DISABLE_PLAYER_MOVEMENT_CHECK = InternalAPIBridge.get().legacyGameRuleBridge(GameRules.PLAYER_MOVEMENT_CHECK, GameRule.inverseBool(), GameRule.inverseBool(), Boolean.class);
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> DISABLE_ELYTRA_MOVEMENT_CHECK = InternalAPIBridge.get().legacyGameRuleBridge(GameRules.ELYTRA_MOVEMENT_CHECK, GameRule.inverseBool(), GameRule.inverseBool(), Boolean.class);
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> DO_DAYLIGHT_CYCLE = GameRules.ADVANCE_TIME;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> DO_ENTITY_DROPS = GameRules.ENTITY_DROPS;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> DO_FIRE_TICK = InternalAPIBridge.get().legacyGameRuleBridge(GameRules.FIRE_SPREAD_RADIUS_AROUND_PLAYER, value -> value != false ? 128 : 0, value -> value != 0, Boolean.class);
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> DO_LIMITED_CRAFTING = GameRules.LIMITED_CRAFTING;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> PROJECTILES_CAN_BREAK_BLOCKS = GameRules.PROJECTILES_CAN_BREAK_BLOCKS;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> DO_MOB_LOOT = GameRules.MOB_DROPS;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> DO_MOB_SPAWNING = GameRules.SPAWN_MOBS;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> DO_TILE_DROPS = GameRules.BLOCK_DROPS;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> DO_WEATHER_CYCLE = GameRules.ADVANCE_WEATHER;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> KEEP_INVENTORY = GameRules.KEEP_INVENTORY;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> LOG_ADMIN_COMMANDS = GameRules.LOG_ADMIN_COMMANDS;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> MOB_GRIEFING = GameRules.MOB_GRIEFING;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> NATURAL_REGENERATION = GameRules.NATURAL_HEALTH_REGENERATION;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> REDUCED_DEBUG_INFO = GameRules.REDUCED_DEBUG_INFO;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> SEND_COMMAND_FEEDBACK = GameRules.SEND_COMMAND_FEEDBACK;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> SHOW_DEATH_MESSAGES = GameRules.SHOW_DEATH_MESSAGES;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> SPECTATORS_GENERATE_CHUNKS = GameRules.SPECTATORS_GENERATE_CHUNKS;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> DISABLE_RAIDS = InternalAPIBridge.get().legacyGameRuleBridge(GameRules.RAIDS, GameRule.inverseBool(), GameRule.inverseBool(), Boolean.class);
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> DO_INSOMNIA = GameRules.SPAWN_PHANTOMS;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> DO_IMMEDIATE_RESPAWN = GameRules.IMMEDIATE_RESPAWN;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> DROWNING_DAMAGE = GameRules.DROWNING_DAMAGE;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> FALL_DAMAGE = GameRules.FALL_DAMAGE;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> FIRE_DAMAGE = GameRules.FIRE_DAMAGE;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> FREEZE_DAMAGE = GameRules.FREEZE_DAMAGE;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> DO_PATROL_SPAWNING = GameRules.SPAWN_PATROLS;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> DO_TRADER_SPAWNING = GameRules.SPAWN_WANDERING_TRADERS;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> DO_WARDEN_SPAWNING = GameRules.SPAWN_WARDENS;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> FORGIVE_DEAD_PLAYERS = GameRules.FORGIVE_DEAD_PLAYERS;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> UNIVERSAL_ANGER = GameRules.UNIVERSAL_ANGER;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> BLOCK_EXPLOSION_DROP_DECAY = GameRules.BLOCK_EXPLOSION_DROP_DECAY;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> MOB_EXPLOSION_DROP_DECAY = GameRules.MOB_EXPLOSION_DROP_DECAY;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> TNT_EXPLOSION_DROP_DECAY = GameRules.TNT_EXPLOSION_DROP_DECAY;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> WATER_SOURCE_CONVERSION = GameRules.WATER_SOURCE_CONVERSION;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> LAVA_SOURCE_CONVERSION = GameRules.LAVA_SOURCE_CONVERSION;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> GLOBAL_SOUND_EVENTS = GameRules.GLOBAL_SOUND_EVENTS;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> DO_VINES_SPREAD = GameRules.SPREAD_VINES;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> ENDER_PEARLS_VANISH_ON_DEATH = GameRules.ENDER_PEARLS_VANISH_ON_DEATH;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> ALLOW_FIRE_TICKS_AWAY_FROM_PLAYER = InternalAPIBridge.get().legacyGameRuleBridge(GameRules.FIRE_SPREAD_RADIUS_AROUND_PLAYER, value -> value != false ? -1 : 128, value -> value == -1, Boolean.class);
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> TNT_EXPLODES = GameRules.TNT_EXPLODES;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> LOCATOR_BAR = GameRules.LOCATOR_BAR;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> PVP = GameRules.PVP;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> SPAWN_MONSTERS = GameRules.SPAWN_MONSTERS;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> ALLOW_ENTERING_NETHER_USING_PORTALS = GameRules.ALLOW_ENTERING_NETHER_USING_PORTALS;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> COMMAND_BLOCKS_ENABLED = GameRules.COMMAND_BLOCKS_WORK;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Boolean> SPAWNER_BLOCKS_ENABLED = GameRules.SPAWNER_BLOCKS_WORK;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Integer> RANDOM_TICK_SPEED = GameRules.RANDOM_TICK_SPEED;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Integer> SPAWN_RADIUS = GameRules.RESPAWN_RADIUS;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Integer> MAX_ENTITY_CRAMMING = GameRules.MAX_ENTITY_CRAMMING;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Integer> MAX_COMMAND_CHAIN_LENGTH = GameRules.MAX_COMMAND_SEQUENCE_LENGTH;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Integer> MAX_COMMAND_FORK_COUNT = GameRules.MAX_COMMAND_FORKS;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Integer> COMMAND_MODIFICATION_BLOCK_LIMIT = GameRules.MAX_BLOCK_MODIFICATIONS;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Integer> PLAYERS_SLEEPING_PERCENTAGE = GameRules.PLAYERS_SLEEPING_PERCENTAGE;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Integer> SNOW_ACCUMULATION_HEIGHT = GameRules.MAX_SNOW_ACCUMULATION_HEIGHT;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Integer> PLAYERS_NETHER_PORTAL_DEFAULT_DELAY = GameRules.PLAYERS_NETHER_PORTAL_DEFAULT_DELAY;
    @Deprecated(forRemoval=true, since="1.21.11")
    public static final GameRule<Integer> PLAYERS_NETHER_PORTAL_CREATIVE_DELAY = GameRules.PLAYERS_NETHER_PORTAL_CREATIVE_DELAY;
    @Deprecated(forRemoval=true, since="1.21.11")
    @MinecraftExperimental(value=MinecraftExperimental.Requires.MINECART_IMPROVEMENTS)
    @ApiStatus.Experimental
    public static final GameRule<Integer> MINECART_MAX_SPEED = GameRules.MAX_MINECART_SPEED;

    private static UnaryOperator<Boolean> inverseBool() {
        return operand -> operand == false;
    }

    @Deprecated(since="1.21.11", forRemoval=true)
    @NotNull
    public abstract String getName();

    @NotNull
    public abstract Class<T> getType();

    @Deprecated(since="1.21.11", forRemoval=true)
    @Nullable
    public static <T> GameRule<T> getByName(@NotNull String rule) {
        Preconditions.checkArgument((rule != null ? 1 : 0) != 0, (Object)"Rule cannot be null");
        NamespacedKey key = NamespacedKey.fromString(rule);
        if (key == null) {
            return null;
        }
        return Registry.GAME_RULE.get(key);
    }

    @Deprecated(since="1.21.11", forRemoval=true)
    @NotNull
    public static GameRule<?>[] values() {
        return (GameRule[])Registry.GAME_RULE.stream().toArray(GameRule[]::new);
    }

    @NotNull
    public abstract String translationKey();
}

