/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit;

import com.google.common.base.Preconditions;
import io.papermc.paper.util.Tick;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;
import org.bukkit.World;
import org.checkerframework.checker.index.qual.NonNegative;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public interface WorldBorder {
    @Nullable
    public World getWorld();

    public void reset();

    public double getSize();

    public void setSize(double var1);

    public void changeSize(double var1, @Range(from=0L, to=0x7FFFFFFFL) long var3);

    @Deprecated(since="1.21.11", forRemoval=true)
    default public void setSize(double newSize, long seconds) {
        this.changeSize(Math.clamp(newSize, 1.0, this.getMaxSize()), Tick.tick().fromDuration(Duration.ofSeconds(seconds)));
    }

    @Deprecated(since="1.21.11", forRemoval=true)
    default public void setSize(double newSize, @NotNull TimeUnit unit, @NonNegative long time) {
        Preconditions.checkArgument((unit != null ? 1 : 0) != 0, (Object)"TimeUnit cannot be null.");
        this.changeSize(newSize, Tick.tick().fromDuration(Duration.of(time, unit.toChronoUnit())));
    }

    @NotNull
    public Location getCenter();

    public void setCenter(double var1, double var3);

    public void setCenter(@NotNull Location var1);

    public double getDamageBuffer();

    public void setDamageBuffer(double var1);

    public double getDamageAmount();

    public void setDamageAmount(double var1);

    @Deprecated(since="1.21.11", forRemoval=true)
    default public @NonNegative int getWarningTime() {
        return (int)Tick.of(this.getWarningTimeTicks()).toSeconds();
    }

    @Deprecated(since="1.21.11", forRemoval=true)
    default public void setWarningTime(@NonNegative int seconds) {
        Preconditions.checkArgument((seconds >= 0 ? 1 : 0) != 0, (Object)"seconds cannot be lower than 0");
        this.setWarningTimeTicks(Tick.tick().fromDuration(Duration.ofSeconds(seconds)));
    }

    public @NonNegative int getWarningTimeTicks();

    public void setWarningTimeTicks(@NonNegative int var1);

    public int getWarningDistance();

    public void setWarningDistance(int var1);

    public boolean isInside(@NotNull Location var1);

    public double getMaxSize();

    public double getMaxCenterCoordinate();
}

