/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.event.block;

import com.google.common.base.Preconditions;
import org.bukkit.block.Block;
import org.bukkit.event.Cancellable;
import org.bukkit.event.HandlerList;
import org.bukkit.event.block.BlockEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class SculkBloomEvent
extends BlockEvent
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private int charge;
    private boolean cancelled;

    @ApiStatus.Internal
    public SculkBloomEvent(@NotNull Block block, int charge) {
        super(block);
        this.charge = charge;
    }

    public int getCharge() {
        return this.charge;
    }

    public void setCharge(int charge) {
        Preconditions.checkArgument((charge >= 0 && charge <= 1000 ? 1 : 0) != 0, (Object)(charge + " is not in range [0, 1000]"));
        this.charge = charge;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean cancel) {
        this.cancelled = cancel;
    }

    @Override
    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }

    @NotNull
    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }
}

