/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.plugin.java;

import com.destroystokyo.paper.utils.PaperPluginLogger;
import com.google.common.base.Preconditions;
import io.papermc.paper.command.brigadier.BasicCommand;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.plugin.configuration.PluginMeta;
import io.papermc.paper.plugin.lifecycle.event.LifecycleEventManager;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import io.papermc.paper.plugin.provider.classloader.ConfiguredPluginClassLoader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kyori.adventure.util.Services;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.generator.BiomeProvider;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginBase;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginLoader;
import org.bukkit.plugin.java.JavaPluginLoader;
import org.bukkit.plugin.java.PluginClassLoader;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class JavaPlugin
extends PluginBase {
    private boolean isEnabled = false;
    private PluginLoader loader = null;
    private Server server = null;
    private File file = null;
    private PluginDescriptionFile description = null;
    private PluginMeta pluginMeta = null;
    private File dataFolder = null;
    private ClassLoader classLoader = null;
    private boolean naggable = true;
    private FileConfiguration newConfig = null;
    private File configFile = null;
    private Logger logger = null;
    private final LifecycleEventManager<Plugin> lifecycleEventManager = Bukkit.getUnsafe().createPluginLifecycleEventManager(this, () -> this.allowsLifecycleRegistration);
    private boolean allowsLifecycleRegistration = true;
    private boolean isBeingEnabled = false;

    public JavaPlugin() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (!(classLoader instanceof ConfiguredPluginClassLoader)) {
            throw new IllegalStateException("JavaPlugin requires to be created by a valid classloader.");
        }
        ConfiguredPluginClassLoader configuredPluginClassLoader = (ConfiguredPluginClassLoader)((Object)classLoader);
        configuredPluginClassLoader.init(this);
    }

    @Deprecated(forRemoval=true)
    protected JavaPlugin(JavaPluginLoader loader, PluginDescriptionFile description, File dataFolder, File file) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader instanceof PluginClassLoader) {
            throw new IllegalStateException("Cannot use initialization constructor at runtime");
        }
        this.init(loader, loader.server, description, dataFolder, file, classLoader);
    }

    @Override
    public final File getDataFolder() {
        return this.dataFolder;
    }

    @Override
    @Deprecated(forRemoval=true)
    public final PluginLoader getPluginLoader() {
        return this.loader;
    }

    @Override
    public final Server getServer() {
        return this.server;
    }

    @Override
    public final boolean isEnabled() {
        return this.isEnabled;
    }

    protected File getFile() {
        return this.file;
    }

    @Override
    @Deprecated
    public final PluginDescriptionFile getDescription() {
        return this.description;
    }

    @Override
    public final PluginMeta getPluginMeta() {
        return this.pluginMeta;
    }

    @Override
    public FileConfiguration getConfig() {
        if (this.newConfig == null) {
            this.reloadConfig();
        }
        return this.newConfig;
    }

    protected final @Nullable Reader getTextResource(String file) {
        InputStream in = this.getResource(file);
        return in == null ? null : new InputStreamReader(in, StandardCharsets.UTF_8);
    }

    @Override
    public void reloadConfig() {
        this.newConfig = YamlConfiguration.loadConfiguration(this.configFile);
        InputStream defConfigStream = this.getResource("config.yml");
        if (defConfigStream == null) {
            return;
        }
        this.newConfig.setDefaults(YamlConfiguration.loadConfiguration(new InputStreamReader(defConfigStream, StandardCharsets.UTF_8)));
    }

    @Override
    public void saveConfig() {
        try {
            this.getConfig().save(this.configFile);
        }
        catch (IOException ex) {
            this.logger.log(Level.SEVERE, "Could not save config to " + String.valueOf(this.configFile), ex);
        }
    }

    @Override
    public void saveDefaultConfig() {
        if (!this.configFile.exists()) {
            this.saveResource("config.yml", false);
        }
    }

    @Override
    public void saveResource(String resourcePath, boolean replace) {
        if (resourcePath == null || resourcePath.equals("")) {
            throw new IllegalArgumentException("ResourcePath cannot be null or empty");
        }
        InputStream in = this.getResource(resourcePath = resourcePath.replace('\\', '/'));
        if (in == null) {
            throw new IllegalArgumentException("The embedded resource '" + resourcePath + "' cannot be found in " + String.valueOf(this.file));
        }
        File outFile = new File(this.dataFolder, resourcePath);
        int lastIndex = resourcePath.lastIndexOf(47);
        File outDir = new File(this.dataFolder, resourcePath.substring(0, lastIndex >= 0 ? lastIndex : 0));
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        try {
            if (!outFile.exists() || replace) {
                int len;
                FileOutputStream out = new FileOutputStream(outFile);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((OutputStream)out).close();
                in.close();
            } else {
                this.logger.log(Level.WARNING, "Could not save " + outFile.getName() + " to " + String.valueOf(outFile) + " because " + outFile.getName() + " already exists.");
            }
        }
        catch (IOException ex) {
            this.logger.log(Level.SEVERE, "Could not save " + outFile.getName() + " to " + String.valueOf(outFile), ex);
        }
    }

    @Override
    public @Nullable InputStream getResource(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("Filename cannot be null");
        }
        try {
            URL url = this.getClassLoader().getResource(filename);
            if (url == null) {
                return null;
            }
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException ex) {
            return null;
        }
    }

    protected final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @ApiStatus.Internal
    public final void setEnabled(boolean enabled) {
        if (this.isEnabled != enabled) {
            this.isEnabled = enabled;
            if (this.isEnabled) {
                this.isBeingEnabled = true;
                try {
                    this.onEnable();
                }
                finally {
                    this.allowsLifecycleRegistration = false;
                    this.isBeingEnabled = false;
                }
            } else {
                this.onDisable();
            }
        }
    }

    public final void init(PluginLoader loader, Server server, PluginDescriptionFile description, File dataFolder, File file, ClassLoader classLoader) {
        this.init(server, description, dataFolder, file, classLoader, description, PaperPluginLogger.getLogger(description));
        this.pluginMeta = description;
    }

    public final void init(Server server, PluginDescriptionFile description, File dataFolder, File file, ClassLoader classLoader, @Nullable PluginMeta configuration, Logger logger) {
        this.loader = DummyPluginLoaderImplHolder.INSTANCE;
        this.server = server;
        this.file = file;
        this.description = description;
        this.dataFolder = dataFolder;
        this.classLoader = classLoader;
        this.configFile = new File(dataFolder, "config.yml");
        this.pluginMeta = configuration;
        this.logger = logger;
    }

    @Override
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        return false;
    }

    @Override
    public @Nullable List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return null;
    }

    public @Nullable PluginCommand getCommand(String name) {
        if (this.isBeingEnabled && !(this.pluginMeta instanceof PluginDescriptionFile)) {
            throw new UnsupportedOperationException("You are trying to call JavaPlugin#getCommand on a Paper plugin during startup:\nyou are probably trying to get a command you tried to define in paper-plugin.yml.\nPaper plugins do not support YAML-based command declarations!\nYou can use JavaPlugin#registerCommand to define commands in Paper plugins.\nPlease check the documentation for more information on how to define commands in Paper plugins: https://docs.papermc.io/paper/dev/getting-started/paper-plugins#commands\n");
        }
        String alias = name.toLowerCase(Locale.ROOT);
        PluginCommand command = this.getServer().getPluginCommand(alias);
        if (command == null || command.getPlugin() != this) {
            command = this.getServer().getPluginCommand(this.description.getName().toLowerCase(Locale.ROOT) + ":" + alias);
        }
        if (command != null && command.getPlugin() == this) {
            return command;
        }
        return null;
    }

    public void registerCommand(String label, BasicCommand basicCommand) {
        this.registerCommand(label, null, Collections.emptyList(), basicCommand);
    }

    public void registerCommand(String label, @Nullable String description, BasicCommand basicCommand) {
        this.registerCommand(label, description, Collections.emptyList(), basicCommand);
    }

    public void registerCommand(String label, Collection<String> aliases, BasicCommand basicCommand) {
        this.registerCommand(label, null, aliases, basicCommand);
    }

    public void registerCommand(String label, @Nullable String description, Collection<String> aliases, BasicCommand basicCommand) {
        this.getLifecycleManager().registerEventHandler(LifecycleEvents.COMMANDS, event -> ((Commands)event.registrar()).register(label, description, aliases, basicCommand));
    }

    @Override
    public void onLoad() {
    }

    @Override
    public void onDisable() {
    }

    @Override
    public void onEnable() {
    }

    @Override
    public @Nullable ChunkGenerator getDefaultWorldGenerator(String worldName, @Nullable String id) {
        return null;
    }

    @Override
    public @Nullable BiomeProvider getDefaultBiomeProvider(String worldName, @Nullable String id) {
        return null;
    }

    @Override
    public final boolean isNaggable() {
        return this.naggable;
    }

    @Override
    public final void setNaggable(boolean canNag) {
        this.naggable = canNag;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public String toString() {
        return this.description.getFullName();
    }

    public static <T extends JavaPlugin> T getPlugin(Class<T> clazz) {
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"Null class cannot have a plugin");
        if (!JavaPlugin.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(String.valueOf(clazz) + " does not extend " + String.valueOf(JavaPlugin.class));
        }
        ClassLoader cl = clazz.getClassLoader();
        if (!(cl instanceof ConfiguredPluginClassLoader)) {
            throw new IllegalArgumentException(String.valueOf(clazz) + " is not initialized by a " + String.valueOf(ConfiguredPluginClassLoader.class));
        }
        ConfiguredPluginClassLoader configuredPluginClassLoader = (ConfiguredPluginClassLoader)((Object)cl);
        JavaPlugin plugin = configuredPluginClassLoader.getPlugin();
        if (plugin == null) {
            throw new IllegalStateException("Cannot get plugin for " + String.valueOf(clazz) + " from a static initializer");
        }
        return (T)((JavaPlugin)clazz.cast(plugin));
    }

    public static JavaPlugin getProvidingPlugin(Class<?> clazz) {
        Preconditions.checkArgument((clazz != null ? 1 : 0) != 0, (Object)"Null class cannot have a plugin");
        ClassLoader cl = clazz.getClassLoader();
        if (!(cl instanceof ConfiguredPluginClassLoader)) {
            throw new IllegalArgumentException(String.valueOf(clazz) + " is not provided by a " + String.valueOf(ConfiguredPluginClassLoader.class));
        }
        ConfiguredPluginClassLoader configuredPluginClassLoader = (ConfiguredPluginClassLoader)((Object)cl);
        JavaPlugin plugin = configuredPluginClassLoader.getPlugin();
        if (plugin == null) {
            throw new IllegalStateException("Cannot get plugin for " + String.valueOf(clazz) + " from a static initializer");
        }
        return plugin;
    }

    @Override
    public final LifecycleEventManager<Plugin> getLifecycleManager() {
        return this.lifecycleEventManager;
    }

    private static class DummyPluginLoaderImplHolder {
        private static final PluginLoader INSTANCE = (PluginLoader)Services.service(PluginLoader.class).orElseThrow();

        private DummyPluginLoaderImplHolder() {
        }
    }
}

