/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.datacomponent;

import io.papermc.paper.datacomponent.DataComponentType;
import io.papermc.paper.datacomponent.item.BannerPatternLayers;
import io.papermc.paper.datacomponent.item.BlockItemDataProperties;
import io.papermc.paper.datacomponent.item.BundleContents;
import io.papermc.paper.datacomponent.item.ChargedProjectiles;
import io.papermc.paper.datacomponent.item.Consumable;
import io.papermc.paper.datacomponent.item.CustomModelData;
import io.papermc.paper.datacomponent.item.DamageResistant;
import io.papermc.paper.datacomponent.item.DeathProtection;
import io.papermc.paper.datacomponent.item.DyedItemColor;
import io.papermc.paper.datacomponent.item.Enchantable;
import io.papermc.paper.datacomponent.item.Equippable;
import io.papermc.paper.datacomponent.item.Fireworks;
import io.papermc.paper.datacomponent.item.FoodProperties;
import io.papermc.paper.datacomponent.item.ItemAdventurePredicate;
import io.papermc.paper.datacomponent.item.ItemArmorTrim;
import io.papermc.paper.datacomponent.item.ItemAttributeModifiers;
import io.papermc.paper.datacomponent.item.ItemContainerContents;
import io.papermc.paper.datacomponent.item.ItemEnchantments;
import io.papermc.paper.datacomponent.item.ItemLore;
import io.papermc.paper.datacomponent.item.JukeboxPlayable;
import io.papermc.paper.datacomponent.item.LodestoneTracker;
import io.papermc.paper.datacomponent.item.MapDecorations;
import io.papermc.paper.datacomponent.item.MapId;
import io.papermc.paper.datacomponent.item.MapItemColor;
import io.papermc.paper.datacomponent.item.OminousBottleAmplifier;
import io.papermc.paper.datacomponent.item.PotDecorations;
import io.papermc.paper.datacomponent.item.PotionContents;
import io.papermc.paper.datacomponent.item.Repairable;
import io.papermc.paper.datacomponent.item.ResolvableProfile;
import io.papermc.paper.datacomponent.item.SeededContainerLoot;
import io.papermc.paper.datacomponent.item.SuspiciousStewEffects;
import io.papermc.paper.datacomponent.item.Tool;
import io.papermc.paper.datacomponent.item.Unbreakable;
import io.papermc.paper.datacomponent.item.UseCooldown;
import io.papermc.paper.datacomponent.item.UseRemainder;
import io.papermc.paper.datacomponent.item.WritableBookContent;
import io.papermc.paper.datacomponent.item.WrittenBookContent;
import io.papermc.paper.item.MapPostProcessing;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import org.bukkit.DyeColor;
import org.bukkit.FireworkEffect;
import org.bukkit.MusicInstrument;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.inventory.ItemRarity;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.index.qual.Positive;
import org.checkerframework.common.value.qual.IntRange;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ApiStatus.Experimental
public final class DataComponentTypes {
    public static final DataComponentType.Valued<@IntRange(from=1L, to=99L) Integer> MAX_STACK_SIZE = DataComponentTypes.valued("max_stack_size");
    public static final DataComponentType.Valued<@Positive Integer> MAX_DAMAGE = DataComponentTypes.valued("max_damage");
    public static final DataComponentType.Valued<@NonNegative Integer> DAMAGE = DataComponentTypes.valued("damage");
    public static final DataComponentType.Valued<Unbreakable> UNBREAKABLE = DataComponentTypes.valued("unbreakable");
    public static final DataComponentType.Valued<Component> CUSTOM_NAME = DataComponentTypes.valued("custom_name");
    public static final DataComponentType.Valued<Component> ITEM_NAME = DataComponentTypes.valued("item_name");
    public static final DataComponentType.Valued<Key> ITEM_MODEL = DataComponentTypes.valued("item_model");
    public static final DataComponentType.Valued<ItemLore> LORE = DataComponentTypes.valued("lore");
    public static final DataComponentType.Valued<ItemRarity> RARITY = DataComponentTypes.valued("rarity");
    public static final DataComponentType.Valued<ItemEnchantments> ENCHANTMENTS = DataComponentTypes.valued("enchantments");
    public static final DataComponentType.Valued<ItemAdventurePredicate> CAN_PLACE_ON = DataComponentTypes.valued("can_place_on");
    public static final DataComponentType.Valued<ItemAdventurePredicate> CAN_BREAK = DataComponentTypes.valued("can_break");
    public static final DataComponentType.Valued<ItemAttributeModifiers> ATTRIBUTE_MODIFIERS = DataComponentTypes.valued("attribute_modifiers");
    public static final DataComponentType.Valued<CustomModelData> CUSTOM_MODEL_DATA = DataComponentTypes.valued("custom_model_data");
    public static final DataComponentType.NonValued HIDE_ADDITIONAL_TOOLTIP = DataComponentTypes.unvalued("hide_additional_tooltip");
    public static final DataComponentType.NonValued HIDE_TOOLTIP = DataComponentTypes.unvalued("hide_tooltip");
    public static final DataComponentType.Valued<@NonNegative Integer> REPAIR_COST = DataComponentTypes.valued("repair_cost");
    public static final DataComponentType.Valued<Boolean> ENCHANTMENT_GLINT_OVERRIDE = DataComponentTypes.valued("enchantment_glint_override");
    public static final DataComponentType.NonValued INTANGIBLE_PROJECTILE = DataComponentTypes.unvalued("intangible_projectile");
    public static final DataComponentType.Valued<FoodProperties> FOOD = DataComponentTypes.valued("food");
    public static final DataComponentType.Valued<Consumable> CONSUMABLE = DataComponentTypes.valued("consumable");
    public static final DataComponentType.Valued<UseRemainder> USE_REMAINDER = DataComponentTypes.valued("use_remainder");
    public static final DataComponentType.Valued<UseCooldown> USE_COOLDOWN = DataComponentTypes.valued("use_cooldown");
    public static final DataComponentType.Valued<DamageResistant> DAMAGE_RESISTANT = DataComponentTypes.valued("damage_resistant");
    public static final DataComponentType.Valued<Tool> TOOL = DataComponentTypes.valued("tool");
    public static final DataComponentType.Valued<Enchantable> ENCHANTABLE = DataComponentTypes.valued("enchantable");
    public static final DataComponentType.Valued<Equippable> EQUIPPABLE = DataComponentTypes.valued("equippable");
    public static final DataComponentType.Valued<Repairable> REPAIRABLE = DataComponentTypes.valued("repairable");
    public static final DataComponentType.NonValued GLIDER = DataComponentTypes.unvalued("glider");
    public static final DataComponentType.Valued<Key> TOOLTIP_STYLE = DataComponentTypes.valued("tooltip_style");
    public static final DataComponentType.Valued<DeathProtection> DEATH_PROTECTION = DataComponentTypes.valued("death_protection");
    public static final DataComponentType.Valued<ItemEnchantments> STORED_ENCHANTMENTS = DataComponentTypes.valued("stored_enchantments");
    public static final DataComponentType.Valued<DyedItemColor> DYED_COLOR = DataComponentTypes.valued("dyed_color");
    public static final DataComponentType.Valued<MapItemColor> MAP_COLOR = DataComponentTypes.valued("map_color");
    public static final DataComponentType.Valued<MapId> MAP_ID = DataComponentTypes.valued("map_id");
    public static final DataComponentType.Valued<MapDecorations> MAP_DECORATIONS = DataComponentTypes.valued("map_decorations");
    public static final DataComponentType.Valued<MapPostProcessing> MAP_POST_PROCESSING = DataComponentTypes.valued("map_post_processing");
    public static final DataComponentType.Valued<ChargedProjectiles> CHARGED_PROJECTILES = DataComponentTypes.valued("charged_projectiles");
    public static final DataComponentType.Valued<BundleContents> BUNDLE_CONTENTS = DataComponentTypes.valued("bundle_contents");
    public static final DataComponentType.Valued<PotionContents> POTION_CONTENTS = DataComponentTypes.valued("potion_contents");
    public static final DataComponentType.Valued<SuspiciousStewEffects> SUSPICIOUS_STEW_EFFECTS = DataComponentTypes.valued("suspicious_stew_effects");
    public static final DataComponentType.Valued<WritableBookContent> WRITABLE_BOOK_CONTENT = DataComponentTypes.valued("writable_book_content");
    public static final DataComponentType.Valued<WrittenBookContent> WRITTEN_BOOK_CONTENT = DataComponentTypes.valued("written_book_content");
    public static final DataComponentType.Valued<ItemArmorTrim> TRIM = DataComponentTypes.valued("trim");
    public static final DataComponentType.Valued<MusicInstrument> INSTRUMENT = DataComponentTypes.valued("instrument");
    public static final DataComponentType.Valued<OminousBottleAmplifier> OMINOUS_BOTTLE_AMPLIFIER = DataComponentTypes.valued("ominous_bottle_amplifier");
    public static final DataComponentType.Valued<JukeboxPlayable> JUKEBOX_PLAYABLE = DataComponentTypes.valued("jukebox_playable");
    public static final DataComponentType.Valued<List<Key>> RECIPES = DataComponentTypes.valued("recipes");
    public static final DataComponentType.Valued<LodestoneTracker> LODESTONE_TRACKER = DataComponentTypes.valued("lodestone_tracker");
    public static final DataComponentType.Valued<FireworkEffect> FIREWORK_EXPLOSION = DataComponentTypes.valued("firework_explosion");
    public static final DataComponentType.Valued<Fireworks> FIREWORKS = DataComponentTypes.valued("fireworks");
    public static final DataComponentType.Valued<ResolvableProfile> PROFILE = DataComponentTypes.valued("profile");
    public static final DataComponentType.Valued<Key> NOTE_BLOCK_SOUND = DataComponentTypes.valued("note_block_sound");
    public static final DataComponentType.Valued<BannerPatternLayers> BANNER_PATTERNS = DataComponentTypes.valued("banner_patterns");
    public static final DataComponentType.Valued<DyeColor> BASE_COLOR = DataComponentTypes.valued("base_color");
    public static final DataComponentType.Valued<PotDecorations> POT_DECORATIONS = DataComponentTypes.valued("pot_decorations");
    public static final DataComponentType.Valued<ItemContainerContents> CONTAINER = DataComponentTypes.valued("container");
    public static final DataComponentType.Valued<BlockItemDataProperties> BLOCK_DATA = DataComponentTypes.valued("block_state");
    public static final DataComponentType.Valued<SeededContainerLoot> CONTAINER_LOOT = DataComponentTypes.valued("container_loot");

    private static DataComponentType.NonValued unvalued(String name) {
        return (DataComponentType.NonValued)Objects.requireNonNull(Registry.DATA_COMPONENT_TYPE.get(NamespacedKey.minecraft(name)), name + " unvalued data component type couldn't be found, this is a bug.");
    }

    private static <T> DataComponentType.Valued<T> valued(String name) {
        return (DataComponentType.Valued)Objects.requireNonNull(Registry.DATA_COMPONENT_TYPE.get(NamespacedKey.minecraft(name)), name + " valued data component type couldn't be found, this is a bug.");
    }

    private DataComponentTypes() {
    }
}

