/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.provider.util;

import com.destroystokyo.paper.util.SneakyThrow;
import org.jetbrains.annotations.ApiStatus;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
@ApiStatus.Internal
public final class ProviderUtil {
    public static <T> T loadClass(String clazz, Class<T> classType, ClassLoader loader) {
        return ProviderUtil.loadClass(clazz, classType, loader, null);
    }

    public static <T> T loadClass(String clazz, Class<T> classType, ClassLoader loader, @Nullable Runnable onError) {
        try {
            T clazzInstance;
            try {
                Class<T> pluginClass;
                Class<?> jarClass = Class.forName(clazz, true, loader);
                try {
                    pluginClass = jarClass.asSubclass(classType);
                }
                catch (ClassCastException ex) {
                    throw new ClassCastException("class '%s' does not extend '%s'".formatted(clazz, classType));
                }
                clazzInstance = pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException exception) {
                throw new RuntimeException("No public constructor");
            }
            catch (InstantiationException exception) {
                throw new RuntimeException("Abnormal class instantiation", exception);
            }
            return clazzInstance;
        }
        catch (Throwable e) {
            if (onError != null) {
                onError.run();
            }
            SneakyThrow.sneaky(e);
            throw new AssertionError();
        }
    }
}

