/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.registry;

import io.papermc.paper.registry.Reference;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.NoSuchElementException;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ReferenceImpl<T extends Keyed>
extends Record
implements Reference<T> {
    @NotNull
    private final Registry<T> registry;
    @NotNull
    private final NamespacedKey key;

    ReferenceImpl(@NotNull Registry<T> registry, @NotNull NamespacedKey key) {
        this.registry = registry;
        this.key = key;
    }

    @Override
    @NotNull
    public T value() {
        T value = this.registry.get(this.key);
        if (value == null) {
            throw new NoSuchElementException("No such value with key " + String.valueOf(this.key));
        }
        return value;
    }

    @Override
    @Nullable
    public T valueOrNull() {
        return this.registry.get(this.key);
    }

    @Override
    @NotNull
    public NamespacedKey getKey() {
        return this.key;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ReferenceImpl.class, "registry;key", "registry", "key"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ReferenceImpl.class, "registry;key", "registry", "key"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ReferenceImpl.class, "registry;key", "registry", "key"}, this, o);
    }

    @NotNull
    public Registry<T> registry() {
        return this.registry;
    }

    @Override
    @NotNull
    public NamespacedKey key() {
        return this.key;
    }
}

