/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.paper.common.sampler.node;

import java.util.Objects;
import me.lucko.spark.paper.common.sampler.node.AbstractNode;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class StackTraceNode
extends AbstractNode {
    public static final int NULL_LINE_NUMBER = -1;
    private final Description description;

    public StackTraceNode(Description description) {
        this.description = description;
    }

    public String getClassName() {
        return this.description.className();
    }

    public String getMethodName() {
        return this.description.methodName();
    }

    public String getMethodDescription() {
        return this.description instanceof AsyncDescription ? ((AsyncDescription)this.description).methodDescription() : null;
    }

    public int getLineNumber() {
        return this.description instanceof JavaDescription ? ((JavaDescription)this.description).lineNumber() : -1;
    }

    public int getParentLineNumber() {
        return this.description instanceof JavaDescription ? ((JavaDescription)this.description).parentLineNumber() : -1;
    }

    public static interface Description {
        public String className();

        public String methodName();
    }

    public static final class AsyncDescription
    implements Description {
        private final String className;
        private final String methodName;
        private final String methodDescription;
        private final int hash;

        public AsyncDescription(String className, String methodName, String methodDescription) {
            this.className = className;
            this.methodName = methodName;
            this.methodDescription = methodDescription;
            this.hash = Objects.hash(this.className, this.methodName, this.methodDescription);
        }

        @Override
        public String className() {
            return this.className;
        }

        @Override
        public String methodName() {
            return this.methodName;
        }

        public String methodDescription() {
            return this.methodDescription;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AsyncDescription description = (AsyncDescription)o;
            return this.hash == description.hash && this.className.equals(description.className) && this.methodName.equals(description.methodName) && Objects.equals(this.methodDescription, description.methodDescription);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    public static final class JavaDescription
    implements Description {
        private final String className;
        private final String methodName;
        private final int lineNumber;
        private final int parentLineNumber;
        private final int hash;

        public JavaDescription(String className, String methodName, int lineNumber, int parentLineNumber) {
            this.className = className;
            this.methodName = methodName;
            this.lineNumber = lineNumber;
            this.parentLineNumber = parentLineNumber;
            this.hash = Objects.hash(this.className, this.methodName, this.lineNumber, this.parentLineNumber);
        }

        @Override
        public String className() {
            return this.className;
        }

        @Override
        public String methodName() {
            return this.methodName;
        }

        public int lineNumber() {
            return this.lineNumber;
        }

        public int parentLineNumber() {
            return this.parentLineNumber;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JavaDescription description = (JavaDescription)o;
            return this.hash == description.hash && this.lineNumber == description.lineNumber && this.parentLineNumber == description.parentLineNumber && this.className.equals(description.className) && this.methodName.equals(description.methodName);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    @FunctionalInterface
    public static interface Describer<T> {
        public Description describe(T var1, @Nullable T var2);
    }
}

