/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.paper.common.tick;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import me.lucko.spark.paper.common.tick.TickHook;

public abstract class AbstractTickHook
implements TickHook {
    private final Set<TickHook.Callback> tasks = new CopyOnWriteArraySet<TickHook.Callback>();
    private int tick = 0;

    protected void onTick() {
        for (TickHook.Callback r : this.tasks) {
            r.onTick(this.tick);
        }
        ++this.tick;
    }

    @Override
    public int getCurrentTick() {
        return this.tick;
    }

    @Override
    public void addCallback(TickHook.Callback runnable) {
        this.tasks.add(runnable);
    }

    @Override
    public void removeCallback(TickHook.Callback runnable) {
        this.tasks.remove(runnable);
    }
}

