/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.paper.common.command.modules;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.logging.Level;
import me.lucko.spark.paper.common.SparkPlatform;
import me.lucko.spark.paper.common.activitylog.Activity;
import me.lucko.spark.paper.common.command.Arguments;
import me.lucko.spark.paper.common.command.Command;
import me.lucko.spark.paper.common.command.CommandModule;
import me.lucko.spark.paper.common.command.CommandResponseHandler;
import me.lucko.spark.paper.common.command.sender.CommandSender;
import me.lucko.spark.paper.common.command.tabcomplete.TabCompleter;
import me.lucko.spark.paper.common.heapdump.HeapDump;
import me.lucko.spark.paper.common.heapdump.HeapDumpSummary;
import me.lucko.spark.paper.common.util.Compression;
import me.lucko.spark.paper.common.util.FormatUtil;
import me.lucko.spark.paper.proto.SparkHeapProtos;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;

public class HeapAnalysisModule
implements CommandModule {
    @Override
    public void registerCommands(Consumer<Command> consumer) {
        consumer.accept(Command.builder().aliases("heapsummary").argumentUsage("save-to-file", null).executor(HeapAnalysisModule::heapSummary).tabCompleter((platform, sender, arguments) -> TabCompleter.completeForOpts(arguments, "--save-to-file", "--run-gc-before")).build());
        consumer.accept(Command.builder().aliases("heapdump").argumentUsage("compress", "type").executor(HeapAnalysisModule::heapDump).tabCompleter((platform, sender, arguments) -> TabCompleter.completeForOpts(arguments, "--compress", "--run-gc-before", "--include-non-live")).build());
    }

    private static void heapSummary(SparkPlatform platform, CommandSender sender, CommandResponseHandler resp, Arguments arguments) {
        HeapDumpSummary heapDump;
        if (arguments.boolFlag("run-gc-before")) {
            resp.broadcastPrefixed((Component)Component.text((String)"Running garbage collector..."));
            System.gc();
        }
        resp.broadcastPrefixed((Component)Component.text((String)"Creating a new heap dump summary, please wait..."));
        try {
            heapDump = HeapDumpSummary.createNew();
        }
        catch (Exception e) {
            resp.broadcastPrefixed((Component)Component.text((String)"An error occurred whilst inspecting the heap.", (TextColor)NamedTextColor.RED));
            platform.getPlugin().log(Level.SEVERE, "An error occurred whilst inspecting the heap.", e);
            return;
        }
        SparkHeapProtos.HeapData output = heapDump.toProto(platform, resp.senderData());
        boolean saveToFile = false;
        if (arguments.boolFlag("save-to-file")) {
            saveToFile = true;
        } else {
            try {
                String key = platform.getBytebinClient().postContent(output, "application/x-spark-heap").key();
                String url = platform.getViewerUrl() + key;
                resp.broadcastPrefixed((Component)Component.text((String)"Heap dump summmary output:", (TextColor)NamedTextColor.GOLD));
                resp.broadcast((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(url).color((TextColor)NamedTextColor.GRAY)).clickEvent(ClickEvent.openUrl((String)url))).build());
                platform.getActivityLog().addToLog(Activity.urlActivity(resp.senderData(), System.currentTimeMillis(), "Heap dump summary", url));
            }
            catch (Exception e) {
                resp.broadcastPrefixed((Component)Component.text((String)"An error occurred whilst uploading the data. Attempting to save to disk instead.", (TextColor)NamedTextColor.RED));
                platform.getPlugin().log(Level.SEVERE, "An error occurred whilst uploading the data.", e);
                saveToFile = true;
            }
        }
        if (saveToFile) {
            Path file = platform.resolveSaveFile("heapsummary", "sparkheap");
            try {
                Files.write(file, output.toByteArray(), new OpenOption[0]);
                resp.broadcastPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("Heap dump summary written to: ").color((TextColor)NamedTextColor.GOLD)).append((Component)Component.text((String)file.toString(), (TextColor)NamedTextColor.GRAY))).build());
                resp.broadcastPrefixed((Component)Component.text((String)("You can read the heap dump summary file using the viewer web-app - " + platform.getViewerUrl()), (TextColor)NamedTextColor.GRAY));
                platform.getActivityLog().addToLog(Activity.fileActivity(resp.senderData(), System.currentTimeMillis(), "Heap dump summary", file.toString()));
            }
            catch (IOException e) {
                resp.broadcastPrefixed((Component)Component.text((String)"An error occurred whilst saving the data.", (TextColor)NamedTextColor.RED));
                platform.getPlugin().log(Level.SEVERE, "An error occurred whilst saving the data.", e);
            }
        }
    }

    private static void heapDump(SparkPlatform platform, CommandSender sender, CommandResponseHandler resp, Arguments arguments) {
        boolean liveOnly;
        Path file = platform.resolveSaveFile("heap", HeapDump.isOpenJ9() ? "phd" : "hprof");
        boolean bl = liveOnly = !arguments.boolFlag("include-non-live");
        if (arguments.boolFlag("run-gc-before")) {
            resp.broadcastPrefixed((Component)Component.text((String)"Running garbage collector..."));
            System.gc();
        }
        resp.broadcastPrefixed((Component)Component.text((String)"Creating a new heap dump, please wait..."));
        try {
            HeapDump.dumpHeap(file, liveOnly);
        }
        catch (Exception e) {
            resp.broadcastPrefixed((Component)Component.text((String)"An error occurred whilst creating a heap dump.", (TextColor)NamedTextColor.RED));
            platform.getPlugin().log(Level.SEVERE, "An error occurred whilst creating a heap dump.", e);
            return;
        }
        resp.broadcastPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("Heap dump written to: ").color((TextColor)NamedTextColor.GOLD)).append((Component)Component.text((String)file.toString(), (TextColor)NamedTextColor.GRAY))).build());
        platform.getActivityLog().addToLog(Activity.fileActivity(resp.senderData(), System.currentTimeMillis(), "Heap dump", file.toString()));
        Compression compressionMethod = null;
        Iterator<String> compressArgs = arguments.stringFlag("compress").iterator();
        if (compressArgs.hasNext()) {
            try {
                compressionMethod = Compression.valueOf(compressArgs.next().toUpperCase());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (compressionMethod != null) {
            try {
                HeapAnalysisModule.heapDumpCompress(platform, resp, file, compressionMethod);
            }
            catch (IOException e) {
                platform.getPlugin().log(Level.SEVERE, "An error occurred whilst compressing the heap dump.", e);
            }
        }
    }

    private static void heapDumpCompress(SparkPlatform platform, CommandResponseHandler resp, Path file, Compression method) throws IOException {
        resp.broadcastPrefixed((Component)Component.text((String)"Compressing heap dump, please wait..."));
        long size = Files.size(file);
        AtomicLong lastReport = new AtomicLong(System.currentTimeMillis());
        LongConsumer progressHandler = progress -> {
            long timeSinceLastReport = System.currentTimeMillis() - lastReport.get();
            if (timeSinceLastReport > TimeUnit.SECONDS.toMillis(5L)) {
                lastReport.set(System.currentTimeMillis());
                platform.getPlugin().executeAsync(() -> resp.broadcastPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)Component.text((String)"Compressed "))).append((Component)Component.text((String)FormatUtil.formatBytes(progress), (TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)" / "))).append((Component)Component.text((String)FormatUtil.formatBytes(size), (TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)" so far... ("))).append((Component)Component.text((String)FormatUtil.percent(progress, size), (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)")"))).build()));
            }
        };
        Path compressedFile = method.compress(file, progressHandler);
        long compressedSize = Files.size(compressedFile);
        resp.broadcastPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color((TextColor)NamedTextColor.GRAY)).append((Component)Component.text((String)"Compression complete: "))).append((Component)Component.text((String)FormatUtil.formatBytes(size), (TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)" --> "))).append((Component)Component.text((String)FormatUtil.formatBytes(compressedSize), (TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)" ("))).append((Component)Component.text((String)FormatUtil.percent(compressedSize, size), (TextColor)NamedTextColor.GREEN))).append((Component)Component.text((String)")"))).build());
        resp.broadcastPrefixed((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("Compressed heap dump written to: ").color((TextColor)NamedTextColor.GOLD)).append((Component)Component.text((String)compressedFile.toString(), (TextColor)NamedTextColor.GRAY))).build());
    }
}

