/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.paper.common.sampler.async;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import me.lucko.spark.paper.common.SparkPlatform;
import me.lucko.spark.paper.common.sampler.ThreadDumper;
import me.lucko.spark.paper.common.sampler.async.AsyncDataAggregator;
import me.lucko.spark.paper.common.sampler.async.AsyncProfilerAccess;
import me.lucko.spark.paper.common.sampler.async.JfrParsingException;
import me.lucko.spark.paper.common.sampler.async.ProfileSegment;
import me.lucko.spark.paper.common.sampler.async.SampleCollector;
import me.lucko.spark.paper.common.sampler.async.jfr.JfrReader;
import me.lucko.spark.paper.lib.asyncprofiler.AsyncProfiler;

public class AsyncProfilerJob {
    private static final AtomicReference<AsyncProfilerJob> ACTIVE = new AtomicReference();
    private final AsyncProfilerAccess access;
    private final AsyncProfiler profiler;
    private SparkPlatform platform;
    private SampleCollector<?> sampleCollector;
    private ThreadDumper threadDumper;
    private int window;
    private boolean quiet;
    private boolean forceNanoTime;
    private Path outputFile;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AsyncProfilerJob createNew(AsyncProfilerAccess access, AsyncProfiler profiler) {
        AtomicReference<AsyncProfilerJob> atomicReference = ACTIVE;
        synchronized (atomicReference) {
            AsyncProfilerJob existing = ACTIVE.get();
            if (existing != null) {
                throw new IllegalStateException("Another profiler is already active: " + existing);
            }
            AsyncProfilerJob job = new AsyncProfilerJob(access, profiler);
            ACTIVE.set(job);
            return job;
        }
    }

    private AsyncProfilerJob(AsyncProfilerAccess access, AsyncProfiler profiler) {
        this.access = access;
        this.profiler = profiler;
    }

    private String execute(Collection<String> command) {
        try {
            return this.profiler.execute(String.join((CharSequence)",", command));
        }
        catch (IOException e) {
            throw new RuntimeException("Exception whilst executing profiler command", e);
        }
    }

    private void checkActive() {
        if (ACTIVE.get() != this) {
            throw new IllegalStateException("Profiler job no longer active!");
        }
    }

    public void init(SparkPlatform platform, SampleCollector<?> collector, ThreadDumper threadDumper, int window, boolean quiet, boolean forceNanoTime) {
        this.platform = platform;
        this.sampleCollector = collector;
        this.threadDumper = threadDumper;
        this.window = window;
        this.quiet = quiet;
        this.forceNanoTime = forceNanoTime;
    }

    public void start() {
        this.checkActive();
        try {
            String resp;
            try {
                this.outputFile = this.platform.getTemporaryFiles().create("spark-", "-profile-data.jfr.tmp");
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to create temporary output file", e);
            }
            ImmutableList.Builder command = ImmutableList.builder().add((Object)"start").addAll(this.sampleCollector.initArguments(this.access)).add((Object)"threads").add((Object)"jfr").add((Object)("file=" + this.outputFile.toString()));
            if (this.quiet) {
                command.add((Object)"loglevel=NONE");
            }
            if (this.threadDumper instanceof ThreadDumper.Specific) {
                command.add((Object)"filter");
            }
            if (this.forceNanoTime) {
                command.add((Object)"clock=monotonic");
            }
            if (!(resp = this.execute((Collection<String>)command.build()).trim()).equalsIgnoreCase("profiling started")) {
                throw new RuntimeException("Unexpected response: " + resp);
            }
            if (this.threadDumper instanceof ThreadDumper.Specific) {
                ThreadDumper.Specific threadDumper = (ThreadDumper.Specific)this.threadDumper;
                for (Thread thread : threadDumper.getThreads()) {
                    this.profiler.addThread(thread);
                }
            }
        }
        catch (Exception e) {
            try {
                this.profiler.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.close();
            throw e;
        }
    }

    public void stop() {
        this.checkActive();
        try {
            this.profiler.stop();
        }
        catch (IllegalStateException e) {
            if (!e.getMessage().equals("Profiler is not active")) {
                throw e;
            }
        }
        finally {
            this.close();
        }
    }

    public void aggregate(AsyncDataAggregator dataAggregator) {
        try (JfrReader reader = new JfrReader(this.outputFile);){
            this.readSegments(reader, this.sampleCollector, dataAggregator);
        }
        catch (Exception e) {
            boolean fileExists;
            try {
                fileExists = Files.exists(this.outputFile, new LinkOption[0]) && Files.size(this.outputFile) != 0L;
            }
            catch (IOException ex) {
                fileExists = false;
            }
            if (fileExists) {
                throw new JfrParsingException("Error parsing JFR data from profiler output", e);
            }
            throw new JfrParsingException("Error parsing JFR data from profiler output - file " + this.outputFile + " does not exist!", e);
        }
        this.deleteOutputFile();
    }

    public void deleteOutputFile() {
        try {
            Files.deleteIfExists(this.outputFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private <E extends JfrReader.Event> void readSegments(JfrReader reader, SampleCollector<E> collector, AsyncDataAggregator dataAggregator) throws IOException {
        List<E> samples = reader.readAllEvents(collector.eventClass());
        for (JfrReader.Event sample : samples) {
            String threadName = reader.threads.get(sample.tid);
            if (threadName == null || !this.threadDumper.isThreadIncluded(sample.tid, threadName)) continue;
            long value = collector.measure(sample);
            ProfileSegment segment = ProfileSegment.parseSegment(reader, sample, threadName, value);
            dataAggregator.insertData(segment, this.window);
        }
    }

    public int getWindow() {
        return this.window;
    }

    private void close() {
        ACTIVE.compareAndSet(this, null);
    }
}

