/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.adventure.text.minimessage.tag.standard;

import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Pattern;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ObjectComponent;
import net.kyori.adventure.text.minimessage.Context;
import net.kyori.adventure.text.minimessage.ParsingException;
import net.kyori.adventure.text.minimessage.internal.serializer.Emitable;
import net.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.object.ObjectContents;
import net.kyori.adventure.text.object.PlayerHeadObjectContents;
import net.kyori.adventure.util.TriState;
import org.jetbrains.annotations.Nullable;

final class SequentialHeadTag {
    private static final String HEAD = "head";
    private static final Pattern UUIDv4_PATTERN = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-4[0-9a-f]{3}-[89ABCD][0-9a-f]{3}-[0-9a-f]{12}", 2);
    static final TagResolver RESOLVER = SerializableResolver.claimingComponent("head", SequentialHeadTag::create, SequentialHeadTag::claimComponent);

    private SequentialHeadTag() {
    }

    static Tag create(ArgumentQueue args, Context ctx) throws ParsingException {
        TriState outerLayer;
        if (!args.hasNext()) {
            return Tag.selfClosingInserting((Component)Component.object((ObjectContents)ObjectContents.playerHead().build()));
        }
        Tag.Argument rawArgument = args.pop();
        String argument = rawArgument.value();
        if (!args.hasNext()) {
            outerLayer = SequentialHeadTag.argumentToTriState(rawArgument);
            if (outerLayer != TriState.NOT_SET) {
                return Tag.selfClosingInserting((Component)Component.object((ObjectContents)ObjectContents.playerHead().hat(outerLayer.toBooleanOrElse(true)).build()));
            }
        } else {
            outerLayer = SequentialHeadTag.argumentToTriState(args.pop());
        }
        if (args.hasNext()) {
            throw ctx.newException("Too many arguments present", args);
        }
        if (UUIDv4_PATTERN.matcher(argument).matches()) {
            return Tag.selfClosingInserting((Component)Component.object((ObjectContents)ObjectContents.playerHead().id(UUID.fromString(argument)).hat(outerLayer.toBooleanOrElse(true)).build()));
        }
        if (argument.contains("/") && Key.parseable((String)argument)) {
            return Tag.selfClosingInserting((Component)Component.object((ObjectContents)ObjectContents.playerHead().texture(Key.key((String)argument)).hat(outerLayer.toBooleanOrElse(true)).build()));
        }
        return Tag.selfClosingInserting((Component)Component.object((ObjectContents)ObjectContents.playerHead().name(argument).hat(outerLayer.toBooleanOrElse(true)).build()));
    }

    @Nullable
    static Emitable claimComponent(Component input) {
        if (!(input instanceof ObjectComponent)) {
            return null;
        }
        ObjectContents contents = ((ObjectComponent)input).contents();
        if (!(contents instanceof PlayerHeadObjectContents)) {
            return null;
        }
        PlayerHeadObjectContents playerHead = (PlayerHeadObjectContents)contents;
        PresentType present = null;
        if (playerHead.name() != null) {
            present = PresentType.NAME;
        }
        if (playerHead.id() != null) {
            if (present != null) {
                return null;
            }
            present = PresentType.ID;
        }
        if (playerHead.texture() != null) {
            if (present != null) {
                return null;
            }
            present = PresentType.TEXTURE;
        }
        if (present == null) {
            return emit -> {
                emit.tag(HEAD);
                if (!playerHead.hat()) {
                    emit.argument(Boolean.toString(playerHead.hat()));
                }
            };
        }
        PresentType finalPresent = present;
        return emit -> {
            emit.tag(HEAD);
            String value = finalPresent.map(playerHead);
            emit.argument(value);
            if (!playerHead.hat()) {
                emit.argument(Boolean.toString(playerHead.hat()));
            }
        };
    }

    private static TriState argumentToTriState(Tag.Argument argument) {
        if (argument.isTrue()) {
            return TriState.TRUE;
        }
        if (argument.isFalse()) {
            return TriState.FALSE;
        }
        return TriState.NOT_SET;
    }

    private static enum PresentType {
        NAME(PlayerHeadObjectContents::name),
        ID(obj -> Objects.requireNonNull(obj.id()).toString()),
        TEXTURE(obj -> Objects.requireNonNull(obj.texture()).asMinimalString());

        private final Function<PlayerHeadObjectContents, String> mappingFunction;

        private PresentType(Function<PlayerHeadObjectContents, String> mappingFunction) {
            this.mappingFunction = mappingFunction;
        }

        public String map(PlayerHeadObjectContents obj) {
            return this.mappingFunction.apply(obj);
        }
    }
}

