/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.converters.helpers;

import ca.spottedleaf.dataconverter.types.ListType;
import ca.spottedleaf.dataconverter.types.MapType;
import java.util.ArrayList;
import java.util.function.Function;

public final class RenameHelper {
    public static void renameKeys(MapType data, Function<String, String> renamer) {
        String renamed;
        if (data == null) {
            return;
        }
        ArrayList<String> newKeys = null;
        ArrayList<Object> newValues = null;
        boolean needsRename = false;
        for (String key : data.keys()) {
            renamed = renamer.apply(key);
            if (renamed == null) continue;
            newKeys = new ArrayList<String>();
            newValues = new ArrayList<Object>();
            newValues.add(data.getGeneric(key));
            newKeys.add(renamed);
            data.remove(key);
            needsRename = true;
            break;
        }
        if (!needsRename) {
            return;
        }
        for (String key : new ArrayList<String>(data.keys())) {
            renamed = renamer.apply(key);
            if (renamed == null) continue;
            newValues.add(data.getGeneric(key));
            newKeys.add(renamed);
            data.remove(key);
        }
        int len = newKeys.size();
        for (int i = 0; i < len; ++i) {
            String key = (String)newKeys.get(i);
            Object value = newValues.get(i);
            data.setGeneric(key, value);
        }
    }

    public static boolean renameSingle(MapType data, String fromKey, String toKey) {
        if (data == null) {
            return false;
        }
        Object value = data.getGeneric(fromKey);
        if (value != null) {
            data.remove(fromKey);
            data.setGeneric(toKey, value);
            return true;
        }
        return false;
    }

    public static void renameString(MapType data, String key, Function<String, String> renamer) {
        if (data == null) {
            return;
        }
        String value = data.getString(key);
        if (value == null) {
            return;
        }
        String renamed = renamer.apply(value);
        if (renamed == null) {
            return;
        }
        data.setString(key, renamed);
    }

    public static void renameListMapItems(MapType data, String listPath, String mapPath, Function<String, String> renamer) {
        if (data == null) {
            return;
        }
        ListType list = data.getListUnchecked(listPath);
        if (list == null) {
            return;
        }
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            RenameHelper.renameString(list.getMap(i, null), mapPath, renamer);
        }
    }

    private RenameHelper() {
    }
}

