/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.datatypes;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.converters.datatypes.DataHook;
import ca.spottedleaf.dataconverter.converters.datatypes.DataWalker;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCDataType;
import ca.spottedleaf.dataconverter.types.MapType;
import ca.spottedleaf.dataconverter.util.Long2ObjectArraySortedMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IDDataType
extends MCDataType {
    protected final Map<String, Long2ObjectArraySortedMap<List<DataWalker<MapType>>>> walkersById = new HashMap<String, Long2ObjectArraySortedMap<List<DataWalker<MapType>>>>();

    public IDDataType(String name) {
        super(name);
    }

    public void addConverterForId(final String id, final DataConverter<MapType, MapType> converter) {
        this.addStructureConverter(new DataConverter<MapType, MapType>(this, converter.getToVersion(), converter.getVersionStep()){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                if (!id.equals(data.getString("id"))) {
                    return null;
                }
                return (MapType)converter.convert(data, sourceVersion, toVersion);
            }
        });
    }

    public boolean hasWalkers(String id) {
        return this.walkersById.containsKey(id);
    }

    public void addWalker(int minVersion, String id, DataWalker<MapType> walker) {
        this.addWalker(minVersion, 0, id, walker);
    }

    public void addWalker(int minVersion, int versionStep, String id, DataWalker<MapType> walker) {
        this.walkersById.computeIfAbsent(id, keyInMap -> new Long2ObjectArraySortedMap()).computeIfAbsent(DataConverter.encodeVersions(minVersion, versionStep), keyInMap -> new ArrayList()).add(walker);
    }

    public void copyWalkers(int minVersion, String fromId, String toId) {
        this.copyWalkers(minVersion, 0, fromId, toId);
    }

    public void copyWalkers(int minVersion, int versionStep, String fromId, String toId) {
        long version = DataConverter.encodeVersions(minVersion, versionStep);
        Long2ObjectArraySortedMap<List<DataWalker<MapType>>> walkersForId = this.walkersById.get(fromId);
        if (walkersForId == null) {
            return;
        }
        List<DataWalker<MapType>> nearest = walkersForId.getFloor(version);
        if (nearest == null) {
            return;
        }
        for (DataWalker<MapType> walker : nearest) {
            this.addWalker(minVersion, versionStep, toId, walker);
        }
    }

    @Override
    public MapType convert(MapType data, long fromVersion, long toVersion) {
        List<DataWalker<MapType>> walkersForId;
        Long2ObjectArraySortedMap<List<DataWalker<MapType>>> walkersByVersion;
        List<DataWalker<MapType>> walkers;
        List<DataHook<MapType, MapType>> hooks;
        MapType replace;
        MapType ret = null;
        ArrayList<DataConverter<MapType, MapType>> converters = this.structureConverters;
        int len = converters.size();
        for (int i = 0; i < len; ++i) {
            int klen;
            DataConverter converter = (DataConverter)converters.get(i);
            long converterVersion = converter.getEncodedVersion();
            if (converterVersion <= fromVersion) continue;
            if (converterVersion > toVersion) break;
            List<DataHook<MapType, MapType>> hooks2 = this.structureHooks.getFloor(converterVersion);
            if (hooks2 != null) {
                klen = hooks2.size();
                for (int k = 0; k < klen; ++k) {
                    MapType replace2 = hooks2.get(k).preHook(data, fromVersion, toVersion);
                    if (replace2 == null) continue;
                    ret = data = replace2;
                }
            }
            if ((replace = (MapType)converter.convert(data, fromVersion, toVersion)) != null) {
                ret = data = replace;
            }
            if ((hooks2 = this.structureHooks.getFloor(toVersion)) == null) continue;
            klen = hooks2.size();
            for (int k = klen - 1; k >= 0; --k) {
                MapType postReplace = hooks2.get(k).postHook(data, fromVersion, toVersion);
                if (postReplace == null) continue;
                ret = data = postReplace;
            }
        }
        if ((hooks = this.structureHooks.getFloor(toVersion)) != null) {
            int klen = hooks.size();
            for (int k = 0; k < klen; ++k) {
                MapType replace3 = hooks.get(k).preHook(data, fromVersion, toVersion);
                if (replace3 == null) continue;
                ret = data = replace3;
            }
        }
        if ((walkers = this.structureWalkers.getFloor(toVersion)) != null) {
            int len2 = walkers.size();
            for (int i = 0; i < len2; ++i) {
                MapType replace4 = walkers.get(i).walk(data, fromVersion, toVersion);
                if (replace4 == null) continue;
                ret = data = replace4;
            }
        }
        if ((walkersByVersion = this.walkersById.get(data.getString("id"))) != null && (walkersForId = walkersByVersion.getFloor(toVersion)) != null) {
            int len3 = walkersForId.size();
            for (int i = 0; i < len3; ++i) {
                replace = walkersForId.get(i).walk(data, fromVersion, toVersion);
                if (replace == null) continue;
                ret = data = replace;
            }
        }
        if (hooks != null) {
            int klen = hooks.size();
            for (int k = klen - 1; k >= 0; --k) {
                MapType postReplace = hooks.get(k).postHook(data, fromVersion, toVersion);
                if (postReplace == null) continue;
                ret = data = postReplace;
            }
        }
        return ret;
    }
}

