/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.dataconverter.minecraft.versions;

import ca.spottedleaf.dataconverter.converters.DataConverter;
import ca.spottedleaf.dataconverter.minecraft.datatypes.MCTypeRegistry;
import ca.spottedleaf.dataconverter.types.MapType;

public final class V2537 {
    private static final int VERSION = 2537;

    private static void convertDimension(MapType data, String path) {
        if (data == null) {
            return;
        }
        Number dimension = data.getNumber(path);
        if (dimension == null) {
            return;
        }
        data.setString(path, switch (dimension.intValue()) {
            case -1 -> "minecraft:the_nether";
            case 1 -> "minecraft:the_end";
            default -> "minecraft:overworld";
        });
    }

    public static void register() {
        MCTypeRegistry.PLAYER.addStructureConverter(new DataConverter<MapType, MapType>(2537){

            @Override
            public MapType convert(MapType data, long sourceVersion, long toVersion) {
                V2537.convertDimension(data, "Dimension");
                return null;
            }
        });
        MCTypeRegistry.SAVED_DATA_MAP_DATA.addStructureConverter(new DataConverter<MapType, MapType>(2537){

            @Override
            public MapType convert(MapType root, long sourceVersion, long toVersion) {
                V2537.convertDimension(root.getMap("data"), "dimension");
                return null;
            }
        });
    }

    private V2537() {
    }
}

