/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.common.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec3;

public final class CoordinateUtils {
    static final int SECTION_X_BITS = 22;
    static final long SECTION_X_MASK = 0x3FFFFFL;
    static final int SECTION_Y_BITS = 20;
    static final long SECTION_Y_MASK = 1048575L;
    static final int SECTION_Z_BITS = 22;
    static final long SECTION_Z_MASK = 0x3FFFFFL;
    static final int SECTION_Y_SHIFT = 0;
    static final int SECTION_Z_SHIFT = 20;
    static final int SECTION_X_SHIFT = 42;
    static final int SECTION_TO_BLOCK_SHIFT = 4;

    public static long getChunkKey(BlockPos pos) {
        return (long)(pos.getZ() >> 4) << 32 | (long)(pos.getX() >> 4) & 0xFFFFFFFFL;
    }

    public static long getChunkKey(Entity entity) {
        ChunkPos pos = entity.chunkPosition();
        return (long)pos.z << 32 | (long)pos.x & 0xFFFFFFFFL;
    }

    public static long getChunkKey(ChunkPos pos) {
        return (long)pos.z << 32 | (long)pos.x & 0xFFFFFFFFL;
    }

    public static long getChunkKey(SectionPos pos) {
        return (long)pos.getZ() << 32 | (long)pos.getX() & 0xFFFFFFFFL;
    }

    public static long getChunkKey(int x, int z) {
        return (long)z << 32 | (long)x & 0xFFFFFFFFL;
    }

    public static int getChunkX(long chunkKey) {
        return (int)chunkKey;
    }

    public static int getChunkZ(long chunkKey) {
        return (int)(chunkKey >>> 32);
    }

    public static int getChunkCoordinate(double blockCoordinate) {
        return Mth.floor(blockCoordinate) >> 4;
    }

    public static long getChunkSectionKey(int x, int y, int z) {
        return ((long)x & 0x3FFFFFL) << 42 | ((long)y & 0xFFFFFL) << 0 | ((long)z & 0x3FFFFFL) << 20;
    }

    public static long getChunkSectionKey(SectionPos pos) {
        return ((long)pos.getX() & 0x3FFFFFL) << 42 | ((long)pos.getY() & 0xFFFFFL) << 0 | ((long)pos.getZ() & 0x3FFFFFL) << 20;
    }

    public static long getChunkSectionKey(ChunkPos pos, int y) {
        return ((long)pos.x & 0x3FFFFFL) << 42 | ((long)y & 0xFFFFFL) << 0 | ((long)pos.z & 0x3FFFFFL) << 20;
    }

    public static long getChunkSectionKey(BlockPos pos) {
        return (long)pos.getX() << 38 & 0xFFFFFC0000000000L | (long)(pos.getY() >> 4) & 0xFFFFFL | (long)pos.getZ() << 16 & 0x3FFFFF00000L;
    }

    public static long getChunkSectionKey(Entity entity) {
        return Mth.lfloor(entity.getX()) << 38 & 0xFFFFFC0000000000L | Mth.lfloor(entity.getY()) >> 4 & 0xFFFFFL | Mth.lfloor(entity.getZ()) << 16 & 0x3FFFFF00000L;
    }

    public static int getChunkSectionX(long key) {
        return (int)(key << 0 >> 42);
    }

    public static int getChunkSectionY(long key) {
        return (int)(key << 44 >> 44);
    }

    public static int getChunkSectionZ(long key) {
        return (int)(key << 22 >> 42);
    }

    public static int getBlockX(Vec3 pos) {
        return Mth.floor(pos.x);
    }

    public static int getBlockY(Vec3 pos) {
        return Mth.floor(pos.y);
    }

    public static int getBlockZ(Vec3 pos) {
        return Mth.floor(pos.z);
    }

    public static int getChunkX(Vec3 pos) {
        return Mth.floor(pos.x) >> 4;
    }

    public static int getChunkY(Vec3 pos) {
        return Mth.floor(pos.y) >> 4;
    }

    public static int getChunkZ(Vec3 pos) {
        return Mth.floor(pos.z) >> 4;
    }

    private CoordinateUtils() {
        throw new RuntimeException();
    }
}

