/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.chunk_system.scheduling;

import ca.spottedleaf.concurrentutil.collection.MultiThreadedQueue;
import ca.spottedleaf.concurrentutil.lock.ReentrantAreaLock;
import ca.spottedleaf.concurrentutil.map.ConcurrentLong2ReferenceChainedHashTable;
import ca.spottedleaf.concurrentutil.util.ConcurrentUtil;
import ca.spottedleaf.moonrise.common.util.CoordinateUtils;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.ChunkTaskScheduler;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.task.ChunkProgressionTask;
import it.unimi.dsi.fastutil.longs.Long2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.shorts.Short2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.shorts.Short2ByteMap;
import it.unimi.dsi.fastutil.shorts.ShortOpenHashSet;
import java.lang.invoke.VarHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.LockSupport;

public abstract class ThreadedTicketLevelPropagator {
    public static final int SECTION_SHIFT = 6;
    public static final int SECTION_SIZE = 64;
    private static final int LEVEL_BITS = 6;
    private static final int LEVEL_COUNT = 64;
    private static final int MIN_SOURCE_LEVEL = 1;
    private static final int MAX_SOURCE_LEVEL = 62;
    private final UpdateQueue updateQueue = new UpdateQueue();
    private final ConcurrentLong2ReferenceChainedHashTable<Section> sections = new ConcurrentLong2ReferenceChainedHashTable();

    private static int getMaxSchedulingRadius() {
        return 2 * ChunkTaskScheduler.getMaxAccessRadius();
    }

    public void setSource(int posX, int posZ, int to) {
        if (to < 1 || to > 62) {
            throw new IllegalArgumentException("Source: " + to);
        }
        int sectionX = posX >> 6;
        int sectionZ = posZ >> 6;
        long coordinate = CoordinateUtils.getChunkKey(sectionX, sectionZ);
        Section section = (Section)this.sections.get(coordinate);
        if (section == null && null != this.sections.putIfAbsent(coordinate, (Object)(section = new Section(sectionX, sectionZ)))) {
            throw new IllegalStateException("Race condition while creating new section");
        }
        int localIdx = posX & 0x3F | (posZ & 0x3F) << 6;
        short sLocalIdx = (short)localIdx;
        short sourceAndLevel = section.levels[localIdx];
        int currentSource = sourceAndLevel >>> 8 & 0xFF;
        if (currentSource == to) {
            section.queuedSources.replace(sLocalIdx, (byte)to);
            return;
        }
        if (section.queuedSources.put(sLocalIdx, (byte)to) == -1 && section.queuedSources.size() == 1) {
            this.queueSectionUpdate(section);
        }
    }

    public void removeSource(int posX, int posZ) {
        int sectionX = posX >> 6;
        int sectionZ = posZ >> 6;
        long coordinate = CoordinateUtils.getChunkKey(sectionX, sectionZ);
        Section section = (Section)this.sections.get(coordinate);
        if (section == null) {
            return;
        }
        int localIdx = posX & 0x3F | (posZ & 0x3F) << 6;
        short sLocalIdx = (short)localIdx;
        int currentSource = section.levels[localIdx] >>> 8 & 0xFF;
        if (currentSource == 0) {
            section.queuedSources.replace(sLocalIdx, (byte)0);
            return;
        }
        if (section.queuedSources.put(sLocalIdx, (byte)0) == -1 && section.queuedSources.size() == 1) {
            this.queueSectionUpdate(section);
        }
    }

    private void queueSectionUpdate(Section section) {
        this.updateQueue.append(new UpdateQueue.UpdateQueueNode(section, null));
    }

    public boolean hasPendingUpdates() {
        return !this.updateQueue.isEmpty();
    }

    protected abstract void processLevelUpdates(Long2ByteLinkedOpenHashMap var1);

    protected abstract void processSchedulingUpdates(Long2ByteLinkedOpenHashMap var1, List<ChunkProgressionTask> var2, List<NewChunkHolder> var3);

    public boolean performUpdate(int sectionX, int sectionZ, ReentrantAreaLock schedulingLock, List<ChunkProgressionTask> scheduledTasks, List<NewChunkHolder> changedFullStatus) {
        if (!this.hasPendingUpdates()) {
            return false;
        }
        long coordinate = CoordinateUtils.getChunkKey(sectionX, sectionZ);
        Section section = (Section)this.sections.get(coordinate);
        if (section == null || section.queuedSources.isEmpty()) {
            return false;
        }
        Propagator propagator = Propagator.acquirePropagator();
        boolean ret = this.performUpdate(section, null, propagator, null, schedulingLock, scheduledTasks, changedFullStatus);
        Propagator.returnPropagator(propagator);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean performUpdate(Section section, UpdateQueue.UpdateQueueNode node, Propagator propagator, ReentrantAreaLock ticketLock, ReentrantAreaLock schedulingLock, List<ChunkProgressionTask> scheduledTasks, List<NewChunkHolder> changedFullStatus) {
        boolean ret;
        block28: {
            int sectionX = section.sectionX;
            int sectionZ = section.sectionZ;
            int rad1MinX = sectionX - 1 << 6;
            int rad1MinZ = sectionZ - 1 << 6;
            int rad1MaxX = sectionX + 1 << 6 | 0x3F;
            int rad1MaxZ = sectionZ + 1 << 6 | 0x3F;
            propagator.setupEncodeOffset(sectionX, sectionZ);
            int coordinateOffset = propagator.coordinateOffset;
            ReentrantAreaLock.Node ticketNode = ticketLock == null ? null : ticketLock.lock(rad1MinX, rad1MinZ, rad1MaxX, rad1MaxZ);
            try {
                if (section != this.sections.get(CoordinateUtils.getChunkKey(sectionX, sectionZ))) {
                    if (node != null) {
                        this.updateQueue.remove(node);
                    }
                    boolean bl = false;
                    return bl;
                }
                int oldSourceSize = section.sources.size();
                ObjectBidirectionalIterator iterator = section.queuedSources.short2ByteEntrySet().fastIterator();
                while (iterator.hasNext()) {
                    Short2ByteMap.Entry entry = (Short2ByteMap.Entry)iterator.next();
                    short pos = entry.getShortKey();
                    int posX = pos & 0x3F | sectionX << 6;
                    int posZ = pos >> 6 & 0x3F | sectionZ << 6;
                    byte newSource = entry.getByteValue();
                    short currentEncoded = section.levels[pos];
                    int currLevel = currentEncoded & 0xFF;
                    int prevSource = currentEncoded >>> 8 & 0xFF;
                    if (prevSource == newSource) continue;
                    if (prevSource < currLevel && newSource <= currLevel || newSource == currLevel) {
                        section.levels[pos] = (short)(currLevel | newSource << 8);
                    } else {
                        section.levels[pos] = (short)(newSource | newSource << 8);
                        propagator.updatedPositions.put(CoordinateUtils.getChunkKey(posX, posZ), newSource);
                        if (newSource != 0) {
                            propagator.appendToIncreaseQueue((long)(posX + (posZ << 9) + coordinateOffset) & 0x3FFFFL | ((long)newSource & 0x3FL) << 18 | 0x757000000L);
                        }
                        if (newSource < currLevel) {
                            propagator.appendToDecreaseQueue((long)(posX + (posZ << 9) + coordinateOffset) & 0x3FFFFL | ((long)currLevel & 0x3FL) << 18 | 0x757000000L);
                        }
                    }
                    if (newSource == 0) {
                        section.sources.remove(pos);
                        continue;
                    }
                    if (prevSource != 0) continue;
                    section.sources.add(pos);
                }
                section.queuedSources.clear();
                int newSourceSize = section.sources.size();
                if (oldSourceSize == 0 && newSourceSize != 0) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        for (int dx = -1; dx <= 1; ++dx) {
                            if ((dx | dz) == 0) continue;
                            int offX = dx + sectionX;
                            int offZ = dz + sectionZ;
                            long coordinate = CoordinateUtils.getChunkKey(offX, offZ);
                            Section neighbour = (Section)this.sections.computeIfAbsent(coordinate, keyInMap -> new Section(CoordinateUtils.getChunkX(keyInMap), CoordinateUtils.getChunkZ(keyInMap)));
                            ++neighbour.oneRadNeighboursWithSources;
                            if (neighbour.oneRadNeighboursWithSources > 0 && neighbour.oneRadNeighboursWithSources <= 8) continue;
                            throw new IllegalStateException(Integer.toString(neighbour.oneRadNeighboursWithSources));
                        }
                    }
                }
                if (propagator.hasUpdates()) {
                    propagator.setupCaches(this, sectionX, sectionZ, 1);
                    propagator.performDecrease();
                    propagator.destroyCaches();
                }
                if (newSourceSize == 0) {
                    boolean decrementRef = oldSourceSize != 0;
                    for (int dz = -1; dz <= 1; ++dz) {
                        for (int dx = -1; dx <= 1; ++dx) {
                            int offX = dx + sectionX;
                            int offZ = dz + sectionZ;
                            long coordinate = CoordinateUtils.getChunkKey(offX, offZ);
                            Section neighbour = (Section)this.sections.get(coordinate);
                            if (neighbour == null) {
                                if (oldSourceSize == 0 && (dx | dz) != 0) continue;
                                throw new IllegalStateException("??");
                            }
                            if (decrementRef && (dx | dz) != 0) {
                                --neighbour.oneRadNeighboursWithSources;
                            }
                            if (neighbour.oneRadNeighboursWithSources == 0) {
                                if (!neighbour.queuedSources.isEmpty() || !neighbour.sources.isEmpty()) continue;
                                this.sections.remove(coordinate);
                                continue;
                            }
                            if (neighbour.oneRadNeighboursWithSources >= 0 && neighbour.oneRadNeighboursWithSources <= 8) continue;
                            throw new IllegalStateException(Integer.toString(neighbour.oneRadNeighboursWithSources));
                        }
                    }
                }
                boolean bl = ret = !propagator.updatedPositions.isEmpty();
                if (!ret) break block28;
                this.processLevelUpdates(propagator.updatedPositions);
                if (!propagator.updatedPositions.isEmpty()) {
                    int maxScheduleRadius = ThreadedTicketLevelPropagator.getMaxSchedulingRadius();
                    ReentrantAreaLock.Node schedulingNode = schedulingLock.lock(rad1MinX - maxScheduleRadius, rad1MinZ - maxScheduleRadius, rad1MaxX + maxScheduleRadius, rad1MaxZ + maxScheduleRadius);
                    try {
                        this.processSchedulingUpdates(propagator.updatedPositions, scheduledTasks, changedFullStatus);
                    }
                    finally {
                        schedulingLock.unlock(schedulingNode);
                    }
                }
                propagator.updatedPositions.clear();
            }
            finally {
                if (ticketLock != null) {
                    ticketLock.unlock(ticketNode);
                }
            }
        }
        if (node != null) {
            this.updateQueue.remove(node);
        }
        return ret;
    }

    public boolean performUpdates(ReentrantAreaLock ticketLock, ReentrantAreaLock schedulingLock, List<ChunkProgressionTask> scheduledTasks, List<NewChunkHolder> changedFullStatus) {
        if (this.updateQueue.isEmpty()) {
            return false;
        }
        long maxOrder = this.updateQueue.getLastOrder();
        boolean updated = false;
        Propagator propagator = null;
        while (true) {
            UpdateQueue.UpdateQueueNode toUpdate;
            if ((toUpdate = this.updateQueue.acquireNextOrWait(maxOrder)) == null) {
                if (this.updateQueue.hasRemainingUpdates(maxOrder)) continue;
                if (propagator != null) {
                    Propagator.returnPropagator(propagator);
                }
                return updated;
            }
            if (propagator == null) {
                propagator = Propagator.acquirePropagator();
            }
            updated |= this.performUpdate(toUpdate.section, toUpdate, propagator, ticketLock, schedulingLock, scheduledTasks, changedFullStatus);
        }
    }

    private static final class UpdateQueue {
        private volatile UpdateQueueNode head;
        private volatile UpdateQueueNode tail;
        private static final VarHandle HEAD_HANDLE = ConcurrentUtil.getVarHandle(UpdateQueue.class, (String)"head", UpdateQueueNode.class);
        private static final VarHandle TAIL_HANDLE = ConcurrentUtil.getVarHandle(UpdateQueue.class, (String)"tail", UpdateQueueNode.class);

        private final void setHeadPlain(UpdateQueueNode newHead) {
            HEAD_HANDLE.set(this, newHead);
        }

        private final void setHeadOpaque(UpdateQueueNode newHead) {
            HEAD_HANDLE.setOpaque(this, newHead);
        }

        private final UpdateQueueNode getHeadPlain() {
            return HEAD_HANDLE.get(this);
        }

        private final UpdateQueueNode getHeadOpaque() {
            return HEAD_HANDLE.getOpaque(this);
        }

        private final UpdateQueueNode getHeadAcquire() {
            return HEAD_HANDLE.getAcquire(this);
        }

        private final void setTailPlain(UpdateQueueNode newTail) {
            TAIL_HANDLE.set(this, newTail);
        }

        private final void setTailOpaque(UpdateQueueNode newTail) {
            TAIL_HANDLE.setOpaque(this, newTail);
        }

        private final UpdateQueueNode getTailPlain() {
            return TAIL_HANDLE.get(this);
        }

        private final UpdateQueueNode getTailOpaque() {
            return TAIL_HANDLE.getOpaque(this);
        }

        public UpdateQueue() {
            UpdateQueueNode dummy = new UpdateQueueNode(null, null);
            dummy.order = -1L;
            dummy.preventAdds();
            this.setHeadPlain(dummy);
            this.setTailPlain(dummy);
        }

        public boolean isEmpty() {
            return this.peek() == null;
        }

        public boolean hasRemainingUpdates(long maxUpdate) {
            UpdateQueueNode node = this.peek();
            return node != null && node.order <= maxUpdate;
        }

        public long getLastOrder() {
            UpdateQueueNode tail;
            UpdateQueueNode curr = tail = this.getTailOpaque();
            while (true) {
                UpdateQueueNode next;
                if ((next = curr.getNextVolatile()) == null) {
                    if (this.getTailOpaque() == tail && curr != tail) {
                        this.setTailOpaque(curr);
                    }
                    return curr.order;
                }
                curr = next;
            }
        }

        private static void await(UpdateQueueNode node) {
            Thread currThread = Thread.currentThread();
            node.add(currThread);
            while (node.getSectionVolatile() != null) {
                LockSupport.park();
            }
        }

        public UpdateQueueNode acquireNextOrWait(long maxOrder) {
            ArrayList<UpdateQueueNode> blocking = new ArrayList<UpdateQueueNode>();
            block0: for (UpdateQueueNode curr = this.peek(); curr != null && curr.order <= maxOrder; curr = curr.getNextVolatile()) {
                if (curr.getSectionVolatile() == null) continue;
                if (curr.getUpdatingVolatile()) {
                    blocking.add(curr);
                    continue;
                }
                int len = blocking.size();
                for (int i = 0; i < len; ++i) {
                    UpdateQueueNode node = (UpdateQueueNode)((Object)blocking.get(i));
                    if (node.intersects(curr)) continue block0;
                }
                if (curr.getAndSetUpdatingVolatile(true)) {
                    blocking.add(curr);
                    continue;
                }
                return curr;
            }
            if (!blocking.isEmpty()) {
                UpdateQueue.await((UpdateQueueNode)((Object)blocking.get(0)));
            }
            return null;
        }

        public UpdateQueueNode peek() {
            UpdateQueueNode head;
            UpdateQueueNode curr = head = this.getHeadOpaque();
            while (true) {
                UpdateQueueNode next = curr.getNextVolatile();
                Section element = curr.getSectionVolatile();
                if (element != null) {
                    if (this.getHeadOpaque() == head && curr != head) {
                        this.setHeadOpaque(curr);
                    }
                    return curr;
                }
                if (next == null) {
                    if (this.getHeadOpaque() == head && curr != head) {
                        this.setHeadOpaque(curr);
                    }
                    return null;
                }
                curr = next;
            }
        }

        public void remove(UpdateQueueNode node) {
            Thread unpark;
            node.setSectionVolatile(null);
            this.peek();
            while ((unpark = (Thread)node.poll()) != null) {
                LockSupport.unpark(unpark);
            }
        }

        public void append(UpdateQueueNode node) {
            UpdateQueueNode currTail;
            int failures = 0;
            UpdateQueueNode curr = currTail = this.getTailOpaque();
            while (true) {
                UpdateQueueNode next = curr.getNextVolatile();
                for (int i = 0; i < failures; ++i) {
                    ConcurrentUtil.backoff();
                }
                if (next == null) {
                    node.order = curr.order + 1L;
                    UpdateQueueNode compared = curr.compareExchangeNextVolatile(null, node);
                    if (compared == null) {
                        if (this.getTailOpaque() == currTail) {
                            this.setTailOpaque(node);
                        }
                        return;
                    }
                    ++failures;
                    curr = compared;
                    continue;
                }
                if (curr == currTail) {
                    curr = next;
                    continue;
                }
                if (currTail == (currTail = this.getTailOpaque())) {
                    curr = next;
                    continue;
                }
                curr = currTail;
            }
        }

        private static final class UpdateQueueNode
        extends MultiThreadedQueue<Thread> {
            private final int sectionX;
            private final int sectionZ;
            private long order;
            private volatile Section section;
            private volatile UpdateQueueNode next;
            private volatile boolean updating;
            private static final VarHandle SECTION_HANDLE = ConcurrentUtil.getVarHandle(UpdateQueueNode.class, (String)"section", Section.class);
            private static final VarHandle NEXT_HANDLE = ConcurrentUtil.getVarHandle(UpdateQueueNode.class, (String)"next", UpdateQueueNode.class);
            private static final VarHandle UPDATING_HANDLE = ConcurrentUtil.getVarHandle(UpdateQueueNode.class, (String)"updating", Boolean.TYPE);

            public UpdateQueueNode(Section section, UpdateQueueNode next) {
                if (section == null) {
                    this.sectionZ = 0;
                    this.sectionX = 0;
                } else {
                    this.sectionX = section.sectionX;
                    this.sectionZ = section.sectionZ;
                }
                SECTION_HANDLE.set(this, section);
                NEXT_HANDLE.set(this, next);
            }

            public boolean intersects(UpdateQueueNode other) {
                int dist = Math.max(Math.abs(this.sectionX - other.sectionX), Math.abs(this.sectionZ - other.sectionZ));
                return dist <= 1 + (ThreadedTicketLevelPropagator.getMaxSchedulingRadius() + 63 >> 6);
            }

            private final Section getSectionPlain() {
                return SECTION_HANDLE.get(this);
            }

            private final Section getSectionVolatile() {
                return SECTION_HANDLE.getVolatile(this);
            }

            private final void setSectionPlain(Section update) {
                SECTION_HANDLE.set(this, update);
            }

            private final void setSectionOpaque(Section update) {
                SECTION_HANDLE.setOpaque(this, update);
            }

            private final void setSectionVolatile(Section update) {
                SECTION_HANDLE.setVolatile(this, update);
            }

            private final Section getAndSetSectionVolatile(Section update) {
                return SECTION_HANDLE.getAndSet(this, update);
            }

            private final Section compareExchangeSectionVolatile(Section expect, Section update) {
                return SECTION_HANDLE.compareAndExchange(this, expect, update);
            }

            private final UpdateQueueNode getNextPlain() {
                return NEXT_HANDLE.get(this);
            }

            private final UpdateQueueNode getNextOpaque() {
                return NEXT_HANDLE.getOpaque(this);
            }

            private final UpdateQueueNode getNextAcquire() {
                return NEXT_HANDLE.getAcquire(this);
            }

            private final UpdateQueueNode getNextVolatile() {
                return NEXT_HANDLE.getVolatile(this);
            }

            private final void setNextPlain(UpdateQueueNode next) {
                NEXT_HANDLE.set(this, next);
            }

            private final void setNextVolatile(UpdateQueueNode next) {
                NEXT_HANDLE.setVolatile(this, next);
            }

            private final UpdateQueueNode compareExchangeNextVolatile(UpdateQueueNode expect, UpdateQueueNode set) {
                return NEXT_HANDLE.compareAndExchange(this, expect, set);
            }

            private final boolean getUpdatingVolatile() {
                return UPDATING_HANDLE.getVolatile(this);
            }

            private final boolean getAndSetUpdatingVolatile(boolean value) {
                return UPDATING_HANDLE.getAndSet(this, value);
            }
        }
    }

    private static final class Section {
        private final short[] levels = new short[4096];
        private final ShortOpenHashSet sources = new ShortOpenHashSet();
        private static final byte NO_QUEUED_UPDATE = -1;
        private final Short2ByteLinkedOpenHashMap queuedSources = new Short2ByteLinkedOpenHashMap();
        private int oneRadNeighboursWithSources;
        public final int sectionX;
        public final int sectionZ;

        public Section(int sectionX, int sectionZ) {
            this.queuedSources.defaultReturnValue((byte)-1);
            this.oneRadNeighboursWithSources = 0;
            this.sectionX = sectionX;
            this.sectionZ = sectionZ;
        }

        public boolean isZero() {
            for (short val : this.levels) {
                if (val == 0) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            StringBuilder ret = new StringBuilder();
            for (int x = 0; x < 64; ++x) {
                short v;
                int z;
                ret.append("levels x=").append(x).append("\n");
                for (z = 0; z < 64; ++z) {
                    v = this.levels[x | z << 6];
                    ret.append(v & 0xFF).append(".");
                }
                ret.append("\n");
                ret.append("sources x=").append(x).append("\n");
                for (z = 0; z < 64; ++z) {
                    v = this.levels[x | z << 6];
                    ret.append(v >>> 8 & 0xFF).append(".");
                }
                ret.append("\n\n");
            }
            return ret.toString();
        }
    }

    private static final class Propagator {
        private static final ThreadLocal<Propagator> PROPAGATOR = new ThreadLocal();
        private static final int SECTION_RADIUS = 2;
        private static final int SECTION_CACHE_WIDTH = 5;
        private static final int COORDINATE_BITS = 9;
        private static final int COORDINATE_SIZE = 512;
        private final Section[] sections = new Section[25];
        private int encodeOffsetX;
        private int encodeOffsetZ;
        private int coordinateOffset;
        private int encodeSectionOffsetX;
        private int encodeSectionOffsetZ;
        private int sectionIndexOffset;
        private static final long ALL_DIRECTIONS_BITSET = 1879L;
        private static final long FLAG_WRITE_LEVEL = 0x4000000000000000L;
        private static final long FLAG_RECHECK_LEVEL = Long.MIN_VALUE;
        private long[] increaseQueue = new long[8192];
        private int increaseQueueInitialLength;
        private long[] decreaseQueue = new long[8192];
        private int decreaseQueueInitialLength;
        private final Long2ByteLinkedOpenHashMap updatedPositions = new Long2ByteLinkedOpenHashMap();

        private Propagator() {
        }

        private static Propagator acquirePropagator() {
            Propagator ret = PROPAGATOR.get();
            PROPAGATOR.set(null);
            return ret == null ? new Propagator() : ret;
        }

        private static void returnPropagator(Propagator propagator) {
            if (PROPAGATOR.get() == null) {
                PROPAGATOR.set(propagator);
            }
        }

        public final boolean hasUpdates() {
            return this.decreaseQueueInitialLength != 0 || this.increaseQueueInitialLength != 0;
        }

        private final void setupEncodeOffset(int centerSectionX, int centerSectionZ) {
            int maxCoordinate = 127;
            this.encodeOffsetX = 127 - (centerSectionX << 6);
            this.encodeOffsetZ = 127 - (centerSectionZ << 6);
            this.coordinateOffset = this.encodeOffsetX + (this.encodeOffsetZ << 9);
            this.encodeSectionOffsetX = 2 - centerSectionX;
            this.encodeSectionOffsetZ = 2 - centerSectionZ;
            this.sectionIndexOffset = this.encodeSectionOffsetX + this.encodeSectionOffsetZ * 5;
        }

        private final void setupCaches(ThreadedTicketLevelPropagator propagator, int centerSectionX, int centerSectionZ, int rad) {
            for (int dz = -rad; dz <= rad; ++dz) {
                for (int dx = -rad; dx <= rad; ++dx) {
                    int sectionX = centerSectionX + dx;
                    int sectionZ = centerSectionZ + dz;
                    long coordinate = CoordinateUtils.getChunkKey(sectionX, sectionZ);
                    Section section = (Section)propagator.sections.get(coordinate);
                    if (section == null) {
                        throw new IllegalStateException("Section at " + coordinate + " should not be null");
                    }
                    this.setSectionInCache(sectionX, sectionZ, section);
                }
            }
        }

        private final void setSectionInCache(int sectionX, int sectionZ, Section section) {
            this.sections[sectionX + 5 * sectionZ + this.sectionIndexOffset] = section;
        }

        private final Section getSection(int sectionX, int sectionZ) {
            return this.sections[sectionX + 5 * sectionZ + this.sectionIndexOffset];
        }

        private final int getLevel(int posX, int posZ) {
            Section section = this.sections[(posX >> 6) + 5 * (posZ >> 6) + this.sectionIndexOffset];
            if (section != null) {
                return section.levels[posX & 0x3F | (posZ & 0x3F) << 6] & 0xFF;
            }
            return 0;
        }

        private final void setLevel(int posX, int posZ, int to) {
            Section section = this.sections[(posX >> 6) + 5 * (posZ >> 6) + this.sectionIndexOffset];
            if (section != null) {
                int index = posX & 0x3F | (posZ & 0x3F) << 6;
                short level = section.levels[index];
                section.levels[index] = (short)(level & 0xFFFFFF00 | to & 0xFF);
                this.updatedPositions.put(CoordinateUtils.getChunkKey(posX, posZ), (byte)to);
            }
        }

        private final void destroyCaches() {
            Arrays.fill(this.sections, null);
        }

        private final long[] resizeIncreaseQueue() {
            this.increaseQueue = Arrays.copyOf(this.increaseQueue, Math.max(4, this.increaseQueue.length + (this.increaseQueue.length >>> 1)));
            return this.increaseQueue;
        }

        private final long[] resizeDecreaseQueue() {
            this.decreaseQueue = Arrays.copyOf(this.decreaseQueue, Math.max(4, this.decreaseQueue.length + (this.decreaseQueue.length >>> 1)));
            return this.decreaseQueue;
        }

        private final void appendToIncreaseQueue(long value) {
            int idx;
            long[] queue = this.increaseQueue;
            if ((idx = this.increaseQueueInitialLength++) >= queue.length) {
                queue = this.resizeIncreaseQueue();
                queue[idx] = value;
                return;
            }
            queue[idx] = value;
        }

        private final void appendToDecreaseQueue(long value) {
            int idx;
            long[] queue = this.decreaseQueue;
            if ((idx = this.decreaseQueueInitialLength++) >= queue.length) {
                queue = this.resizeDecreaseQueue();
                queue[idx] = value;
                return;
            }
            queue[idx] = value;
        }

        private final void performIncrease() {
            long[] queue = this.increaseQueue;
            int queueReadIndex = 0;
            int queueLength = this.increaseQueueInitialLength;
            this.increaseQueueInitialLength = 0;
            int decodeOffsetX = -this.encodeOffsetX;
            int decodeOffsetZ = -this.encodeOffsetZ;
            int encodeOffset = this.coordinateOffset;
            int sectionOffset = this.sectionIndexOffset;
            Long2ByteLinkedOpenHashMap updatedPositions = this.updatedPositions;
            while (queueReadIndex < queueLength) {
                long queueValue = queue[queueReadIndex++];
                int posX = ((int)queueValue & 0x1FF) + decodeOffsetX;
                int posZ = ((int)queueValue >>> 9 & 0x1FF) + decodeOffsetZ;
                int propagatedLevel = (int)queueValue >>> 18 & 0x3F;
                int propagateDirectionBitset = (int)(queueValue >>> 24) & 0xFFFF;
                if ((queueValue & Long.MIN_VALUE) != 0L) {
                    if (this.getLevel(posX, posZ) != propagatedLevel) {
                        continue;
                    }
                } else if ((queueValue & 0x4000000000000000L) != 0L) {
                    this.setLevel(posX, posZ, propagatedLevel);
                }
                long currentPropagation = -235802113L;
                int toPropagate = propagatedLevel - 1;
                int len = Integer.bitCount(propagateDirectionBitset);
                for (int l = 0; l < len; ++l) {
                    int set = Integer.numberOfTrailingZeros(propagateDirectionBitset);
                    int tailingBit = -propagateDirectionBitset & propagateDirectionBitset;
                    propagateDirectionBitset ^= tailingBit;
                    int pDecodeX = set & 3;
                    int pDecodeZ = set >>> 2 & 3;
                    int offX = posX - 1 + pDecodeX;
                    int offZ = posZ - 1 + pDecodeZ;
                    int sectionIndex = (offX >> 6) + (offZ >> 6) * 5 + sectionOffset;
                    int localIndex = offX & 0x3F | (offZ & 0x3F) << 6;
                    int start = pDecodeX | pDecodeZ << 3;
                    long bitsetLine1 = currentPropagation & 7L << start;
                    long bitsetLine2 = currentPropagation & 7L << start + 8;
                    long bitsetLine3 = currentPropagation & 7L << start + 16;
                    currentPropagation ^= bitsetLine1 | bitsetLine2 | bitsetLine3;
                    Section section = this.sections[sectionIndex];
                    short currentStoredLevel = section.levels[localIndex];
                    int currentLevel = currentStoredLevel & 0xFF;
                    if (currentLevel >= toPropagate) continue;
                    section.levels[localIndex] = (short)(currentStoredLevel & 0xFFFFFF00 | toPropagate & 0xFF);
                    updatedPositions.putAndMoveToLast(CoordinateUtils.getChunkKey(offX, offZ), (byte)toPropagate);
                    if (toPropagate <= 1) continue;
                    long childPropagation = bitsetLine1 >>> start << 24 | bitsetLine2 >>> start + 8 << 28 | bitsetLine3 >>> start + 16 << 32;
                    if (queueLength >= queue.length) {
                        queue = this.resizeIncreaseQueue();
                    }
                    queue[queueLength++] = (long)(offX + (offZ << 9) + encodeOffset) & 0x3FFFFL | ((long)toPropagate & 0x3FL) << 18 | childPropagation;
                }
            }
        }

        private final void performDecrease() {
            long[] queue = this.decreaseQueue;
            long[] increaseQueue = this.increaseQueue;
            int queueReadIndex = 0;
            int queueLength = this.decreaseQueueInitialLength;
            this.decreaseQueueInitialLength = 0;
            int increaseQueueLength = this.increaseQueueInitialLength;
            int decodeOffsetX = -this.encodeOffsetX;
            int decodeOffsetZ = -this.encodeOffsetZ;
            int encodeOffset = this.coordinateOffset;
            int sectionOffset = this.sectionIndexOffset;
            Long2ByteLinkedOpenHashMap updatedPositions = this.updatedPositions;
            while (queueReadIndex < queueLength) {
                long queueValue = queue[queueReadIndex++];
                int posX = ((int)queueValue & 0x1FF) + decodeOffsetX;
                int posZ = ((int)queueValue >>> 9 & 0x1FF) + decodeOffsetZ;
                int propagatedLevel = (int)queueValue >>> 18 & 0x3F;
                int propagateDirectionBitset = (int)(queueValue >>> 24) & 0xFFFF;
                long currentPropagation = -235802113L;
                int toPropagate = propagatedLevel - 1;
                int len = Integer.bitCount(propagateDirectionBitset);
                for (int l = 0; l < len; ++l) {
                    int set = Integer.numberOfTrailingZeros(propagateDirectionBitset);
                    int tailingBit = -propagateDirectionBitset & propagateDirectionBitset;
                    propagateDirectionBitset ^= tailingBit;
                    int pDecodeX = set & 3;
                    int pDecodeZ = set >>> 2 & 3;
                    int offX = posX - 1 + pDecodeX;
                    int offZ = posZ - 1 + pDecodeZ;
                    int sectionIndex = (offX >> 6) + (offZ >> 6) * 5 + sectionOffset;
                    int localIndex = offX & 0x3F | (offZ & 0x3F) << 6;
                    int start = pDecodeX | pDecodeZ << 3;
                    long bitsetLine1 = currentPropagation & 7L << start;
                    long bitsetLine2 = currentPropagation & 7L << start + 8;
                    long bitsetLine3 = currentPropagation & 7L << start + 16;
                    Section section = this.sections[sectionIndex];
                    short currentStoredLevel = section.levels[localIndex];
                    int currentLevel = currentStoredLevel & 0xFF;
                    int sourceLevel = currentStoredLevel >>> 8 & 0xFF;
                    if (currentLevel == 0) continue;
                    if (currentLevel > toPropagate) {
                        if (increaseQueueLength >= increaseQueue.length) {
                            increaseQueue = this.resizeIncreaseQueue();
                        }
                        increaseQueue[increaseQueueLength++] = (long)(offX + (offZ << 9) + encodeOffset) & 0x3FFFFL | ((long)currentLevel & 0x3FL) << 18 | 0x8000000757000000L;
                        continue;
                    }
                    section.levels[localIndex] = (short)(currentStoredLevel & 0xFFFFFF00);
                    updatedPositions.putAndMoveToLast(CoordinateUtils.getChunkKey(offX, offZ), (byte)0);
                    if (sourceLevel != 0) {
                        if (increaseQueueLength >= increaseQueue.length) {
                            increaseQueue = this.resizeIncreaseQueue();
                        }
                        increaseQueue[increaseQueueLength++] = (long)(offX + (offZ << 9) + encodeOffset) & 0x3FFFFL | ((long)sourceLevel & 0x3FL) << 18 | 0x4000000757000000L;
                    }
                    long childPropagation = bitsetLine1 >>> start << 24 | bitsetLine2 >>> start + 8 << 28 | bitsetLine3 >>> start + 16 << 32;
                    if (queueLength >= queue.length) {
                        queue = this.resizeDecreaseQueue();
                    }
                    queue[queueLength++] = (long)(offX + (offZ << 9) + encodeOffset) & 0x3FFFFL | ((long)toPropagate & 0x3FL) << 18 | 0x757000000L;
                }
            }
            this.increaseQueueInitialLength = increaseQueueLength;
            this.performIncrease();
        }
    }
}

