/*
 * Decompiled with CFR 0.152.
 */
package ca.spottedleaf.moonrise.patches.starlight.util;

import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.starlight.light.SWMRNibbleArray;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightEngine;
import com.mojang.logging.LogUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.slf4j.Logger;

public final class SaveUtil {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int STARLIGHT_LIGHT_VERSION = 10;
    public static final String BLOCKLIGHT_STATE_TAG = "starlight.blocklight_state";
    public static final String SKYLIGHT_STATE_TAG = "starlight.skylight_state";
    public static final String STARLIGHT_VERSION_TAG = "starlight.light_version";

    public static int getLightVersion() {
        return 10;
    }

    public static void saveLightHook(Level world, ChunkAccess chunk, CompoundTag nbt) {
        try {
            SaveUtil.saveLightHookReal(world, chunk, nbt);
        }
        catch (Throwable ex) {
            LOGGER.warn("Failed to inject light data into save data for chunk " + String.valueOf(chunk.getPos()) + ", chunk light will be recalculated on its next load", ex);
        }
    }

    private static void saveLightHookReal(Level world, ChunkAccess chunk, CompoundTag tag) {
        int i;
        boolean lit;
        if (tag == null) {
            return;
        }
        int minSection = WorldUtil.getMinLightSection(world);
        int maxSection = WorldUtil.getMaxLightSection(world);
        SWMRNibbleArray[] blockNibbles = chunk.starlight$getBlockNibbles();
        SWMRNibbleArray[] skyNibbles = chunk.starlight$getSkyNibbles();
        boolean bl = lit = chunk.isLightCorrect() || !(world instanceof ServerLevel);
        if (lit) {
            tag.putBoolean("isLightOn", false);
        }
        ChunkStatus status = tag.read("Status", ChunkStatus.CODEC).orElse(ChunkStatus.EMPTY);
        CompoundTag[] sections = new CompoundTag[maxSection - minSection + 1];
        ListTag sectionsStored = tag.getListOrEmpty("sections");
        for (i = 0; i < sectionsStored.size(); ++i) {
            CompoundTag sectionStored = sectionsStored.getCompound(i).orElse(null);
            if (sectionStored == null) continue;
            byte k = sectionStored.getByteOr("Y", (byte)0);
            sectionStored.remove("BlockLight");
            sectionStored.remove("SkyLight");
            if (sectionStored.isEmpty()) continue;
            sections[k - minSection] = sectionStored;
        }
        if (lit && status.isOrAfter(ChunkStatus.LIGHT)) {
            for (i = minSection; i <= maxSection; ++i) {
                SWMRNibbleArray.SaveState blockNibble = blockNibbles[i - minSection].getSaveState();
                SWMRNibbleArray.SaveState skyNibble = skyNibbles[i - minSection].getSaveState();
                if (blockNibble == null && skyNibble == null) continue;
                CompoundTag section = sections[i - minSection];
                if (section == null) {
                    section = new CompoundTag();
                    section.putByte("Y", (byte)i);
                    sections[i - minSection] = section;
                }
                if (blockNibble != null) {
                    if (blockNibble.data != null) {
                        section.putByteArray("BlockLight", blockNibble.data);
                    }
                    section.putInt(BLOCKLIGHT_STATE_TAG, blockNibble.state);
                }
                if (skyNibble == null) continue;
                if (skyNibble.data != null) {
                    section.putByteArray("SkyLight", skyNibble.data);
                }
                section.putInt(SKYLIGHT_STATE_TAG, skyNibble.state);
            }
        }
        sectionsStored.clear();
        for (CompoundTag section : sections) {
            if (section == null) continue;
            sectionsStored.add(section);
        }
        tag.put("sections", sectionsStored);
        if (lit) {
            tag.putInt(STARLIGHT_VERSION_TAG, 10);
        }
    }

    public static void loadLightHook(Level world, ChunkPos pos, CompoundTag tag, ChunkAccess into) {
        try {
            SaveUtil.loadLightHookReal(world, pos, tag, into);
        }
        catch (Throwable ex) {
            LOGGER.warn("Failed to load light for chunk " + String.valueOf(pos) + ", light will be recalculated", ex);
        }
    }

    private static void loadLightHookReal(Level world, ChunkPos pos, CompoundTag tag, ChunkAccess into) {
        if (into == null) {
            return;
        }
        int minSection = WorldUtil.getMinLightSection(world);
        int maxSection = WorldUtil.getMaxLightSection(world);
        into.setLightCorrect(false);
        SWMRNibbleArray[] blockNibbles = StarLightEngine.getFilledEmptyLight(world);
        SWMRNibbleArray[] skyNibbles = StarLightEngine.getFilledEmptyLight(world);
        boolean lit = tag.get("isLightOn") != null && tag.getIntOr(STARLIGHT_VERSION_TAG, -1) == 10;
        boolean canReadSky = world.dimensionType().hasSkyLight();
        ChunkStatus status = tag.read("Status", ChunkStatus.CODEC).orElse(ChunkStatus.EMPTY);
        if (lit && status.isOrAfter(ChunkStatus.LIGHT)) {
            ListTag sections = tag.getListOrEmpty("sections");
            for (int i = 0; i < sections.size(); ++i) {
                CompoundTag sectionData = sections.getCompound(i).orElse(null);
                if (sectionData == null) continue;
                byte y = sectionData.getByteOr("Y", (byte)0);
                byte[] blockLight = sectionData.getByteArray("BlockLight").orElse(null);
                blockNibbles[y - minSection] = blockLight != null ? new SWMRNibbleArray((byte[])blockLight.clone(), sectionData.getIntOr(BLOCKLIGHT_STATE_TAG, 0)) : new SWMRNibbleArray(null, sectionData.getIntOr(BLOCKLIGHT_STATE_TAG, 0));
                if (!canReadSky) continue;
                byte[] skyLight = sectionData.getByteArray("SkyLight").orElse(null);
                skyNibbles[y - minSection] = skyLight != null ? new SWMRNibbleArray((byte[])skyLight.clone(), sectionData.getIntOr(SKYLIGHT_STATE_TAG, 0)) : new SWMRNibbleArray(null, sectionData.getIntOr(SKYLIGHT_STATE_TAG, 0));
            }
        }
        into.starlight$setBlockNibbles(blockNibbles);
        into.starlight$setSkyNibbles(skyNibbles);
        into.setLightCorrect(lit);
    }

    private SaveUtil() {
    }
}

