/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.connection;

import com.google.common.base.Preconditions;
import io.papermc.paper.connection.ReadablePlayerCookieConnection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.cookie.ClientboundCookieRequestPacket;
import net.minecraft.network.protocol.cookie.ServerboundCookieResponsePacket;
import net.minecraft.resources.ResourceLocation;
import org.bukkit.NamespacedKey;
import org.bukkit.craftbukkit.util.CraftNamespacedKey;
import org.jspecify.annotations.NullMarked;

@NullMarked
public abstract class ReadablePlayerCookieConnectionImpl
implements ReadablePlayerCookieConnection {
    private final Map<ResourceLocation, CookieFuture> requestedCookies = new ConcurrentHashMap<ResourceLocation, CookieFuture>();
    private final Connection connection;

    public ReadablePlayerCookieConnectionImpl(Connection connection) {
        this.connection = connection;
    }

    public CompletableFuture<byte[]> retrieveCookie(NamespacedKey key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"Cookie key cannot be null");
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        ResourceLocation resourceLocation = CraftNamespacedKey.toMinecraft(key);
        this.requestedCookies.put(resourceLocation, new CookieFuture(resourceLocation, future));
        this.connection.send(new ClientboundCookieRequestPacket(resourceLocation));
        return future;
    }

    public boolean canStoreCookie() {
        return true;
    }

    public boolean handleCookieResponse(ServerboundCookieResponsePacket packet) {
        CookieFuture future = this.requestedCookies.get(packet.key());
        if (future != null) {
            future.future().complete(packet.payload());
            this.requestedCookies.remove(packet.key());
            return true;
        }
        return false;
    }

    public boolean isAwaitingCookies() {
        return !this.requestedCookies.isEmpty();
    }

    public record CookieFuture(ResourceLocation key, CompletableFuture<byte[]> future) {
    }
}

