/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.inventory.recipe;

import net.minecraft.core.Holder;
import net.minecraft.world.item.ItemStack;

public sealed interface ItemOrExact {
    public int getMaxStackSize();

    public boolean matches(ItemStack var1);

    public record Exact(ItemStack stack) implements ItemOrExact
    {
        @Override
        public int getMaxStackSize() {
            return this.stack.getMaxStackSize();
        }

        @Override
        public boolean matches(ItemStack stack) {
            return ItemStack.isSameItemSameComponents(this.stack, stack);
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Exact)) {
                return false;
            }
            Exact otherExact = (Exact)obj;
            return ItemStack.isSameItemSameComponents(this.stack, otherExact.stack);
        }

        @Override
        public int hashCode() {
            return ItemStack.hashItemAndComponents(this.stack);
        }
    }

    public record Item(Holder<net.minecraft.world.item.Item> item) implements ItemOrExact
    {
        public Item(ItemStack stack) {
            this(stack.getItemHolder());
        }

        @Override
        public int getMaxStackSize() {
            return this.item.value().getDefaultMaxStackSize();
        }

        @Override
        public boolean matches(ItemStack stack) {
            return stack.is(this.item);
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof Item)) {
                return false;
            }
            Item otherItem = (Item)obj;
            return this.item.equals(otherItem.item());
        }

        @Override
        public int hashCode() {
            return this.item.hashCode();
        }
    }
}

