/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.logging;

import io.papermc.paper.logging.DelegateLogEvent;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.ExtendedClassInfo;
import org.apache.logging.log4j.core.impl.ExtendedStackTraceElement;
import org.apache.logging.log4j.core.impl.ThrowableProxy;

public class ExtraClassInfoLogEvent
extends DelegateLogEvent {
    private boolean fixed;

    public ExtraClassInfoLogEvent(LogEvent original) {
        super(original);
    }

    @Override
    public ThrowableProxy getThrownProxy() {
        if (this.fixed) {
            return super.getThrownProxy();
        }
        this.rewriteStackTrace(super.getThrownProxy());
        this.fixed = true;
        return super.getThrownProxy();
    }

    private void rewriteStackTrace(ThrowableProxy throwable) {
        ExtendedStackTraceElement[] stackTrace = throwable.getExtendedStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            StackTraceElement element;
            String classLoaderName;
            ExtendedClassInfo classInfo = stackTrace[i].getExtraClassInfo();
            if (!classInfo.getLocation().equals("?") || (classLoaderName = (element = stackTrace[i].getStackTraceElement()).getClassLoaderName()) == null) continue;
            stackTrace[i] = new ExtendedStackTraceElement(element, new ExtendedClassInfo(classInfo.getExact(), classLoaderName, "?"));
        }
        if (throwable.getCauseProxy() != null) {
            this.rewriteStackTrace(throwable.getCauseProxy());
        }
        if (throwable.getSuppressedProxies() != null) {
            for (ThrowableProxy proxy : throwable.getSuppressedProxies()) {
                this.rewriteStackTrace(proxy);
            }
        }
    }
}

