/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.plugin.entrypoint.classloader.group;

import io.papermc.paper.plugin.provider.classloader.ClassLoaderAccess;
import io.papermc.paper.plugin.provider.classloader.ConfiguredPluginClassLoader;
import io.papermc.paper.plugin.provider.classloader.PluginClassLoaderGroup;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class SingletonPluginClassLoaderGroup
implements PluginClassLoaderGroup {
    private final ConfiguredPluginClassLoader configuredPluginClassLoader;
    private final Access access;

    public SingletonPluginClassLoaderGroup(ConfiguredPluginClassLoader configuredPluginClassLoader) {
        this.configuredPluginClassLoader = configuredPluginClassLoader;
        this.access = new Access();
    }

    @Nullable
    public Class<?> getClassByName(String name, boolean resolve, ConfiguredPluginClassLoader requester) {
        try {
            return this.configuredPluginClassLoader.loadClass(name, resolve, false, true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public void remove(ConfiguredPluginClassLoader configuredPluginClassLoader) {
    }

    public void add(ConfiguredPluginClassLoader configuredPluginClassLoader) {
    }

    public ClassLoaderAccess getAccess() {
        return this.access;
    }

    public String toString() {
        return "SingletonPluginClassLoaderGroup{configuredPluginClassLoader=" + String.valueOf(this.configuredPluginClassLoader) + ", access=" + String.valueOf(this.access) + "}";
    }

    @ApiStatus.Internal
    private class Access
    implements ClassLoaderAccess {
        private Access() {
        }

        public boolean canAccess(ConfiguredPluginClassLoader classLoader) {
            return SingletonPluginClassLoaderGroup.this.configuredPluginClassLoader == classLoader;
        }
    }
}

