/*
 * Decompiled with CFR 0.152.
 */
package io.papermc.paper.world.damagesource;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.world.damagesource.CombatEntry;
import io.papermc.paper.world.damagesource.CombatTracker;
import io.papermc.paper.world.damagesource.FallLocationType;
import io.papermc.paper.world.damagesource.PaperCombatEntryWrapper;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.minecraft.Optionull;
import net.minecraft.Util;
import net.minecraft.world.damagesource.FallLocation;
import org.bukkit.entity.LivingEntity;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public record PaperCombatTrackerWrapper(net.minecraft.world.damagesource.CombatTracker handle) implements CombatTracker
{
    private static final BiMap<FallLocation, FallLocationType> FALL_LOCATION_MAPPING = Util.make(() -> {
        HashBiMap map = HashBiMap.create((int)8);
        map.put((Object)FallLocation.GENERIC, (Object)FallLocationType.GENERIC);
        map.put((Object)FallLocation.LADDER, (Object)FallLocationType.LADDER);
        map.put((Object)FallLocation.VINES, (Object)FallLocationType.VINES);
        map.put((Object)FallLocation.WEEPING_VINES, (Object)FallLocationType.WEEPING_VINES);
        map.put((Object)FallLocation.TWISTING_VINES, (Object)FallLocationType.TWISTING_VINES);
        map.put((Object)FallLocation.SCAFFOLDING, (Object)FallLocationType.SCAFFOLDING);
        map.put((Object)FallLocation.OTHER_CLIMBABLE, (Object)FallLocationType.OTHER_CLIMBABLE);
        map.put((Object)FallLocation.WATER, (Object)FallLocationType.WATER);
        return map;
    });

    public LivingEntity getEntity() {
        return this.handle.mob.getBukkitLivingEntity();
    }

    public List<CombatEntry> getCombatEntries() {
        ArrayList<CombatEntry> combatEntries = new ArrayList<CombatEntry>(this.handle.entries.size());
        this.handle.entries.forEach(combatEntry -> combatEntries.add(new PaperCombatEntryWrapper((net.minecraft.world.damagesource.CombatEntry)combatEntry)));
        return combatEntries;
    }

    public void setCombatEntries(List<CombatEntry> combatEntries) {
        this.handle.entries.clear();
        combatEntries.forEach(combatEntry -> this.handle.entries.add(((PaperCombatEntryWrapper)combatEntry).handle()));
    }

    public @Nullable CombatEntry computeMostSignificantFall() {
        net.minecraft.world.damagesource.CombatEntry combatEntry = this.handle.getMostSignificantFall();
        return combatEntry == null ? null : new PaperCombatEntryWrapper(combatEntry);
    }

    public boolean isInCombat() {
        return this.handle.inCombat;
    }

    public boolean isTakingDamage() {
        return this.handle.takingDamage;
    }

    public int getCombatDuration() {
        return this.handle.getCombatDuration();
    }

    public void addCombatEntry(CombatEntry combatEntry) {
        net.minecraft.world.damagesource.CombatEntry entry = ((PaperCombatEntryWrapper)combatEntry).handle();
        this.handle.recordDamageAndCheckCombatState(entry);
    }

    public Component getDeathMessage() {
        return PaperAdventure.asAdventure(this.handle.getDeathMessage());
    }

    public void resetCombatState() {
        this.handle.resetCombatState();
    }

    public FallLocationType calculateFallLocationType() {
        FallLocation fallLocation = FallLocation.getCurrentFallLocation(this.handle().mob);
        return Optionull.map(fallLocation, PaperCombatTrackerWrapper::minecraftToPaper);
    }

    public static FallLocation paperToMinecraft(FallLocationType fallLocationType) {
        FallLocation fallLocation = (FallLocation)FALL_LOCATION_MAPPING.inverse().get((Object)fallLocationType);
        if (fallLocation == null) {
            throw new IllegalArgumentException("Unknown fall location type: " + fallLocationType.id());
        }
        return fallLocation;
    }

    public static FallLocationType minecraftToPaper(FallLocation fallLocation) {
        FallLocationType fallLocationType = (FallLocationType)FALL_LOCATION_MAPPING.get((Object)fallLocation);
        if (fallLocationType == null) {
            throw new IllegalArgumentException("Unknown fall location: " + fallLocation.id());
        }
        return fallLocationType;
    }
}

