/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.BuiltInExceptionProvider;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.Mth;

public interface MinMaxBounds<T extends Number> {
    public static final SimpleCommandExceptionType ERROR_EMPTY = new SimpleCommandExceptionType((Message)Component.translatable("argument.range.empty"));
    public static final SimpleCommandExceptionType ERROR_SWAPPED = new SimpleCommandExceptionType((Message)Component.translatable("argument.range.swapped"));

    public Bounds<T> bounds();

    default public Optional<T> min() {
        return this.bounds().min;
    }

    default public Optional<T> max() {
        return this.bounds().max;
    }

    default public boolean isAny() {
        return this.bounds().isAny();
    }

    public record Bounds<T extends Number>(Optional<T> min, Optional<T> max) {
        public boolean isAny() {
            return this.min().isEmpty() && this.max().isEmpty();
        }

        public DataResult<Bounds<T>> validateSwappedBoundsInCodec() {
            return this.areSwapped() ? DataResult.error(() -> "Swapped bounds in range: " + String.valueOf(this.min()) + " is higher than " + String.valueOf(this.max())) : DataResult.success((Object)this);
        }

        public boolean areSwapped() {
            return this.min.isPresent() && this.max.isPresent() && ((Comparable)((Object)((Number)this.min.get()))).compareTo((Number)this.max.get()) > 0;
        }

        public Optional<T> asPoint() {
            Optional<T> optional1;
            Optional<T> optional = this.min();
            return optional.equals(optional1 = this.max()) ? optional : Optional.empty();
        }

        public static <T extends Number> Bounds<T> any() {
            return new Bounds(Optional.empty(), Optional.empty());
        }

        public static <T extends Number> Bounds<T> exactly(T value) {
            Optional<T> optional = Optional.of(value);
            return new Bounds<T>(optional, optional);
        }

        public static <T extends Number> Bounds<T> between(T min, T max) {
            return new Bounds<T>(Optional.of(min), Optional.of(max));
        }

        public static <T extends Number> Bounds<T> atLeast(T min) {
            return new Bounds<T>(Optional.of(min), Optional.empty());
        }

        public static <T extends Number> Bounds<T> atMost(T max) {
            return new Bounds(Optional.empty(), Optional.of(max));
        }

        public <U extends Number> Bounds<U> map(Function<T, U> mapper) {
            return new Bounds<U>(this.min.map(mapper), this.max.map(mapper));
        }

        static <T extends Number> Codec<Bounds<T>> createCodec(Codec<T> valueCodec) {
            Codec codec = RecordCodecBuilder.create(instance -> instance.group((App)valueCodec.optionalFieldOf("min").forGetter(Bounds::min), (App)valueCodec.optionalFieldOf("max").forGetter(Bounds::max)).apply((Applicative)instance, Bounds::new));
            return Codec.either((Codec)codec, valueCodec).xmap(either -> either.map(bounds -> bounds, object -> Bounds.exactly(object)), bounds -> {
                Optional point = bounds.asPoint();
                return point.isPresent() ? Either.right((Number)point.get()) : Either.left(bounds);
            });
        }

        static <B extends ByteBuf, T extends Number> StreamCodec<B, Bounds<T>> createStreamCodec(final StreamCodec<B, T> valueCodec) {
            return new StreamCodec<B, Bounds<T>>(){
                private static final int MIN_FLAG = 1;
                private static final int MAX_FLAG = 2;

                @Override
                public Bounds<T> decode(B buffer) {
                    byte _byte = buffer.readByte();
                    Optional optional = (_byte & 1) != 0 ? Optional.of((Number)valueCodec.decode(buffer)) : Optional.empty();
                    Optional optional1 = (_byte & 2) != 0 ? Optional.of((Number)valueCodec.decode(buffer)) : Optional.empty();
                    return new Bounds(optional, optional1);
                }

                @Override
                public void encode(B buffer, Bounds<T> value) {
                    Optional<Number> optional = value.min();
                    Optional<Number> optional1 = value.max();
                    buffer.writeByte((optional.isPresent() ? 1 : 0) | (optional1.isPresent() ? 2 : 0));
                    optional.ifPresent(min -> valueCodec.encode(buffer, min));
                    optional1.ifPresent(max -> valueCodec.encode(buffer, max));
                }
            };
        }

        public static <T extends Number> Bounds<T> fromReader(StringReader reader, Function<String, T> converter, Supplier<DynamicCommandExceptionType> errorGetter) throws CommandSyntaxException {
            if (!reader.canRead()) {
                throw ERROR_EMPTY.createWithContext((ImmutableStringReader)reader);
            }
            int cursor = reader.getCursor();
            try {
                Optional<T> number1;
                Optional<T> number = Bounds.readNumber(reader, converter, errorGetter);
                if (reader.canRead(2) && reader.peek() == '.' && reader.peek(1) == '.') {
                    reader.skip();
                    reader.skip();
                    number1 = Bounds.readNumber(reader, converter, errorGetter);
                } else {
                    number1 = number;
                }
                if (number.isEmpty() && number1.isEmpty()) {
                    throw ERROR_EMPTY.createWithContext((ImmutableStringReader)reader);
                }
                return new Bounds<T>(number, number1);
            }
            catch (CommandSyntaxException var6) {
                reader.setCursor(cursor);
                throw new CommandSyntaxException(var6.getType(), var6.getRawMessage(), var6.getInput(), cursor);
            }
        }

        private static <T extends Number> Optional<T> readNumber(StringReader reader, Function<String, T> converter, Supplier<DynamicCommandExceptionType> errorGetter) throws CommandSyntaxException {
            int cursor = reader.getCursor();
            while (reader.canRead() && Bounds.isAllowedInputChar(reader)) {
                reader.skip();
            }
            String sub = reader.getString().substring(cursor, reader.getCursor());
            if (sub.isEmpty()) {
                return Optional.empty();
            }
            try {
                return Optional.of((Number)converter.apply(sub));
            }
            catch (NumberFormatException var6) {
                throw errorGetter.get().createWithContext((ImmutableStringReader)reader, (Object)sub);
            }
        }

        private static boolean isAllowedInputChar(StringReader reader) {
            char c = reader.peek();
            return c >= '0' && c <= '9' || c == '-' || c == '.' && (!reader.canRead(2) || reader.peek(1) != '.');
        }
    }

    public record Ints(Bounds<Integer> bounds, Bounds<Long> boundsSqr) implements MinMaxBounds<Integer>
    {
        public static final Ints ANY = new Ints(Bounds.any());
        public static final Codec<Ints> CODEC = Bounds.createCodec(Codec.INT).validate(Bounds::validateSwappedBoundsInCodec).xmap(Ints::new, Ints::bounds);
        public static final StreamCodec<ByteBuf, Ints> STREAM_CODEC = Bounds.createStreamCodec(ByteBufCodecs.INT).map(Ints::new, Ints::bounds);

        private Ints(Bounds<Integer> bounds) {
            this(bounds, bounds.map(integer -> Mth.square(integer.longValue())));
        }

        public static Ints exactly(int value) {
            return new Ints(Bounds.exactly(value));
        }

        public static Ints between(int min, int max) {
            return new Ints(Bounds.between(min, max));
        }

        public static Ints atLeast(int min) {
            return new Ints(Bounds.atLeast(min));
        }

        public static Ints atMost(int max) {
            return new Ints(Bounds.atMost(max));
        }

        public boolean matches(int value) {
            return !(this.bounds.min.isPresent() && (Integer)this.bounds.min.get() > value || !this.bounds.max.isEmpty() && (Integer)this.bounds.max.get() < value);
        }

        public boolean matchesSqr(long value) {
            return !(this.boundsSqr.min.isPresent() && (Long)this.boundsSqr.min.get() > value || !this.boundsSqr.max.isEmpty() && (Long)this.boundsSqr.max.get() < value);
        }

        public static Ints fromReader(StringReader reader) throws CommandSyntaxException {
            int cursor = reader.getCursor();
            Bounds<Integer> bounds = Bounds.fromReader(reader, Integer::parseInt, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidInt());
            if (bounds.areSwapped()) {
                reader.setCursor(cursor);
                throw ERROR_SWAPPED.createWithContext((ImmutableStringReader)reader);
            }
            return new Ints(bounds);
        }
    }

    public record FloatDegrees(Bounds<Float> bounds) implements MinMaxBounds<Float>
    {
        public static final FloatDegrees ANY = new FloatDegrees(Bounds.any());
        public static final Codec<FloatDegrees> CODEC = Bounds.createCodec(Codec.FLOAT).xmap(FloatDegrees::new, FloatDegrees::bounds);
        public static final StreamCodec<ByteBuf, FloatDegrees> STREAM_CODEC = Bounds.createStreamCodec(ByteBufCodecs.FLOAT).map(FloatDegrees::new, FloatDegrees::bounds);

        public static FloatDegrees fromReader(StringReader reader) throws CommandSyntaxException {
            Bounds<Float> bounds = Bounds.fromReader(reader, Float::parseFloat, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidFloat());
            return new FloatDegrees(bounds);
        }
    }

    public record Doubles(Bounds<Double> bounds, Bounds<Double> boundsSqr) implements MinMaxBounds<Double>
    {
        public static final Doubles ANY = new Doubles(Bounds.any());
        public static final Codec<Doubles> CODEC = Bounds.createCodec(Codec.DOUBLE).validate(Bounds::validateSwappedBoundsInCodec).xmap(Doubles::new, Doubles::bounds);
        public static final StreamCodec<ByteBuf, Doubles> STREAM_CODEC = Bounds.createStreamCodec(ByteBufCodecs.DOUBLE).map(Doubles::new, Doubles::bounds);

        private Doubles(Bounds<Double> bounds) {
            this(bounds, bounds.map(Mth::square));
        }

        public static Doubles exactly(double value) {
            return new Doubles(Bounds.exactly(value));
        }

        public static Doubles between(double min, double max) {
            return new Doubles(Bounds.between(min, max));
        }

        public static Doubles atLeast(double min) {
            return new Doubles(Bounds.atLeast(min));
        }

        public static Doubles atMost(double max) {
            return new Doubles(Bounds.atMost(max));
        }

        public boolean matches(double value) {
            return !(this.bounds.min.isPresent() && (Double)this.bounds.min.get() > value || !this.bounds.max.isEmpty() && (Double)this.bounds.max.get() < value);
        }

        public boolean matchesSqr(double value) {
            return !(this.boundsSqr.min.isPresent() && (Double)this.boundsSqr.min.get() > value || !this.boundsSqr.max.isEmpty() && (Double)this.boundsSqr.max.get() < value);
        }

        public static Doubles fromReader(StringReader reader) throws CommandSyntaxException {
            int cursor = reader.getCursor();
            Bounds<Double> bounds = Bounds.fromReader(reader, Double::parseDouble, () -> ((BuiltInExceptionProvider)CommandSyntaxException.BUILT_IN_EXCEPTIONS).readerInvalidDouble());
            if (bounds.areSwapped()) {
                reader.setCursor(cursor);
                throw ERROR_SWAPPED.createWithContext((ImmutableStringReader)reader);
            }
            return new Doubles(bounds);
        }
    }
}

