/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.mojang.brigadier.tree.CommandNode;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.commands.PermissionCheck;
import org.bukkit.craftbukkit.command.VanillaCommandWrapper;

public interface PermissionSource {
    public boolean hasPermission(int var1);

    default public boolean allowsSelectors() {
        return this.hasPermission(2);
    }

    public record Check<T extends PermissionSource>(int requiredLevel, AtomicReference<CommandNode<CommandSourceStack>> vanillaNode) implements PermissionCheck<T>
    {
        public Check(int requiredLevel) {
            this(requiredLevel, new AtomicReference<CommandNode<CommandSourceStack>>());
        }

        @Override
        public boolean test(T source) {
            CommandNode<CommandSourceStack> currentCommand = this.vanillaNode.get();
            if (currentCommand != null && source instanceof CommandSourceStack) {
                CommandSourceStack commandSourceStack = (CommandSourceStack)source;
                return commandSourceStack.hasPermission(this.requiredLevel, VanillaCommandWrapper.getPermission(currentCommand));
            }
            return source.hasPermission(this.requiredLevel);
        }
    }

    public static interface RestrictedMarker {
    }
}

