/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.item;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.Dictionary;
import net.minecraft.util.parsing.packrat.NamedRule;
import net.minecraft.util.parsing.packrat.Scope;
import net.minecraft.util.parsing.packrat.Term;
import net.minecraft.util.parsing.packrat.commands.Grammar;
import net.minecraft.util.parsing.packrat.commands.ResourceLocationParseRule;
import net.minecraft.util.parsing.packrat.commands.ResourceLookupRule;
import net.minecraft.util.parsing.packrat.commands.StringReaderTerms;
import net.minecraft.util.parsing.packrat.commands.TagParseRule;

public class ComponentPredicateParser {
    public static <T, C, P> Grammar<List<T>> createGrammar(Context<T, C, P> context) {
        Atom atom = Atom.of("top");
        Atom atom1 = Atom.of("type");
        Atom atom2 = Atom.of("any_type");
        Atom atom3 = Atom.of("element_type");
        Atom atom4 = Atom.of("tag_type");
        Atom atom5 = Atom.of("conditions");
        Atom atom6 = Atom.of("alternatives");
        Atom atom7 = Atom.of("term");
        Atom atom8 = Atom.of("negation");
        Atom atom9 = Atom.of("test");
        Atom atom10 = Atom.of("component_type");
        Atom atom11 = Atom.of("predicate_type");
        Atom atom12 = Atom.of("id");
        Atom atom13 = Atom.of("tag");
        Dictionary<StringReader> dictionary = new Dictionary<StringReader>();
        NamedRule<StringReader, ResourceLocation> namedRule = dictionary.put(atom12, ResourceLocationParseRule.INSTANCE);
        NamedRule namedRule1 = dictionary.put(atom, Term.alternative(Term.sequence(dictionary.named(atom1), StringReaderTerms.character('['), Term.cut(), Term.optional(dictionary.named(atom5)), StringReaderTerms.character(']')), dictionary.named(atom1)), scope -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            ((Optional)scope.getOrThrow(atom1)).ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            List list = (List)scope.get(atom5);
            if (list != null) {
                builder.addAll((Iterable)list);
            }
            return builder.build();
        });
        dictionary.put(atom1, Term.alternative(dictionary.named(atom3), Term.sequence(StringReaderTerms.character('#'), Term.cut(), dictionary.named(atom4)), dictionary.named(atom2)), scope -> Optional.ofNullable(scope.getAny(atom3, atom4)));
        dictionary.put(atom2, StringReaderTerms.character('*'), scope -> Unit.INSTANCE);
        dictionary.put(atom3, new ElementLookupRule<T, C, P>(namedRule, context));
        dictionary.put(atom4, new TagLookupRule<T, C, P>(namedRule, context));
        dictionary.put(atom5, Term.sequence(dictionary.named(atom6), Term.optional(Term.sequence(StringReaderTerms.character(','), dictionary.named(atom5)))), scope -> {
            Object object = context.anyOf((List)scope.getOrThrow(atom6));
            return Optional.ofNullable((List)scope.get(atom5)).map(list -> Util.copyAndAdd(object, list)).orElse(List.of(object));
        });
        dictionary.put(atom6, Term.sequence(dictionary.named(atom7), Term.optional(Term.sequence(StringReaderTerms.character('|'), dictionary.named(atom6)))), scope -> {
            Object orThrow = scope.getOrThrow(atom7);
            return Optional.ofNullable((List)scope.get(atom6)).map(list -> Util.copyAndAdd(orThrow, list)).orElse(List.of(orThrow));
        });
        dictionary.put(atom7, Term.alternative(dictionary.named(atom9), Term.sequence(StringReaderTerms.character('!'), dictionary.named(atom8))), scope -> scope.getAnyOrThrow(atom9, atom8));
        dictionary.put(atom8, dictionary.named(atom9), scope -> context.negate(scope.getOrThrow(atom9)));
        dictionary.putComplex(atom9, Term.alternative(Term.sequence(dictionary.named(atom10), StringReaderTerms.character('='), Term.cut(), dictionary.named(atom13)), Term.sequence(dictionary.named(atom11), StringReaderTerms.character('~'), Term.cut(), dictionary.named(atom13)), dictionary.named(atom10)), parseState -> {
            Scope scope = parseState.scope();
            Object object = scope.get(atom11);
            try {
                if (object != null) {
                    Dynamic dynamic = (Dynamic)((Object)((Object)scope.getOrThrow(atom13)));
                    return context.createPredicateTest((ImmutableStringReader)parseState.input(), object, dynamic);
                }
                Object orThrow = scope.getOrThrow(atom10);
                Dynamic dynamic1 = (Dynamic)((Object)((Object)scope.get(atom13)));
                return dynamic1 != null ? context.createComponentTest((ImmutableStringReader)parseState.input(), orThrow, dynamic1) : context.createComponentTest((ImmutableStringReader)parseState.input(), orThrow);
            }
            catch (CommandSyntaxException var9x) {
                parseState.errorCollector().store(parseState.mark(), var9x);
                return null;
            }
        });
        dictionary.put(atom10, new ComponentLookupRule<T, C, P>(namedRule, context));
        dictionary.put(atom11, new PredicateLookupRule<T, C, P>(namedRule, context));
        dictionary.put(atom13, new TagParseRule<Tag>(NbtOps.INSTANCE));
        return new Grammar<List<T>>(dictionary, namedRule1);
    }

    static class ElementLookupRule<T, C, P>
    extends ResourceLookupRule<Context<T, C, P>, T> {
        ElementLookupRule(NamedRule<StringReader, ResourceLocation> idParser, Context<T, C, P> context) {
            super(idParser, context);
        }

        @Override
        protected T validateElement(ImmutableStringReader reader, ResourceLocation elementType) throws Exception {
            return ((Context)this.context).forElementType(reader, elementType);
        }

        @Override
        public Stream<ResourceLocation> possibleResources() {
            return ((Context)this.context).listElementTypes();
        }
    }

    public static interface Context<T, C, P> {
        public T forElementType(ImmutableStringReader var1, ResourceLocation var2) throws CommandSyntaxException;

        public Stream<ResourceLocation> listElementTypes();

        public T forTagType(ImmutableStringReader var1, ResourceLocation var2) throws CommandSyntaxException;

        public Stream<ResourceLocation> listTagTypes();

        public C lookupComponentType(ImmutableStringReader var1, ResourceLocation var2) throws CommandSyntaxException;

        public Stream<ResourceLocation> listComponentTypes();

        public T createComponentTest(ImmutableStringReader var1, C var2, Dynamic<?> var3) throws CommandSyntaxException;

        public T createComponentTest(ImmutableStringReader var1, C var2);

        public P lookupPredicateType(ImmutableStringReader var1, ResourceLocation var2) throws CommandSyntaxException;

        public Stream<ResourceLocation> listPredicateTypes();

        public T createPredicateTest(ImmutableStringReader var1, P var2, Dynamic<?> var3) throws CommandSyntaxException;

        public T negate(T var1);

        public T anyOf(List<T> var1);
    }

    static class TagLookupRule<T, C, P>
    extends ResourceLookupRule<Context<T, C, P>, T> {
        TagLookupRule(NamedRule<StringReader, ResourceLocation> idParser, Context<T, C, P> context) {
            super(idParser, context);
        }

        @Override
        protected T validateElement(ImmutableStringReader reader, ResourceLocation elementType) throws Exception {
            return ((Context)this.context).forTagType(reader, elementType);
        }

        @Override
        public Stream<ResourceLocation> possibleResources() {
            return ((Context)this.context).listTagTypes();
        }
    }

    static class ComponentLookupRule<T, C, P>
    extends ResourceLookupRule<Context<T, C, P>, C> {
        ComponentLookupRule(NamedRule<StringReader, ResourceLocation> idParser, Context<T, C, P> context) {
            super(idParser, context);
        }

        @Override
        protected C validateElement(ImmutableStringReader reader, ResourceLocation elementType) throws Exception {
            return ((Context)this.context).lookupComponentType(reader, elementType);
        }

        @Override
        public Stream<ResourceLocation> possibleResources() {
            return ((Context)this.context).listComponentTypes();
        }
    }

    static class PredicateLookupRule<T, C, P>
    extends ResourceLookupRule<Context<T, C, P>, P> {
        PredicateLookupRule(NamedRule<StringReader, ResourceLocation> idParser, Context<T, C, P> context) {
            super(idParser, context);
        }

        @Override
        protected P validateElement(ImmutableStringReader reader, ResourceLocation elementType) throws Exception {
            return ((Context)this.context).lookupPredicateType(reader, elementType);
        }

        @Override
        public Stream<ResourceLocation> possibleResources() {
            return ((Context)this.context).listPredicateTypes();
        }
    }
}

