/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.item;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.ReferenceArraySet;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.mutable.MutableObject;

public class ItemParser {
    static final DynamicCommandExceptionType ERROR_UNKNOWN_ITEM = new DynamicCommandExceptionType(itemId -> Component.translatableEscape("argument.item.id.invalid", itemId));
    static final DynamicCommandExceptionType ERROR_UNKNOWN_COMPONENT = new DynamicCommandExceptionType(itemTag -> Component.translatableEscape("arguments.item.component.unknown", itemTag));
    static final Dynamic2CommandExceptionType ERROR_MALFORMED_COMPONENT = new Dynamic2CommandExceptionType((component, value) -> Component.translatableEscape("arguments.item.component.malformed", component, value));
    static final SimpleCommandExceptionType ERROR_EXPECTED_COMPONENT = new SimpleCommandExceptionType((Message)Component.translatable("arguments.item.component.expected"));
    static final DynamicCommandExceptionType ERROR_REPEATED_COMPONENT = new DynamicCommandExceptionType(component -> Component.translatableEscape("arguments.item.component.repeated", component));
    private static final DynamicCommandExceptionType ERROR_MALFORMED_ITEM = new DynamicCommandExceptionType(item -> Component.translatableEscape("arguments.item.malformed", item));
    public static final char SYNTAX_START_COMPONENTS = '[';
    public static final char SYNTAX_END_COMPONENTS = ']';
    public static final char SYNTAX_COMPONENT_SEPARATOR = ',';
    public static final char SYNTAX_COMPONENT_ASSIGNMENT = '=';
    public static final char SYNTAX_REMOVED_COMPONENT = '!';
    static final Function<SuggestionsBuilder, CompletableFuture<Suggestions>> SUGGEST_NOTHING = SuggestionsBuilder::buildFuture;
    final HolderLookup.RegistryLookup<Item> items;
    final RegistryOps<Tag> registryOps;
    final TagParser<Tag> tagParser;

    public ItemParser(HolderLookup.Provider registries) {
        this.items = registries.lookupOrThrow(Registries.ITEM);
        this.registryOps = registries.createSerializationContext(NbtOps.INSTANCE);
        this.tagParser = TagParser.create(this.registryOps);
    }

    public ItemResult parse(StringReader reader) throws CommandSyntaxException {
        final MutableObject mutableObject = new MutableObject();
        final DataComponentPatch.Builder builder = DataComponentPatch.builder();
        this.parse(reader, new Visitor(){

            @Override
            public void visitItem(Holder<Item> item) {
                mutableObject.setValue(item);
            }

            @Override
            public <T> void visitComponent(DataComponentType<T> component, T value) {
                builder.set(component, value);
            }

            @Override
            public <T> void visitRemovedComponent(DataComponentType<T> component) {
                builder.remove(component);
            }
        });
        Holder holder = Objects.requireNonNull((Holder)mutableObject.getValue(), "Parser gave no item");
        DataComponentPatch dataComponentPatch = builder.build();
        ItemParser.validateComponents(reader, holder, dataComponentPatch);
        return new ItemResult(holder, dataComponentPatch);
    }

    private static void validateComponents(StringReader reader, Holder<Item> item, DataComponentPatch components) throws CommandSyntaxException {
        PatchedDataComponentMap dataComponentMap = PatchedDataComponentMap.fromPatch(item.value().components(), components);
        DataResult<Unit> dataResult = ItemStack.validateComponents(dataComponentMap);
        dataResult.getOrThrow(value -> ERROR_MALFORMED_ITEM.createWithContext((ImmutableStringReader)reader, value));
    }

    public void parse(StringReader reader, Visitor visitor) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        try {
            new State(reader, visitor).parse();
        }
        catch (CommandSyntaxException var5) {
            reader.setCursor(cursor);
            throw var5;
        }
    }

    public CompletableFuture<Suggestions> fillSuggestions(SuggestionsBuilder builder) {
        StringReader stringReader = new StringReader(builder.getInput());
        stringReader.setCursor(builder.getStart());
        SuggestionsVisitor suggestionsVisitor = new SuggestionsVisitor();
        State state = new State(stringReader, suggestionsVisitor);
        try {
            state.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return suggestionsVisitor.resolveSuggestions(builder, stringReader);
    }

    public static interface Visitor {
        default public void visitItem(Holder<Item> item) {
        }

        default public <T> void visitComponent(DataComponentType<T> component, T value) {
        }

        default public <T> void visitRemovedComponent(DataComponentType<T> component) {
        }

        default public void visitSuggestions(Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestions) {
        }
    }

    public record ItemResult(Holder<Item> item, DataComponentPatch components) {
    }

    class State {
        private final StringReader reader;
        private final Visitor visitor;

        State(StringReader reader, Visitor visitor) {
            this.reader = reader;
            this.visitor = visitor;
        }

        public void parse() throws CommandSyntaxException {
            this.visitor.visitSuggestions(this::suggestItem);
            this.readItem();
            this.visitor.visitSuggestions(this::suggestStartComponents);
            if (this.reader.canRead() && this.reader.peek() == '[') {
                this.visitor.visitSuggestions(SUGGEST_NOTHING);
                this.readComponents();
            }
        }

        private void readItem() throws CommandSyntaxException {
            int cursor = this.reader.getCursor();
            ResourceLocation resourceLocation = ResourceLocation.read(this.reader);
            this.visitor.visitItem((Holder<Item>)ItemParser.this.items.get(ResourceKey.create(Registries.ITEM, resourceLocation)).orElseThrow(() -> {
                this.reader.setCursor(cursor);
                return ERROR_UNKNOWN_ITEM.createWithContext((ImmutableStringReader)this.reader, (Object)resourceLocation);
            }));
        }

        private void readComponents() throws CommandSyntaxException {
            this.reader.expect('[');
            this.visitor.visitSuggestions(this::suggestComponentAssignmentOrRemoval);
            ReferenceArraySet set = new ReferenceArraySet();
            while (this.reader.canRead() && this.reader.peek() != ']') {
                this.reader.skipWhitespace();
                if (this.reader.canRead() && this.reader.peek() == '!') {
                    this.reader.skip();
                    this.visitor.visitSuggestions(this::suggestComponent);
                    componentType = State.readComponentType(this.reader);
                    if (!set.add(componentType)) {
                        throw ERROR_REPEATED_COMPONENT.create(componentType);
                    }
                    this.visitor.visitRemovedComponent(componentType);
                    this.visitor.visitSuggestions(SUGGEST_NOTHING);
                    this.reader.skipWhitespace();
                } else {
                    componentType = State.readComponentType(this.reader);
                    if (!set.add(componentType)) {
                        throw ERROR_REPEATED_COMPONENT.create(componentType);
                    }
                    this.visitor.visitSuggestions(this::suggestAssignment);
                    this.reader.skipWhitespace();
                    this.reader.expect('=');
                    this.visitor.visitSuggestions(SUGGEST_NOTHING);
                    this.reader.skipWhitespace();
                    this.readComponent(ItemParser.this.tagParser, ItemParser.this.registryOps, componentType);
                    this.reader.skipWhitespace();
                }
                this.visitor.visitSuggestions(this::suggestNextOrEndComponents);
                if (!this.reader.canRead() || this.reader.peek() != ',') break;
                this.reader.skip();
                this.reader.skipWhitespace();
                this.visitor.visitSuggestions(this::suggestComponentAssignmentOrRemoval);
                if (this.reader.canRead()) continue;
                throw ERROR_EXPECTED_COMPONENT.createWithContext((ImmutableStringReader)this.reader);
            }
            this.reader.expect(']');
            this.visitor.visitSuggestions(SUGGEST_NOTHING);
        }

        public static DataComponentType<?> readComponentType(StringReader reader) throws CommandSyntaxException {
            if (!reader.canRead()) {
                throw ERROR_EXPECTED_COMPONENT.createWithContext((ImmutableStringReader)reader);
            }
            int cursor = reader.getCursor();
            ResourceLocation resourceLocation = ResourceLocation.read(reader);
            DataComponentType<?> dataComponentType = BuiltInRegistries.DATA_COMPONENT_TYPE.getValue(resourceLocation);
            if (dataComponentType != null && !dataComponentType.isTransient()) {
                return dataComponentType;
            }
            reader.setCursor(cursor);
            throw ERROR_UNKNOWN_COMPONENT.createWithContext((ImmutableStringReader)reader, (Object)resourceLocation);
        }

        private <T, O> void readComponent(TagParser<O> tagParser, RegistryOps<O> ops, DataComponentType<T> component) throws CommandSyntaxException {
            int cursor = this.reader.getCursor();
            O object = tagParser.parseAsArgument(this.reader);
            DataResult dataResult = component.codecOrThrow().parse(ops, object);
            this.visitor.visitComponent(component, dataResult.getOrThrow(string -> {
                this.reader.setCursor(cursor);
                return ERROR_MALFORMED_COMPONENT.createWithContext((ImmutableStringReader)this.reader, (Object)component.toString(), string);
            }));
        }

        private CompletableFuture<Suggestions> suggestStartComponents(SuggestionsBuilder builder) {
            if (builder.getRemaining().isEmpty()) {
                builder.suggest(String.valueOf('['));
            }
            return builder.buildFuture();
        }

        private CompletableFuture<Suggestions> suggestNextOrEndComponents(SuggestionsBuilder builder) {
            if (builder.getRemaining().isEmpty()) {
                builder.suggest(String.valueOf(','));
                builder.suggest(String.valueOf(']'));
            }
            return builder.buildFuture();
        }

        private CompletableFuture<Suggestions> suggestAssignment(SuggestionsBuilder builder) {
            if (builder.getRemaining().isEmpty()) {
                builder.suggest(String.valueOf('='));
            }
            return builder.buildFuture();
        }

        private CompletableFuture<Suggestions> suggestItem(SuggestionsBuilder builder) {
            return SharedSuggestionProvider.suggestResource(ItemParser.this.items.listElementIds().map(ResourceKey::location), builder);
        }

        private CompletableFuture<Suggestions> suggestComponentAssignmentOrRemoval(SuggestionsBuilder builder) {
            builder.suggest(String.valueOf('!'));
            return this.suggestComponent(builder, String.valueOf('='));
        }

        private CompletableFuture<Suggestions> suggestComponent(SuggestionsBuilder builder) {
            return this.suggestComponent(builder, "");
        }

        private CompletableFuture<Suggestions> suggestComponent(SuggestionsBuilder builder, String suffix) {
            String string = builder.getRemaining().toLowerCase(Locale.ROOT);
            SharedSuggestionProvider.filterResources(BuiltInRegistries.DATA_COMPONENT_TYPE.entrySet(), string, entry -> ((ResourceKey)entry.getKey()).location(), entry -> {
                DataComponentType dataComponentType = (DataComponentType)entry.getValue();
                if (dataComponentType.codec() != null) {
                    ResourceLocation resourceLocation = ((ResourceKey)entry.getKey()).location();
                    builder.suggest(String.valueOf(resourceLocation) + suffix);
                }
            });
            return builder.buildFuture();
        }
    }

    static class SuggestionsVisitor
    implements Visitor {
        private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestions = SUGGEST_NOTHING;

        SuggestionsVisitor() {
        }

        @Override
        public void visitSuggestions(Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestions) {
            this.suggestions = suggestions;
        }

        public CompletableFuture<Suggestions> resolveSuggestions(SuggestionsBuilder builder, StringReader reader) {
            return this.suggestions.apply(builder.createOffset(reader.getCursor()));
        }
    }
}

