/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class NbtOps
implements DynamicOps<Tag> {
    public static final NbtOps INSTANCE = new NbtOps();

    private NbtOps() {
    }

    public Tag empty() {
        return EndTag.INSTANCE;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <U> U convertTo(DynamicOps<U> outOps, Tag input) {
        Tag tag = input;
        Objects.requireNonNull(tag);
        Tag tag2 = tag;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EndTag.class, ByteTag.class, ShortTag.class, IntTag.class, LongTag.class, FloatTag.class, DoubleTag.class, ByteArrayTag.class, StringTag.class, ListTag.class, CompoundTag.class, IntArrayTag.class, LongArrayTag.class}, (Object)tag2, n)) {
            case 0: {
                EndTag endTag = (EndTag)tag2;
                Object object = outOps.empty();
                return (U)object;
            }
            case 1: {
                byte var34;
                ByteTag byteTag = (ByteTag)tag2;
                try {
                    byte by;
                    var34 = by = byteTag.value();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Object object = outOps.createByte(var34);
                return (U)object;
            }
            case 2: {
                short var35;
                ShortTag shortTag = (ShortTag)tag2;
                {
                    short s;
                    var35 = s = shortTag.value();
                }
                Object object = outOps.createShort(var35);
                return (U)object;
            }
            case 3: {
                int var36;
                IntTag intTag = (IntTag)tag2;
                {
                    int n2;
                    var36 = n2 = intTag.value();
                }
                Object object = outOps.createInt(var36);
                return (U)object;
            }
            case 4: {
                long var37;
                LongTag longTag = (LongTag)tag2;
                {
                    long l;
                    var37 = l = longTag.value();
                }
                Object object = outOps.createLong(var37);
                return (U)object;
            }
            case 5: {
                float var38;
                FloatTag floatTag = (FloatTag)tag2;
                {
                    float f;
                    var38 = f = floatTag.value();
                }
                Object object = outOps.createFloat(var38);
                return (U)object;
            }
            case 6: {
                double var39;
                DoubleTag doubleTag = (DoubleTag)tag2;
                {
                    double d;
                    var39 = d = doubleTag.value();
                }
                Object object = outOps.createDouble(var39);
                return (U)object;
            }
            case 7: {
                ByteArrayTag byteArrayTag = (ByteArrayTag)tag2;
                Object object = outOps.createByteList(ByteBuffer.wrap(byteArrayTag.getAsByteArray()));
                return (U)object;
            }
            case 8: {
                String var40;
                StringTag stringTag = (StringTag)tag2;
                {
                    String string;
                    var40 = string = stringTag.value();
                }
                Object object = outOps.createString(var40);
                return (U)object;
            }
            case 9: {
                ListTag listTag = (ListTag)tag2;
                Object object = this.convertList(outOps, listTag);
                return (U)object;
            }
            case 10: {
                CompoundTag compoundTag = (CompoundTag)tag2;
                Object object = this.convertMap(outOps, compoundTag);
                return (U)object;
            }
            case 11: {
                IntArrayTag intArrayTag = (IntArrayTag)tag2;
                Object object = outOps.createIntList(Arrays.stream(intArrayTag.getAsIntArray()));
                return (U)object;
            }
            case 12: {
                LongArrayTag longArrayTag = (LongArrayTag)tag2;
                Object object = outOps.createLongList(Arrays.stream(longArrayTag.getAsLongArray()));
                return (U)object;
            }
        }
        throw new MatchException(null, null);
    }

    public DataResult<Number> getNumberValue(Tag input) {
        return input.asNumber().map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Not a number"));
    }

    public Tag createNumeric(Number i) {
        return DoubleTag.valueOf(i.doubleValue());
    }

    public Tag createByte(byte value) {
        return ByteTag.valueOf(value);
    }

    public Tag createShort(short value) {
        return ShortTag.valueOf(value);
    }

    public Tag createInt(int value) {
        return IntTag.valueOf(value);
    }

    public Tag createLong(long value) {
        return LongTag.valueOf(value);
    }

    public Tag createFloat(float value) {
        return FloatTag.valueOf(value);
    }

    public Tag createDouble(double value) {
        return DoubleTag.valueOf(value);
    }

    public Tag createBoolean(boolean value) {
        return ByteTag.valueOf(value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataResult<String> getStringValue(Tag input) {
        String var4;
        DataResult dataResult;
        if (!(input instanceof StringTag)) {
            dataResult = DataResult.error(() -> "Not a string");
            return dataResult;
        }
        StringTag stringTag = (StringTag)input;
        try {
            String string;
            var4 = string = stringTag.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        dataResult = DataResult.success((Object)var4);
        return dataResult;
    }

    public Tag createString(String value) {
        return StringTag.valueOf(value);
    }

    public DataResult<Tag> mergeToList(Tag list, Tag value) {
        return NbtOps.createCollector(list).map(listCollector -> DataResult.success((Object)listCollector.accept(value).result())).orElseGet(() -> DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(list), (Object)list));
    }

    public DataResult<Tag> mergeToList(Tag list, List<Tag> value) {
        return NbtOps.createCollector(list).map(listCollector -> DataResult.success((Object)listCollector.acceptAll(value).result())).orElseGet(() -> DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(list), (Object)list));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataResult<Tag> mergeToMap(Tag map, Tag key, Tag value) {
        CompoundTag compoundTag;
        String compoundTag2;
        if (!(map instanceof CompoundTag) && !(map instanceof EndTag)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(map), (Object)map);
        }
        if (!(key instanceof StringTag)) return DataResult.error(() -> "key is not a string: " + String.valueOf(key), (Object)map);
        StringTag stringTag = (StringTag)key;
        try {
            String string;
            String var10;
            compoundTag2 = var10 = (string = stringTag.value());
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (map instanceof CompoundTag) {
            CompoundTag compoundTagx = (CompoundTag)map;
            compoundTag = compoundTagx.shallowCopy();
        } else {
            compoundTag = new CompoundTag();
        }
        CompoundTag compoundTag1 = compoundTag;
        compoundTag1.put(compoundTag2, value);
        return DataResult.success((Object)compoundTag1);
    }

    public DataResult<Tag> mergeToMap(Tag map, MapLike<Tag> values) {
        CompoundTag compoundTag;
        if (!(map instanceof CompoundTag) && !(map instanceof EndTag)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(map), (Object)map);
        }
        if (map instanceof CompoundTag) {
            CompoundTag compoundTag2 = (CompoundTag)map;
            compoundTag = compoundTag2.shallowCopy();
        } else {
            compoundTag = new CompoundTag();
        }
        CompoundTag compoundTag1 = compoundTag;
        ArrayList list = new ArrayList();
        values.entries().forEach(pair -> {
            Tag tag = (Tag)pair.getFirst();
            if (!(tag instanceof StringTag)) {
                list.add(tag);
                return;
            }
            StringTag $b$0 = (StringTag)tag;
            try {
                String patt1$temp;
                String string = patt1$temp = $b$0.value();
                compoundTag1.put(string, (Tag)pair.getSecond());
                return;
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        });
        return !list.isEmpty() ? DataResult.error(() -> "some keys are not strings: " + String.valueOf(list), (Object)compoundTag1) : DataResult.success((Object)compoundTag1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataResult<Tag> mergeToMap(Tag tag, Map<Tag, Tag> map) {
        DataResult dataResult;
        CompoundTag compoundTag;
        if (!(tag instanceof CompoundTag) && !(tag instanceof EndTag)) {
            return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(tag), (Object)tag);
        }
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag2 = (CompoundTag)tag;
            compoundTag = compoundTag2.shallowCopy();
        } else {
            compoundTag = new CompoundTag();
        }
        CompoundTag compoundTag1 = compoundTag;
        ArrayList<Tag> list = new ArrayList<Tag>();
        for (Map.Entry<Tag, Tag> entry : map.entrySet()) {
            Tag tag1 = entry.getKey();
            if (tag1 instanceof StringTag) {
                StringTag stringTag = (StringTag)tag1;
                try {
                    String string;
                    String var10 = string = stringTag.value();
                    compoundTag1.put(var10, entry.getValue());
                    continue;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            list.add(tag1);
        }
        if (!list.isEmpty()) {
            dataResult = DataResult.error(() -> "some keys are not strings: " + String.valueOf(list), (Object)compoundTag1);
            return dataResult;
        }
        dataResult = DataResult.success((Object)compoundTag1);
        return dataResult;
    }

    public DataResult<Stream<Pair<Tag, Tag>>> getMapValues(Tag input) {
        DataResult dataResult;
        if (input instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)input;
            dataResult = DataResult.success(compoundTag.entrySet().stream().map(entry -> Pair.of((Object)this.createString((String)entry.getKey()), (Object)((Tag)entry.getValue()))));
        } else {
            dataResult = DataResult.error(() -> "Not a map: " + String.valueOf(input));
        }
        return dataResult;
    }

    public DataResult<Consumer<BiConsumer<Tag, Tag>>> getMapEntries(Tag input) {
        DataResult dataResult;
        if (input instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)input;
            dataResult = DataResult.success(biConsumer -> {
                for (Map.Entry<String, Tag> entry : compoundTag.entrySet()) {
                    biConsumer.accept(this.createString(entry.getKey()), entry.getValue());
                }
            });
        } else {
            dataResult = DataResult.error(() -> "Not a map: " + String.valueOf(input));
        }
        return dataResult;
    }

    public DataResult<MapLike<Tag>> getMap(Tag input) {
        DataResult dataResult;
        if (input instanceof CompoundTag) {
            final CompoundTag compoundTag = (CompoundTag)input;
            dataResult = DataResult.success((Object)new MapLike<Tag>(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public Tag get(Tag tag) {
                    if (!(tag instanceof StringTag)) throw new UnsupportedOperationException("Cannot get map entry with non-string key: " + String.valueOf(tag));
                    StringTag stringTag = (StringTag)tag;
                    try {
                        String string;
                        String var4 = string = stringTag.value();
                        return compoundTag.get(var4);
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }

                @Nullable
                public Tag get(String string) {
                    return compoundTag.get(string);
                }

                public Stream<Pair<Tag, Tag>> entries() {
                    return compoundTag.entrySet().stream().map(entry -> Pair.of((Object)NbtOps.this.createString((String)entry.getKey()), (Object)((Tag)entry.getValue())));
                }

                public String toString() {
                    return "MapLike[" + String.valueOf(compoundTag) + "]";
                }
            });
        } else {
            dataResult = DataResult.error(() -> "Not a map: " + String.valueOf(input));
        }
        return dataResult;
    }

    public Tag createMap(Stream<Pair<Tag, Tag>> map) {
        CompoundTag compoundTag = new CompoundTag();
        map.forEach(pair -> {
            Tag tag = (Tag)pair.getFirst();
            Tag tag1 = (Tag)pair.getSecond();
            if (!(tag instanceof StringTag)) throw new UnsupportedOperationException("Cannot create map with non-string key: " + String.valueOf(tag));
            StringTag $b$0 = (StringTag)tag;
            try {
                String patt1$temp;
                String string = patt1$temp = $b$0.value();
                compoundTag.put(string, tag1);
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        });
        return compoundTag;
    }

    public DataResult<Stream<Tag>> getStream(Tag input) {
        DataResult dataResult;
        if (input instanceof CollectionTag) {
            CollectionTag collectionTag = (CollectionTag)input;
            dataResult = DataResult.success(collectionTag.stream());
        } else {
            dataResult = DataResult.error(() -> "Not a list");
        }
        return dataResult;
    }

    public DataResult<Consumer<Consumer<Tag>>> getList(Tag input) {
        DataResult dataResult;
        if (input instanceof CollectionTag) {
            CollectionTag collectionTag = (CollectionTag)input;
            dataResult = DataResult.success(collectionTag::forEach);
        } else {
            dataResult = DataResult.error(() -> "Not a list: " + String.valueOf(input));
        }
        return dataResult;
    }

    public DataResult<ByteBuffer> getByteBuffer(Tag input) {
        DataResult dataResult;
        if (input instanceof ByteArrayTag) {
            ByteArrayTag byteArrayTag = (ByteArrayTag)input;
            dataResult = DataResult.success((Object)ByteBuffer.wrap(byteArrayTag.getAsByteArray()));
        } else {
            dataResult = super.getByteBuffer((Object)input);
        }
        return dataResult;
    }

    public Tag createByteList(ByteBuffer input) {
        ByteBuffer byteBuffer = input.duplicate().clear();
        byte[] bytes = new byte[input.capacity()];
        byteBuffer.get(0, bytes, 0, bytes.length);
        return new ByteArrayTag(bytes);
    }

    public DataResult<IntStream> getIntStream(Tag input) {
        DataResult dataResult;
        if (input instanceof IntArrayTag) {
            IntArrayTag intArrayTag = (IntArrayTag)input;
            dataResult = DataResult.success((Object)Arrays.stream(intArrayTag.getAsIntArray()));
        } else {
            dataResult = super.getIntStream((Object)input);
        }
        return dataResult;
    }

    public Tag createIntList(IntStream input) {
        return new IntArrayTag(input.toArray());
    }

    public DataResult<LongStream> getLongStream(Tag input) {
        DataResult dataResult;
        if (input instanceof LongArrayTag) {
            LongArrayTag longArrayTag = (LongArrayTag)input;
            dataResult = DataResult.success((Object)Arrays.stream(longArrayTag.getAsLongArray()));
        } else {
            dataResult = super.getLongStream((Object)input);
        }
        return dataResult;
    }

    public Tag createLongList(LongStream input) {
        return new LongArrayTag(input.toArray());
    }

    public Tag createList(Stream<Tag> input) {
        return new ListTag(input.collect(Util.toMutableList()));
    }

    public Tag remove(Tag input, String key) {
        if (input instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)input;
            CompoundTag compoundTag1 = compoundTag.shallowCopy();
            compoundTag1.remove(key);
            return compoundTag1;
        }
        return input;
    }

    public String toString() {
        return "NBT";
    }

    public RecordBuilder<Tag> mapBuilder() {
        return new NbtRecordBuilder(this);
    }

    private static Optional<ListCollector> createCollector(Tag value) {
        if (value instanceof EndTag) {
            return Optional.of(new GenericListCollector());
        }
        if (value instanceof CollectionTag) {
            CollectionTag collectionTag = (CollectionTag)value;
            if (collectionTag.isEmpty()) {
                return Optional.of(new GenericListCollector());
            }
            CollectionTag collectionTag2 = collectionTag;
            Objects.requireNonNull(collectionTag2);
            CollectionTag collectionTag3 = collectionTag2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ListTag.class, ByteArrayTag.class, IntArrayTag.class, LongArrayTag.class}, (Object)collectionTag3, n)) {
                case 0 -> {
                    ListTag listTag = (ListTag)collectionTag3;
                    yield Optional.of(new GenericListCollector(listTag));
                }
                case 1 -> {
                    ByteArrayTag byteArrayTag = (ByteArrayTag)collectionTag3;
                    yield Optional.of(new ByteListCollector(byteArrayTag.getAsByteArray()));
                }
                case 2 -> {
                    IntArrayTag intArrayTag = (IntArrayTag)collectionTag3;
                    yield Optional.of(new IntListCollector(intArrayTag.getAsIntArray()));
                }
                case 3 -> {
                    LongArrayTag longArrayTag = (LongArrayTag)collectionTag3;
                    yield Optional.of(new LongListCollector(longArrayTag.getAsLongArray()));
                }
                default -> throw new MatchException(null, null);
            };
        }
        return Optional.empty();
    }

    class NbtRecordBuilder
    extends RecordBuilder.AbstractStringBuilder<Tag, CompoundTag> {
        protected NbtRecordBuilder(NbtOps this$0) {
            super((DynamicOps)this$0);
        }

        protected CompoundTag initBuilder() {
            return new CompoundTag();
        }

        protected CompoundTag append(String key, Tag value, CompoundTag tag) {
            tag.put(key, value);
            return tag;
        }

        protected DataResult<Tag> build(CompoundTag compoundTag, Tag tag) {
            if (tag == null || tag == EndTag.INSTANCE) {
                return DataResult.success((Object)compoundTag);
            }
            if (!(tag instanceof CompoundTag)) {
                return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(tag), (Object)tag);
            }
            CompoundTag compoundTag1 = (CompoundTag)tag;
            CompoundTag compoundTag2 = compoundTag1.shallowCopy();
            for (Map.Entry<String, Tag> entry : compoundTag.entrySet()) {
                compoundTag2.put(entry.getKey(), entry.getValue());
            }
            return DataResult.success((Object)compoundTag2);
        }
    }

    static class GenericListCollector
    implements ListCollector {
        private final ListTag result = new ListTag();

        GenericListCollector() {
        }

        GenericListCollector(ListTag list) {
            this.result.addAll(list);
        }

        public GenericListCollector(IntArrayList list) {
            list.forEach(i -> this.result.add(IntTag.valueOf(i)));
        }

        public GenericListCollector(ByteArrayList list) {
            list.forEach(b -> this.result.add(ByteTag.valueOf(b)));
        }

        public GenericListCollector(LongArrayList list) {
            list.forEach(l -> this.result.add(LongTag.valueOf(l)));
        }

        @Override
        public ListCollector accept(Tag tag) {
            this.result.add(tag);
            return this;
        }

        @Override
        public Tag result() {
            return this.result;
        }
    }

    static class ByteListCollector
    implements ListCollector {
        private final ByteArrayList values = new ByteArrayList();

        public ByteListCollector(byte[] values) {
            this.values.addElements(0, values);
        }

        @Override
        public ListCollector accept(Tag tag) {
            if (tag instanceof ByteTag) {
                ByteTag byteTag = (ByteTag)tag;
                this.values.add(byteTag.byteValue());
                return this;
            }
            return new GenericListCollector(this.values).accept(tag);
        }

        @Override
        public Tag result() {
            return new ByteArrayTag(this.values.toByteArray());
        }
    }

    static class IntListCollector
    implements ListCollector {
        private final IntArrayList values = new IntArrayList();

        public IntListCollector(int[] values) {
            this.values.addElements(0, values);
        }

        @Override
        public ListCollector accept(Tag tag) {
            if (tag instanceof IntTag) {
                IntTag intTag = (IntTag)tag;
                this.values.add(intTag.intValue());
                return this;
            }
            return new GenericListCollector(this.values).accept(tag);
        }

        @Override
        public Tag result() {
            return new IntArrayTag(this.values.toIntArray());
        }
    }

    static class LongListCollector
    implements ListCollector {
        private final LongArrayList values = new LongArrayList();

        public LongListCollector(long[] values) {
            this.values.addElements(0, values);
        }

        @Override
        public ListCollector accept(Tag tag) {
            if (tag instanceof LongTag) {
                LongTag longTag = (LongTag)tag;
                this.values.add(longTag.longValue());
                return this;
            }
            return new GenericListCollector(this.values).accept(tag);
        }

        @Override
        public Tag result() {
            return new LongArrayTag(this.values.toLongArray());
        }
    }

    static interface ListCollector {
        public ListCollector accept(Tag var1);

        default public ListCollector acceptAll(Iterable<Tag> tags) {
            ListCollector listCollector = this;
            for (Tag tag : tags) {
                listCollector = listCollector.accept(tag);
            }
            return listCollector;
        }

        default public ListCollector acceptAll(Stream<Tag> tags) {
            return this.acceptAll(tags::iterator);
        }

        public Tag result();
    }
}

