/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt.visitors;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagType;
import net.minecraft.nbt.visitors.CollectToTag;
import net.minecraft.nbt.visitors.FieldSelector;
import net.minecraft.nbt.visitors.FieldTree;

public class CollectFields
extends CollectToTag {
    private int fieldsToGetCount;
    private final Set<TagType<?>> wantedTypes;
    private final Deque<FieldTree> stack = new ArrayDeque<FieldTree>();

    public CollectFields(FieldSelector ... selectors) {
        this.fieldsToGetCount = selectors.length;
        ImmutableSet.Builder builder = ImmutableSet.builder();
        FieldTree fieldTree = FieldTree.createRoot();
        for (FieldSelector fieldSelector : selectors) {
            fieldTree.addEntry(fieldSelector);
            builder.add(fieldSelector.type());
        }
        this.stack.push(fieldTree);
        builder.add(CompoundTag.TYPE);
        this.wantedTypes = builder.build();
    }

    @Override
    public StreamTagVisitor.ValueResult visitRootEntry(TagType<?> type) {
        return type != CompoundTag.TYPE ? StreamTagVisitor.ValueResult.HALT : super.visitRootEntry(type);
    }

    @Override
    public StreamTagVisitor.EntryResult visitEntry(TagType<?> type) {
        FieldTree fieldTree = this.stack.element();
        if (this.depth() > fieldTree.depth()) {
            return super.visitEntry(type);
        }
        if (this.fieldsToGetCount <= 0) {
            return StreamTagVisitor.EntryResult.BREAK;
        }
        return !this.wantedTypes.contains(type) ? StreamTagVisitor.EntryResult.SKIP : super.visitEntry(type);
    }

    @Override
    public StreamTagVisitor.EntryResult visitEntry(TagType<?> type, String id) {
        FieldTree fieldTree1;
        FieldTree fieldTree = this.stack.element();
        if (this.depth() > fieldTree.depth()) {
            return super.visitEntry(type, id);
        }
        if (fieldTree.selectedFields().remove(id, type)) {
            --this.fieldsToGetCount;
            return super.visitEntry(type, id);
        }
        if (type == CompoundTag.TYPE && (fieldTree1 = fieldTree.fieldsToRecurse().get(id)) != null) {
            this.stack.push(fieldTree1);
            return super.visitEntry(type, id);
        }
        return StreamTagVisitor.EntryResult.SKIP;
    }

    @Override
    public StreamTagVisitor.ValueResult visitContainerEnd() {
        if (this.depth() == this.stack.element().depth()) {
            this.stack.pop();
        }
        return super.visitContainerEnd();
    }

    public int getMissingFieldCount() {
        return this.fieldsToGetCount;
    }
}

