/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ReferenceCountUtil;
import net.minecraft.network.PacketDecoder;
import net.minecraft.network.PacketEncoder;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.protocol.Packet;

public class UnconfiguredPipelineHandler {
    public static <T extends PacketListener> InboundConfigurationTask setupInboundProtocol(ProtocolInfo<T> protocolInfo) {
        return UnconfiguredPipelineHandler.setupInboundHandler(new PacketDecoder<T>(protocolInfo));
    }

    private static InboundConfigurationTask setupInboundHandler(ChannelInboundHandler handler) {
        return ctx -> {
            ctx.pipeline().replace(ctx.name(), "decoder", (ChannelHandler)handler);
            ctx.channel().config().setAutoRead(true);
        };
    }

    public static <T extends PacketListener> OutboundConfigurationTask setupOutboundProtocol(ProtocolInfo<T> protocolInfo) {
        return UnconfiguredPipelineHandler.setupOutboundHandler(new PacketEncoder<T>(protocolInfo));
    }

    private static OutboundConfigurationTask setupOutboundHandler(ChannelOutboundHandler handler) {
        return ctx -> ctx.pipeline().replace(ctx.name(), "encoder", (ChannelHandler)handler);
    }

    @FunctionalInterface
    public static interface InboundConfigurationTask {
        public void run(ChannelHandlerContext var1);

        default public InboundConfigurationTask andThen(InboundConfigurationTask task) {
            return ctx -> {
                this.run(ctx);
                task.run(ctx);
            };
        }
    }

    @FunctionalInterface
    public static interface OutboundConfigurationTask {
        public void run(ChannelHandlerContext var1);

        default public OutboundConfigurationTask andThen(OutboundConfigurationTask task) {
            return ctx -> {
                this.run(ctx);
                task.run(ctx);
            };
        }
    }

    public static class Outbound
    extends ChannelOutboundHandlerAdapter {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(ChannelHandlerContext ctx, Object message, ChannelPromise promise) throws Exception {
            if (message instanceof Packet) {
                ReferenceCountUtil.release((Object)message);
                throw new EncoderException("Pipeline has no outbound protocol configured, can't process packet " + String.valueOf(message));
            }
            if (message instanceof OutboundConfigurationTask) {
                OutboundConfigurationTask outboundConfigurationTask = (OutboundConfigurationTask)message;
                try {
                    outboundConfigurationTask.run(ctx);
                }
                finally {
                    ReferenceCountUtil.release((Object)message);
                }
                promise.setSuccess();
            } else {
                ctx.write(message, promise);
            }
        }
    }

    public static class Inbound
    extends ChannelDuplexHandler {
        public void channelRead(ChannelHandlerContext ctx, Object message) {
            if (message instanceof ByteBuf || message instanceof Packet) {
                ReferenceCountUtil.release((Object)message);
                throw new DecoderException("Pipeline has no inbound protocol configured, can't process packet " + String.valueOf(message));
            }
            ctx.fireChannelRead(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(ChannelHandlerContext ctx, Object message, ChannelPromise promise) throws Exception {
            if (message instanceof InboundConfigurationTask) {
                InboundConfigurationTask inboundConfigurationTask = (InboundConfigurationTask)message;
                try {
                    inboundConfigurationTask.run(ctx);
                }
                finally {
                    ReferenceCountUtil.release((Object)message);
                }
                promise.setSuccess();
            } else {
                ctx.write(message, promise);
            }
        }
    }
}

