/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CorruptedFrameException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.BandwidthDebugMonitor;
import net.minecraft.network.VarInt;

public class Varint21FrameDecoder
extends ByteToMessageDecoder {
    private static final int MAX_VARINT21_BYTES = 3;
    private final ByteBuf helperBuf = Unpooled.directBuffer((int)3);
    @Nullable
    private final BandwidthDebugMonitor monitor;

    public Varint21FrameDecoder(@Nullable BandwidthDebugMonitor monitor) {
        this.monitor = monitor;
    }

    protected void handlerRemoved0(ChannelHandlerContext ctx) {
        this.helperBuf.release();
    }

    private static boolean copyVarint(ByteBuf in, ByteBuf out) {
        for (int i = 0; i < 3; ++i) {
            if (!in.isReadable()) {
                return false;
            }
            byte _byte = in.readByte();
            out.writeByte((int)_byte);
            if (VarInt.hasContinuationBit(_byte)) continue;
            return true;
        }
        throw new CorruptedFrameException("length wider than 21-bit");
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (!ctx.channel().isActive()) {
            in.skipBytes(in.readableBytes());
            return;
        }
        in.markReaderIndex();
        this.helperBuf.clear();
        if (!Varint21FrameDecoder.copyVarint(in, this.helperBuf)) {
            in.resetReaderIndex();
        } else {
            int i = VarInt.read(this.helperBuf);
            if (i == 0) {
                throw new CorruptedFrameException("Frame length cannot be zero");
            }
            if (in.readableBytes() < i) {
                in.resetReaderIndex();
            } else {
                if (this.monitor != null) {
                    this.monitor.onReceive(i + VarInt.getByteSize(i));
                }
                out.add(in.readBytes(i));
            }
        }
    }
}

