/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.resources.ResourceLocation;

public class ClientboundCommandsPacket
implements Packet<ClientGamePacketListener> {
    public static final StreamCodec<FriendlyByteBuf, ClientboundCommandsPacket> STREAM_CODEC = Packet.codec(ClientboundCommandsPacket::write, ClientboundCommandsPacket::new);
    private static final byte MASK_TYPE = 3;
    private static final byte FLAG_EXECUTABLE = 4;
    private static final byte FLAG_REDIRECT = 8;
    private static final byte FLAG_CUSTOM_SUGGESTIONS = 16;
    private static final byte FLAG_RESTRICTED = 32;
    private static final byte TYPE_ROOT = 0;
    private static final byte TYPE_LITERAL = 1;
    private static final byte TYPE_ARGUMENT = 2;
    private final int rootIndex;
    private final List<Entry> entries;

    public <S> ClientboundCommandsPacket(RootCommandNode<S> root, NodeInspector<S> nodeInspector) {
        Object2IntMap<CommandNode<S>> map = ClientboundCommandsPacket.enumerateNodes(root);
        this.entries = ClientboundCommandsPacket.createEntries(map, nodeInspector);
        this.rootIndex = map.getInt(root);
    }

    private ClientboundCommandsPacket(FriendlyByteBuf buffer) {
        this.entries = buffer.readList(ClientboundCommandsPacket::readNode);
        this.rootIndex = buffer.readVarInt();
        ClientboundCommandsPacket.validateEntries(this.entries);
    }

    private void write(FriendlyByteBuf buffer) {
        buffer.writeCollection(this.entries, (buffer1, value) -> value.write((FriendlyByteBuf)((Object)buffer1)));
        buffer.writeVarInt(this.rootIndex);
    }

    private static void validateEntries(List<Entry> entries, BiPredicate<Entry, IntSet> validator) {
        IntOpenHashSet set = new IntOpenHashSet((IntCollection)IntSets.fromTo((int)0, (int)entries.size()));
        while (!set.isEmpty()) {
            boolean flag = set.removeIf(arg_0 -> ClientboundCommandsPacket.lambda$validateEntries$1(validator, entries, (IntSet)set, arg_0));
            if (flag) continue;
            throw new IllegalStateException("Server sent an impossible command tree");
        }
    }

    private static void validateEntries(List<Entry> entries) {
        ClientboundCommandsPacket.validateEntries(entries, Entry::canBuild);
        ClientboundCommandsPacket.validateEntries(entries, Entry::canResolve);
    }

    private static <S> Object2IntMap<CommandNode<S>> enumerateNodes(RootCommandNode<S> rootNode) {
        CommandNode commandNode;
        Object2IntOpenHashMap map = new Object2IntOpenHashMap();
        ArrayDeque<Object> queue = new ArrayDeque<Object>();
        queue.add(rootNode);
        while ((commandNode = (CommandNode)queue.poll()) != null) {
            if (map.containsKey((Object)commandNode)) continue;
            int size = map.size();
            map.put((Object)commandNode, size);
            queue.addAll(commandNode.getChildren());
            if (commandNode.getRedirect() == null) continue;
            queue.add(commandNode.getRedirect());
        }
        return map;
    }

    private static <S> List<Entry> createEntries(Object2IntMap<CommandNode<S>> nodes, NodeInspector<S> nodeInspector) {
        ObjectArrayList list = new ObjectArrayList(nodes.size());
        list.size(nodes.size());
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(nodes)) {
            list.set(entry.getIntValue(), (Object)ClientboundCommandsPacket.createEntry((CommandNode)entry.getKey(), nodeInspector, nodes));
        }
        return list;
    }

    private static Entry readNode(FriendlyByteBuf buffer) {
        byte _byte = buffer.readByte();
        int[] varIntArray = buffer.readVarIntArray();
        int i = (_byte & 8) != 0 ? buffer.readVarInt() : 0;
        NodeStub nodeStub = ClientboundCommandsPacket.read(buffer, _byte);
        return new Entry(nodeStub, _byte, i, varIntArray);
    }

    @Nullable
    private static NodeStub read(FriendlyByteBuf buffer, byte flags) {
        int i = flags & 3;
        if (i == 2) {
            String utf = buffer.readUtf();
            int varInt = buffer.readVarInt();
            ArgumentTypeInfo argumentTypeInfo = (ArgumentTypeInfo)BuiltInRegistries.COMMAND_ARGUMENT_TYPE.byId(varInt);
            if (argumentTypeInfo == null) {
                return null;
            }
            Object template = argumentTypeInfo.deserializeFromNetwork(buffer);
            ResourceLocation resourceLocation = (flags & 0x10) != 0 ? buffer.readResourceLocation() : null;
            return new ArgumentNodeStub(utf, (ArgumentTypeInfo.Template<?>)template, resourceLocation);
        }
        if (i == 1) {
            String utf = buffer.readUtf();
            return new LiteralNodeStub(utf);
        }
        return null;
    }

    private static <S> Entry createEntry(CommandNode<S> node, NodeInspector<S> nodeInspector, Object2IntMap<CommandNode<S>> nodes) {
        Record nodeStub;
        int _int;
        int i = 0;
        if (node.getRedirect() != null) {
            i |= 8;
            _int = nodes.getInt(node.getRedirect());
        } else {
            _int = 0;
        }
        if (nodeInspector.isExecutable(node)) {
            i |= 4;
        }
        if (nodeInspector.isRestricted(node)) {
            i |= 0x20;
        }
        CommandNode<S> commandNode = node;
        Objects.requireNonNull(commandNode);
        CommandNode<S> commandNode2 = commandNode;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RootCommandNode.class, ArgumentCommandNode.class, LiteralCommandNode.class}, commandNode2, n)) {
            case 0: {
                RootCommandNode rootCommandNode = (RootCommandNode)commandNode2;
                i |= 0;
                nodeStub = null;
                break;
            }
            case 1: {
                ArgumentCommandNode argumentCommandNode = (ArgumentCommandNode)commandNode2;
                ResourceLocation resourceLocation = nodeInspector.suggestionId(argumentCommandNode);
                nodeStub = new ArgumentNodeStub(argumentCommandNode.getName(), ArgumentTypeInfos.unpack(argumentCommandNode.getType()), resourceLocation);
                i |= 2;
                if (resourceLocation != null) {
                    i |= 0x10;
                }
                break;
            }
            case 2: {
                LiteralCommandNode literalCommandNode = (LiteralCommandNode)commandNode2;
                nodeStub = new LiteralNodeStub(literalCommandNode.getLiteral());
                i |= 1;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown node type " + String.valueOf(node));
            }
        }
        int[] ints = node.getChildren().stream().mapToInt(arg_0 -> nodes.getInt(arg_0)).toArray();
        return new Entry((NodeStub)((Object)nodeStub), i, _int, ints);
    }

    @Override
    public PacketType<ClientboundCommandsPacket> type() {
        return GamePacketTypes.CLIENTBOUND_COMMANDS;
    }

    @Override
    public void handle(ClientGamePacketListener handler) {
        handler.handleCommands(this);
    }

    public <S> RootCommandNode<S> getRoot(CommandBuildContext context, NodeBuilder<S> nodeBuilder) {
        return (RootCommandNode)new NodeResolver<S>(context, nodeBuilder, this.entries).resolve(this.rootIndex);
    }

    private static /* synthetic */ boolean lambda$validateEntries$1(BiPredicate validator, List entries, IntSet set, int i) {
        return validator.test((Entry)entries.get(i), set);
    }

    public static interface NodeInspector<S> {
        @Nullable
        public ResourceLocation suggestionId(ArgumentCommandNode<S, ?> var1);

        public boolean isExecutable(CommandNode<S> var1);

        public boolean isRestricted(CommandNode<S> var1);
    }

    record Entry(@Nullable NodeStub stub, int flags, int redirect, int[] children) {
        public void write(FriendlyByteBuf buffer) {
            buffer.writeByte(this.flags);
            buffer.writeVarIntArray(this.children);
            if ((this.flags & 8) != 0) {
                buffer.writeVarInt(this.redirect);
            }
            if (this.stub != null) {
                this.stub.write(buffer);
            }
        }

        public boolean canBuild(IntSet children) {
            return (this.flags & 8) == 0 || !children.contains(this.redirect);
        }

        public boolean canResolve(IntSet children) {
            for (int i : this.children) {
                if (!children.contains(i)) continue;
                return false;
            }
            return true;
        }
    }

    static interface NodeStub {
        public <S> ArgumentBuilder<S, ?> build(CommandBuildContext var1, NodeBuilder<S> var2);

        public void write(FriendlyByteBuf var1);
    }

    record ArgumentNodeStub(String id, ArgumentTypeInfo.Template<?> argumentType, @Nullable ResourceLocation suggestionId) implements NodeStub
    {
        @Override
        public <S> ArgumentBuilder<S, ?> build(CommandBuildContext context, NodeBuilder<S> nodeBuilder) {
            Object argumentType = this.argumentType.instantiate(context);
            return nodeBuilder.createArgument(this.id, (ArgumentType<?>)argumentType, this.suggestionId);
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.writeUtf(this.id);
            ArgumentNodeStub.serializeCap(buffer, this.argumentType);
            if (this.suggestionId != null) {
                buffer.writeResourceLocation(this.suggestionId);
            }
        }

        private static <A extends ArgumentType<?>> void serializeCap(FriendlyByteBuf buffer, ArgumentTypeInfo.Template<A> argumentInfoTemplate) {
            ArgumentNodeStub.serializeCap(buffer, argumentInfoTemplate.type(), argumentInfoTemplate);
        }

        private static <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>> void serializeCap(FriendlyByteBuf buffer, ArgumentTypeInfo<A, T> argumentInfo, ArgumentTypeInfo.Template<A> argumentInfoTemplate) {
            buffer.writeVarInt(BuiltInRegistries.COMMAND_ARGUMENT_TYPE.getId(argumentInfo));
            argumentInfo.serializeToNetwork(argumentInfoTemplate, buffer);
        }
    }

    record LiteralNodeStub(String id) implements NodeStub
    {
        @Override
        public <S> ArgumentBuilder<S, ?> build(CommandBuildContext context, NodeBuilder<S> nodeBuilder) {
            return nodeBuilder.createLiteral(this.id);
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
            buffer.writeUtf(this.id);
        }
    }

    static class NodeResolver<S> {
        private final CommandBuildContext context;
        private final NodeBuilder<S> builder;
        private final List<Entry> entries;
        private final List<CommandNode<S>> nodes;

        NodeResolver(CommandBuildContext context, NodeBuilder<S> builder, List<Entry> entries) {
            this.context = context;
            this.builder = builder;
            this.entries = entries;
            ObjectArrayList list = new ObjectArrayList();
            list.size(entries.size());
            this.nodes = list;
        }

        public CommandNode<S> resolve(int index) {
            Object commandNode1;
            CommandNode<S> commandNode = this.nodes.get(index);
            if (commandNode != null) {
                return commandNode;
            }
            Entry entry = this.entries.get(index);
            if (entry.stub == null) {
                commandNode1 = new RootCommandNode();
            } else {
                ArgumentBuilder<S, ?> argumentBuilder = entry.stub.build(this.context, this.builder);
                if ((entry.flags & 8) != 0) {
                    argumentBuilder.redirect(this.resolve(entry.redirect));
                }
                boolean flag = (entry.flags & 4) != 0;
                boolean flag1 = (entry.flags & 0x20) != 0;
                commandNode1 = this.builder.configure(argumentBuilder, flag, flag1).build();
            }
            this.nodes.set(index, (CommandNode<S>)commandNode1);
            for (int i : entry.children) {
                CommandNode<S> commandNode2 = this.resolve(i);
                if (commandNode2 instanceof RootCommandNode) continue;
                commandNode1.addChild(commandNode2);
            }
            return commandNode1;
        }
    }

    public static interface NodeBuilder<S> {
        public ArgumentBuilder<S, ?> createLiteral(String var1);

        public ArgumentBuilder<S, ?> createArgument(String var1, ArgumentType<?> var2, @Nullable ResourceLocation var3);

        public ArgumentBuilder<S, ?> configure(ArgumentBuilder<S, ?> var1, boolean var2, boolean var3);
    }
}

