/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.recipebook;

import com.google.common.collect.Lists;
import io.papermc.paper.inventory.recipe.ItemOrExact;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.recipebook.PlaceRecipeHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;

public class ServerPlaceRecipe<R extends Recipe<?>> {
    private static final int ITEM_NOT_FOUND = -1;
    private final Inventory inventory;
    private final CraftingMenuAccess<R> menu;
    private final boolean useMaxItems;
    private final int gridWidth;
    private final int gridHeight;
    private final List<Slot> inputGridSlots;
    private final List<Slot> slotsToClear;

    public static <I extends RecipeInput, R extends Recipe<I>> RecipeBookMenu.PostPlaceAction placeRecipe(CraftingMenuAccess<R> menu, int gridWidth, int gridHeight, List<Slot> inputGridSlots, List<Slot> slotsToClear, Inventory inventory, RecipeHolder<R> recipe, boolean useMaxItems, boolean isCreative) {
        ServerPlaceRecipe<R> serverPlaceRecipe = new ServerPlaceRecipe<R>(menu, inventory, useMaxItems, gridWidth, gridHeight, inputGridSlots, slotsToClear);
        if (!isCreative && !serverPlaceRecipe.testClearGrid()) {
            return RecipeBookMenu.PostPlaceAction.NOTHING;
        }
        StackedItemContents stackedItemContents = new StackedItemContents();
        stackedItemContents.initializeExtras((Recipe<?>)recipe.value(), null);
        inventory.fillStackedContents(stackedItemContents);
        menu.fillCraftSlotsStackedContents(stackedItemContents);
        return serverPlaceRecipe.tryPlaceRecipe(recipe, stackedItemContents);
    }

    private ServerPlaceRecipe(CraftingMenuAccess<R> menu, Inventory inventory, boolean useMaxItems, int gridWidth, int gridHeight, List<Slot> inputGridSlots, List<Slot> slotsToClear) {
        this.menu = menu;
        this.inventory = inventory;
        this.useMaxItems = useMaxItems;
        this.gridWidth = gridWidth;
        this.gridHeight = gridHeight;
        this.inputGridSlots = inputGridSlots;
        this.slotsToClear = slotsToClear;
    }

    private RecipeBookMenu.PostPlaceAction tryPlaceRecipe(RecipeHolder<R> recipe, StackedItemContents stackedItemContents) {
        if (stackedItemContents.canCraft((Recipe<?>)recipe.value(), null)) {
            this.placeRecipe(recipe, stackedItemContents);
            this.inventory.setChanged();
            return RecipeBookMenu.PostPlaceAction.NOTHING;
        }
        this.clearGrid();
        this.inventory.setChanged();
        return RecipeBookMenu.PostPlaceAction.PLACE_GHOST_RECIPE;
    }

    private void clearGrid() {
        for (Slot slot : this.slotsToClear) {
            ItemStack itemStack = slot.getItem().copy();
            this.inventory.placeItemBackInInventory(itemStack, false);
            slot.set(itemStack);
        }
        this.menu.clearCraftingContent();
    }

    private void placeRecipe(RecipeHolder<R> recipe, StackedItemContents stackedItemContents) {
        boolean flag = this.menu.recipeMatches(recipe);
        int biggestCraftableStack = stackedItemContents.getBiggestCraftableStack((Recipe<?>)recipe.value(), null);
        if (flag) {
            for (Slot slot : this.inputGridSlots) {
                ItemStack item = slot.getItem();
                if (item.isEmpty() || Math.min(biggestCraftableStack, item.getMaxStackSize()) >= item.getCount() + 1) continue;
                return;
            }
        }
        int i = this.calculateAmountToCraft(biggestCraftableStack, flag);
        ArrayList<ItemOrExact> list = new ArrayList<ItemOrExact>();
        if (stackedItemContents.canCraft((Recipe<?>)recipe.value(), i, list::add)) {
            int i1 = ServerPlaceRecipe.clampToMaxStackSize(i, list);
            if (i1 != i) {
                list.clear();
                if (!stackedItemContents.canCraft((Recipe<?>)recipe.value(), i1, list::add)) {
                    return;
                }
            }
            this.clearGrid();
            PlaceRecipeHelper.placeRecipe(this.gridWidth, this.gridHeight, recipe.value(), recipe.value().placementInfo().slotsToIngredientIndex(), (item1, slot1, x, y) -> {
                if (item1 != -1) {
                    Slot slot2 = this.inputGridSlots.get(slot1);
                    ItemOrExact holder = (ItemOrExact)list.get((int)item1);
                    int i2 = i1;
                    while (i2 > 0) {
                        if ((i2 = this.moveItemToGrid(slot2, holder, i2)) != -1) continue;
                        return;
                    }
                }
            });
        }
    }

    private static int clampToMaxStackSize(int amount, List<ItemOrExact> items) {
        for (ItemOrExact holder : items) {
            amount = Math.min(amount, holder.getMaxStackSize());
        }
        return amount;
    }

    private int calculateAmountToCraft(int max, boolean recipeMatches) {
        if (this.useMaxItems) {
            return max;
        }
        if (recipeMatches) {
            int i = Integer.MAX_VALUE;
            for (Slot slot : this.inputGridSlots) {
                ItemStack item = slot.getItem();
                if (item.isEmpty() || i <= item.getCount()) continue;
                i = item.getCount();
            }
            if (i != Integer.MAX_VALUE) {
                ++i;
            }
            return i;
        }
        return 1;
    }

    private int moveItemToGrid(Slot slot, ItemOrExact item, int count) {
        ItemStack item1 = slot.getItem();
        int i = this.inventory.findSlotMatchingCraftingIngredient(item, item1);
        if (i == -1) {
            return -1;
        }
        ItemStack item2 = this.inventory.getItem(i);
        ItemStack itemStack = count < item2.getCount() ? this.inventory.removeItem(i, count) : this.inventory.removeItemNoUpdate(i);
        int count1 = itemStack.getCount();
        if (item1.isEmpty()) {
            slot.set(itemStack);
        } else {
            item1.grow(count1);
        }
        return count - count1;
    }

    private boolean testClearGrid() {
        ArrayList list = Lists.newArrayList();
        int amountOfFreeSlotsInInventory = this.getAmountOfFreeSlotsInInventory();
        for (Slot slot : this.inputGridSlots) {
            ItemStack itemStack = slot.getItem().copy();
            if (itemStack.isEmpty()) continue;
            int slotWithRemainingSpace = this.inventory.getSlotWithRemainingSpace(itemStack);
            if (slotWithRemainingSpace == -1 && list.size() <= amountOfFreeSlotsInInventory) {
                for (ItemStack itemStack1 : list) {
                    if (!ItemStack.isSameItem(itemStack1, itemStack) || itemStack1.getCount() == itemStack1.getMaxStackSize() || itemStack1.getCount() + itemStack.getCount() > itemStack1.getMaxStackSize()) continue;
                    itemStack1.grow(itemStack.getCount());
                    itemStack.setCount(0);
                    break;
                }
                if (itemStack.isEmpty()) continue;
                if (list.size() >= amountOfFreeSlotsInInventory) {
                    return false;
                }
                list.add(itemStack);
                continue;
            }
            if (slotWithRemainingSpace != -1) continue;
            return false;
        }
        return true;
    }

    private int getAmountOfFreeSlotsInInventory() {
        int i = 0;
        for (ItemStack itemStack : this.inventory.getNonEquipmentItems()) {
            if (!itemStack.isEmpty()) continue;
            ++i;
        }
        return i;
    }

    public static interface CraftingMenuAccess<T extends Recipe<?>> {
        public void fillCraftSlotsStackedContents(StackedItemContents var1);

        public void clearCraftingContent();

        public boolean recipeMatches(RecipeHolder<T> var1);
    }
}

