/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import org.apache.commons.lang3.StringUtils;

public final class ResourceLocation
implements Comparable<ResourceLocation> {
    public static final Codec<ResourceLocation> CODEC = Codec.STRING.comapFlatMap(ResourceLocation::read, ResourceLocation::toString).stable();
    public static final StreamCodec<ByteBuf, ResourceLocation> STREAM_CODEC = ByteBufCodecs.STRING_UTF8.map(ResourceLocation::parse, ResourceLocation::toString);
    public static final SimpleCommandExceptionType ERROR_INVALID = new SimpleCommandExceptionType((Message)Component.translatable("argument.id.invalid"));
    public static final char NAMESPACE_SEPARATOR = ':';
    public static final String DEFAULT_NAMESPACE = "minecraft";
    public static final String REALMS_NAMESPACE = "realms";
    public static final String PAPER_NAMESPACE = "paper";
    private final String namespace;
    private final String path;

    private ResourceLocation(String namespace, String path) {
        assert (ResourceLocation.isValidNamespace(namespace));
        assert (ResourceLocation.isValidPath(path));
        String resourceLocation = namespace + ":" + path;
        if (resourceLocation.length() > Short.MAX_VALUE || ByteBufUtil.utf8MaxBytes((CharSequence)resourceLocation) > 65535) {
            throw new ResourceLocationException("Resource location too long: " + resourceLocation);
        }
        this.namespace = namespace;
        this.path = path;
    }

    private static ResourceLocation createUntrusted(String namespace, String path) {
        return new ResourceLocation(ResourceLocation.assertValidNamespace(namespace, path), ResourceLocation.assertValidPath(namespace, path));
    }

    public static ResourceLocation fromNamespaceAndPath(String namespace, String path) {
        return ResourceLocation.createUntrusted(namespace, path);
    }

    public static ResourceLocation parse(String location) {
        return ResourceLocation.bySeparator(location, ':');
    }

    public static ResourceLocation withDefaultNamespace(String location) {
        return new ResourceLocation(DEFAULT_NAMESPACE, ResourceLocation.assertValidPath(DEFAULT_NAMESPACE, location));
    }

    @Nullable
    public static ResourceLocation tryParse(String location) {
        return ResourceLocation.tryBySeparator(location, ':');
    }

    @Nullable
    public static ResourceLocation tryBuild(String namespace, String path) {
        return ResourceLocation.isValidNamespace(namespace) && ResourceLocation.isValidPath(path) ? new ResourceLocation(namespace, path) : null;
    }

    public static ResourceLocation bySeparator(String location, char separator) {
        int index = location.indexOf(separator);
        if (index >= 0) {
            String sub = location.substring(index + 1);
            if (index != 0) {
                String sub1 = location.substring(0, index);
                return ResourceLocation.createUntrusted(sub1, sub);
            }
            return ResourceLocation.withDefaultNamespace(sub);
        }
        return ResourceLocation.withDefaultNamespace(location);
    }

    @Nullable
    public static ResourceLocation tryBySeparator(String location, char separator) {
        int index = location.indexOf(separator);
        if (index >= 0) {
            String sub = location.substring(index + 1);
            if (!ResourceLocation.isValidPath(sub)) {
                return null;
            }
            if (index != 0) {
                String sub1 = location.substring(0, index);
                return ResourceLocation.isValidNamespace(sub1) ? new ResourceLocation(sub1, sub) : null;
            }
            return new ResourceLocation(DEFAULT_NAMESPACE, sub);
        }
        return ResourceLocation.isValidPath(location) ? new ResourceLocation(DEFAULT_NAMESPACE, location) : null;
    }

    public static DataResult<ResourceLocation> read(String location) {
        try {
            return DataResult.success((Object)ResourceLocation.parse(location));
        }
        catch (ResourceLocationException var2) {
            return DataResult.error(() -> "Not a valid resource location: " + location + " " + var2.getMessage());
        }
    }

    public String getPath() {
        return this.path;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ResourceLocation withPath(String path) {
        return new ResourceLocation(this.namespace, ResourceLocation.assertValidPath(this.namespace, path));
    }

    public ResourceLocation withPath(UnaryOperator<String> pathOperator) {
        return this.withPath((String)pathOperator.apply(this.path));
    }

    public ResourceLocation withPrefix(String pathPrefix) {
        return this.withPath(pathPrefix + this.path);
    }

    public ResourceLocation withSuffix(String pathSuffix) {
        return this.withPath(this.path + pathSuffix);
    }

    public String toString() {
        return this.namespace + ":" + this.path;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (this == other) return true;
        if (!(other instanceof ResourceLocation)) return false;
        ResourceLocation resourceLocation = (ResourceLocation)other;
        if (!this.namespace.equals(resourceLocation.namespace)) return false;
        if (!this.path.equals(resourceLocation.path)) return false;
        return true;
    }

    public int hashCode() {
        return 31 * this.namespace.hashCode() + this.path.hashCode();
    }

    @Override
    public int compareTo(ResourceLocation other) {
        int i = this.path.compareTo(other.path);
        if (i == 0) {
            i = this.namespace.compareTo(other.namespace);
        }
        return i;
    }

    public String toDebugFileName() {
        return this.toString().replace('/', '_').replace(':', '_');
    }

    public String toLanguageKey() {
        return this.namespace + "." + this.path;
    }

    public String toShortLanguageKey() {
        return this.namespace.equals(DEFAULT_NAMESPACE) ? this.path : this.toLanguageKey();
    }

    public String toLanguageKey(String type) {
        return type + "." + this.toLanguageKey();
    }

    public String toLanguageKey(String type, String key) {
        return type + "." + this.toLanguageKey() + "." + key;
    }

    private static String readGreedy(StringReader reader) {
        int cursor = reader.getCursor();
        while (reader.canRead() && ResourceLocation.isAllowedInResourceLocation(reader.peek())) {
            reader.skip();
        }
        return reader.getString().substring(cursor, reader.getCursor());
    }

    public static ResourceLocation read(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        String greedy = ResourceLocation.readGreedy(reader);
        try {
            return ResourceLocation.parse(greedy);
        }
        catch (ResourceLocationException var4) {
            reader.setCursor(cursor);
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)reader);
        }
    }

    public static ResourceLocation readNonEmpty(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        String greedy = ResourceLocation.readGreedy(reader);
        if (greedy.isEmpty()) {
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)reader);
        }
        try {
            return ResourceLocation.parse(greedy);
        }
        catch (ResourceLocationException var4) {
            reader.setCursor(cursor);
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)reader);
        }
    }

    public static boolean isAllowedInResourceLocation(char character) {
        return character >= '0' && character <= '9' || character >= 'a' && character <= 'z' || character == '_' || character == ':' || character == '/' || character == '.' || character == '-';
    }

    public static boolean isValidPath(String path) {
        for (int i = 0; i < path.length(); ++i) {
            if (ResourceLocation.validPathChar(path.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidNamespace(String namespace) {
        for (int i = 0; i < namespace.length(); ++i) {
            if (ResourceLocation.validNamespaceChar(namespace.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static String assertValidNamespace(String namespace, String path) {
        if (!ResourceLocation.isValidNamespace(namespace)) {
            throw new ResourceLocationException("Non [a-z0-9_.-] character in namespace of location: " + StringUtils.normalizeSpace((String)namespace) + ":" + StringUtils.normalizeSpace((String)path));
        }
        return namespace;
    }

    public static boolean validPathChar(char pathChar) {
        return pathChar == '_' || pathChar == '-' || pathChar >= 'a' && pathChar <= 'z' || pathChar >= '0' && pathChar <= '9' || pathChar == '/' || pathChar == '.';
    }

    private static boolean validNamespaceChar(char namespaceChar) {
        return namespaceChar == '_' || namespaceChar == '-' || namespaceChar >= 'a' && namespaceChar <= 'z' || namespaceChar >= '0' && namespaceChar <= '9' || namespaceChar == '.';
    }

    private static String assertValidPath(String namespace, String path) {
        if (!ResourceLocation.isValidPath(path)) {
            throw new ResourceLocationException("Non [a-z0-9/._-] character in path of location: " + namespace + ":" + StringUtils.normalizeSpace((String)path));
        }
        return path;
    }
}

