/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.destroystokyo.paper.profile.PaperAuthenticationService;
import com.google.common.io.FileWriteMode;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import io.papermc.paper.configuration.PaperConfigurations;
import io.papermc.paper.plugin.PluginInitializerManager;
import io.papermc.paper.util.LogManagerShutdownThread;
import io.papermc.paper.util.ServerEnvironment;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import joptsimple.OptionSet;
import net.minecraft.CrashReport;
import net.minecraft.SharedConstants;
import net.minecraft.SuppressForbidden;
import net.minecraft.Util;
import net.minecraft.commands.Commands;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.network.chat.Component;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.server.Bootstrap;
import net.minecraft.server.Eula;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Services;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.worldupdate.WorldUpgrader;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.chunk.storage.RegionFileVersion;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class Main {
    private static final Logger LOGGER = LogUtils.getLogger();

    @SuppressForbidden(reason="System.out needed before bootstrap")
    @DontObfuscate
    public static void main(OptionSet optionSet) {
        LogManagerShutdownThread.hook();
        SharedConstants.tryDetectVersion();
        try {
            WorldStem worldStem;
            Dynamic<?> dataTag;
            File file;
            Path path = (Path)optionSet.valueOf("pidFile");
            if (path != null) {
                Main.writePidFile(path);
            }
            CrashReport.preload();
            if (optionSet.has("jfrProfile")) {
                JvmProfiler.INSTANCE.start(Environment.SERVER);
            }
            PluginInitializerManager.load(optionSet);
            Bootstrap.bootStrap();
            Bootstrap.validate();
            Util.startTimerHackThread();
            Path path1 = Paths.get("server.properties", new String[0]);
            DedicatedServerSettings dedicatedServerSettings = new DedicatedServerSettings(optionSet);
            dedicatedServerSettings.forceSave();
            RegionFileVersion.configure(dedicatedServerSettings.getProperties().regionFileComression);
            Path path2 = Paths.get("eula.txt", new String[0]);
            Eula eula = new Eula(path2);
            YamlConfiguration bukkitConfiguration = PaperConfigurations.loadLegacyConfigFile((File)optionSet.valueOf("bukkit-settings"));
            YamlConfiguration spigotConfiguration = PaperConfigurations.loadLegacyConfigFile((File)optionSet.valueOf("spigot-settings"));
            if (optionSet.has("initSettings")) {
                File configFile = (File)optionSet.valueOf("bukkit-settings");
                YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)configFile);
                configuration.options().copyDefaults(true);
                configuration.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(Main.class.getClassLoader().getResourceAsStream("configurations/bukkit.yml"), StandardCharsets.UTF_8)));
                configuration.save(configFile);
                File commandFile = (File)optionSet.valueOf("commands-settings");
                YamlConfiguration commandsConfiguration = YamlConfiguration.loadConfiguration((File)commandFile);
                commandsConfiguration.options().copyDefaults(true);
                commandsConfiguration.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(Main.class.getClassLoader().getResourceAsStream("configurations/commands.yml"), StandardCharsets.UTF_8)));
                commandsConfiguration.save(commandFile);
                LOGGER.info("Initialized '{}' and '{}'", (Object)path1.toAbsolutePath(), (Object)path2.toAbsolutePath());
                return;
            }
            boolean eulaAgreed = Boolean.getBoolean("com.mojang.eula.agree");
            if (eulaAgreed) {
                LOGGER.error("You have used the Spigot command line EULA agreement flag.");
                LOGGER.error("By using this setting you are indicating your agreement to Mojang's EULA (https://aka.ms/MinecraftEULA).");
                LOGGER.error("If you do not agree to the above EULA please stop your server and remove this flag immediately.");
            }
            if (!eula.hasAgreedToEULA() && !eulaAgreed) {
                LOGGER.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            String awtException = ServerEnvironment.awtDependencyCheck();
            if (awtException != null) {
                LOGGER.error("You are using a headless JRE distribution.");
                LOGGER.error("This distribution is missing certain graphic libraries that the Minecraft server needs to function.");
                LOGGER.error("For instructions on how to install the non-headless JRE, see https://docs.papermc.io/misc/java-install");
                LOGGER.error("");
                LOGGER.error(awtException);
                return;
            }
            SpigotConfig.disabledAdvancements = spigotConfiguration.getStringList("advancements.disabled");
            File userCacheFile = new File("usercache.json");
            if (optionSet.has("universe")) {
                file = (File)optionSet.valueOf("universe");
                userCacheFile = new File(file, "usercache.json");
            } else {
                file = new File(bukkitConfiguration.getString("settings.world-container", "."));
            }
            Services services = Services.create(new PaperAuthenticationService(Proxy.NO_PROXY), file, userCacheFile, optionSet);
            String string = Optional.ofNullable((String)optionSet.valueOf("world")).orElse(dedicatedServerSettings.getProperties().levelName);
            LevelStorageSource levelStorageSource = LevelStorageSource.createDefault(file.toPath());
            LevelStorageSource.LevelStorageAccess levelStorageAccess = levelStorageSource.validateAndCreateAccess(string, LevelStem.OVERWORLD);
            if (levelStorageAccess.hasWorldData()) {
                LevelSummary summary;
                try {
                    dataTag = levelStorageAccess.getDataTag();
                    summary = levelStorageAccess.getSummary(dataTag);
                }
                catch (IOException | NbtException | ReportedNbtException var41) {
                    LevelStorageSource.LevelDirectory levelDirectory = levelStorageAccess.getLevelDirectory();
                    LOGGER.warn("Failed to load world data from {}", (Object)levelDirectory.dataFile(), (Object)var41);
                    LOGGER.info("Attempting to use fallback");
                    try {
                        dataTag = levelStorageAccess.getDataTagFallback();
                        summary = levelStorageAccess.getSummary(dataTag);
                    }
                    catch (IOException | NbtException | ReportedNbtException var40) {
                        LOGGER.error("Failed to load world data from {}", (Object)levelDirectory.oldDataFile(), (Object)var40);
                        LOGGER.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)levelDirectory.dataFile(), (Object)levelDirectory.oldDataFile());
                        return;
                    }
                    levelStorageAccess.restoreLevelDataFromOld();
                }
                if (summary.requiresManualConversion()) {
                    LOGGER.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!summary.isCompatible()) {
                    LOGGER.info("This world was created by an incompatible version.");
                    return;
                }
            } else {
                dataTag = null;
            }
            Dynamic<?> dynamic = dataTag;
            boolean hasOptionSpec = optionSet.has("safeMode");
            if (hasOptionSpec) {
                LOGGER.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            PackRepository packRepository = ServerPacksSource.createPackRepository(levelStorageAccess);
            File bukkitDataPackFolder = new File(levelStorageAccess.getLevelPath(LevelResource.DATAPACK_DIR).toFile(), "bukkit");
            if (!bukkitDataPackFolder.exists()) {
                bukkitDataPackFolder.mkdirs();
            }
            File mcMeta = new File(bukkitDataPackFolder, "pack.mcmeta");
            try {
                int major = SharedConstants.getCurrentVersion().packVersion(PackType.SERVER_DATA).major();
                int minor = SharedConstants.getCurrentVersion().packVersion(PackType.SERVER_DATA).minor();
                com.google.common.io.Files.asCharSink((File)mcMeta, (Charset)StandardCharsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)"{\n    \"pack\": {\n        \"description\": \"Data pack for resources provided by Bukkit plugins\",\n        \"min_format\": [%d, %d],\n        \"max_format\": [%d, %d]\n    }\n}\n".formatted(major, minor, major, minor));
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not initialize Bukkit datapack", ex);
            }
            AtomicReference worldLoader = new AtomicReference();
            try {
                WorldLoader.InitConfig initConfig = Main.loadOrCreateConfig(dedicatedServerSettings.getProperties(), dynamic, hasOptionSpec, packRepository);
                worldStem = (WorldStem)Util.blockUntilDone(executor -> WorldLoader.load(initConfig, context -> {
                    worldLoader.set(context);
                    HolderLookup.RegistryLookup registry = context.datapackDimensions().lookupOrThrow(Registries.LEVEL_STEM);
                    if (dynamic != null) {
                        LevelDataAndDimensions levelDataAndDimensions = LevelStorageSource.getLevelDataAndDimensions(dynamic, context.dataConfiguration(), (Registry<LevelStem>)registry, context.datapackWorldgen());
                        return new WorldLoader.DataLoadOutput<WorldData>(levelDataAndDimensions.worldData(), levelDataAndDimensions.dimensions().dimensionsRegistryAccess());
                    }
                    LOGGER.info("No existing world data, creating new world");
                    return Main.createNewWorldData(dedicatedServerSettings, context, (Registry<LevelStem>)registry, optionSet.has("demo"), optionSet.has("bonusChest"));
                }, WorldStem::new, Util.backgroundExecutor(), executor)).get();
            }
            catch (Exception var39) {
                LOGGER.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)var39);
                return;
            }
            Class.forName(VillagerTrades.class.getName());
            DedicatedServer dedicatedServer = MinecraftServer.spin(thread1 -> {
                int port;
                boolean flag;
                DedicatedServer dedicatedServer1 = new DedicatedServer(optionSet, (WorldLoader.DataLoadContext)worldLoader.get(), (Thread)thread1, levelStorageAccess, packRepository, worldStem, dedicatedServerSettings, DataFixers.getDataFixer(), services);
                if (optionSet.has("serverId")) {
                    dedicatedServer1.setId((String)optionSet.valueOf("serverId"));
                }
                dedicatedServer1.setDemo(optionSet.has("demo"));
                boolean bl = flag = !optionSet.has("nogui") && !optionSet.nonOptionArguments().contains("nogui");
                if (flag && !GraphicsEnvironment.isHeadless()) {
                    dedicatedServer1.showGui();
                }
                if (optionSet.has("port") && (port = ((Integer)optionSet.valueOf("port")).intValue()) > 0) {
                    dedicatedServer1.setPort(port);
                }
                return dedicatedServer1;
            });
        }
        catch (Exception var42) {
            LOGGER.error(LogUtils.FATAL_MARKER, "Failed to start the minecraft server", (Throwable)var42);
        }
    }

    public static WorldLoader.DataLoadOutput<WorldData> createNewWorldData(DedicatedServerSettings settings, WorldLoader.DataLoadContext context, Registry<LevelStem> stemRegistry, boolean demo, boolean generateBonusChest) {
        WorldDimensions worldDimensions;
        WorldOptions worldOptions;
        LevelSettings levelSettings;
        if (demo) {
            levelSettings = MinecraftServer.DEMO_SETTINGS;
            worldOptions = WorldOptions.DEMO_OPTIONS;
            worldDimensions = WorldPresets.createNormalWorldDimensions(context.datapackWorldgen());
        } else {
            DedicatedServerProperties properties = settings.getProperties();
            levelSettings = new LevelSettings(properties.levelName, properties.gameMode.get(), properties.hardcore, properties.difficulty.get(), false, new GameRules(context.dataConfiguration().enabledFeatures()), context.dataConfiguration());
            worldOptions = generateBonusChest ? properties.worldOptions.withBonusChest(true) : properties.worldOptions;
            worldDimensions = properties.createDimensions(context.datapackWorldgen());
        }
        WorldDimensions.Complete complete = worldDimensions.bake(stemRegistry);
        Lifecycle lifecycle = complete.lifecycle().add(context.datapackWorldgen().allRegistriesLifecycle());
        return new WorldLoader.DataLoadOutput<WorldData>(new PrimaryLevelData(levelSettings, worldOptions, complete.specialWorldProperty(), lifecycle), complete.dimensionsRegistryAccess());
    }

    private static void writePidFile(Path path) {
        try {
            long l = ProcessHandle.current().pid();
            Files.writeString(path, (CharSequence)Long.toString(l), new OpenOption[0]);
        }
        catch (IOException var3) {
            throw new UncheckedIOException(var3);
        }
    }

    private static WorldLoader.InitConfig loadOrCreateConfig(DedicatedServerProperties dedicatedServerProperties, @Nullable Dynamic<?> dynamic, boolean safeMode, PackRepository packRepository) {
        WorldDataConfiguration worldDataConfiguration;
        boolean flag;
        if (dynamic != null) {
            WorldDataConfiguration dataConfig = LevelStorageSource.readDataConfig(dynamic);
            flag = false;
            worldDataConfiguration = dataConfig;
        } else {
            flag = true;
            worldDataConfiguration = new WorldDataConfiguration(dedicatedServerProperties.initialDataPackConfiguration, FeatureFlags.DEFAULT_FLAGS);
        }
        WorldLoader.PackConfig packConfig = new WorldLoader.PackConfig(packRepository, worldDataConfiguration, safeMode, flag);
        return new WorldLoader.InitConfig(packConfig, Commands.CommandSelection.DEDICATED, dedicatedServerProperties.functionPermissionLevel);
    }

    public static void forceUpgrade(LevelStorageSource.LevelStorageAccess levelStorage, WorldData worldData, DataFixer dataFixer, boolean eraseCache, BooleanSupplier running, RegistryAccess registryAccess, boolean recreateRegionFiles) {
        LOGGER.info("Forcing world upgrade! {}", (Object)levelStorage.getLevelId());
        try (WorldUpgrader worldUpgrader = new WorldUpgrader(levelStorage, dataFixer, worldData, registryAccess, eraseCache, recreateRegionFiles);){
            Component component = null;
            while (!worldUpgrader.isFinished()) {
                int totalChunks;
                Component status = worldUpgrader.getStatus();
                if (component != status) {
                    component = status;
                    LOGGER.info(worldUpgrader.getStatus().getString());
                }
                if ((totalChunks = worldUpgrader.getTotalChunks()) > 0) {
                    int i = worldUpgrader.getConverted() + worldUpgrader.getSkipped();
                    LOGGER.info("{}% completed ({} / {} chunks)...", new Object[]{Mth.floor((float)i / (float)totalChunks * 100.0f), i, totalChunks});
                }
                if (!running.getAsBoolean()) {
                    worldUpgrader.cancel();
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

