/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.net.InetAddresses;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.IpBanListEntry;
import org.bukkit.event.player.PlayerKickEvent;

public class BanIpCommands {
    private static final SimpleCommandExceptionType ERROR_INVALID_IP = new SimpleCommandExceptionType((Message)Component.translatable("commands.banip.invalid"));
    private static final SimpleCommandExceptionType ERROR_ALREADY_BANNED = new SimpleCommandExceptionType((Message)Component.translatable("commands.banip.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("ban-ip").requires(Commands.hasPermission(3))).then(((RequiredArgumentBuilder)Commands.argument("target", StringArgumentType.word()).executes(commandContext -> BanIpCommands.banIpOrName((CommandSourceStack)commandContext.getSource(), StringArgumentType.getString((CommandContext)commandContext, (String)"target"), null))).then(Commands.argument("reason", MessageArgument.message()).executes(context -> BanIpCommands.banIpOrName((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"target"), MessageArgument.getMessage((CommandContext<CommandSourceStack>)context, "reason")))))));
    }

    private static int banIpOrName(CommandSourceStack source, String username, @Nullable Component reason) throws CommandSyntaxException {
        if (InetAddresses.isInetAddress((String)username)) {
            return BanIpCommands.banIp(source, username, reason);
        }
        ServerPlayer playerByName = source.getServer().getPlayerList().getPlayerByName(username);
        if (playerByName != null) {
            return BanIpCommands.banIp(source, playerByName.getIpAddress(), reason);
        }
        throw ERROR_INVALID_IP.create();
    }

    private static int banIp(CommandSourceStack source, String ip, @Nullable Component reason) throws CommandSyntaxException {
        IpBanList ipBans = source.getServer().getPlayerList().getIpBans();
        if (ipBans.isBanned(ip)) {
            throw ERROR_ALREADY_BANNED.create();
        }
        List<ServerPlayer> playersWithAddress = source.getServer().getPlayerList().getPlayersWithAddress(ip);
        IpBanListEntry ipBanListEntry = new IpBanListEntry(ip, null, source.getTextName(), null, reason == null ? null : reason.getString());
        ipBans.add(ipBanListEntry);
        source.sendSuccess(() -> Component.translatable("commands.banip.success", ip, ipBanListEntry.getReasonMessage()), true);
        if (!playersWithAddress.isEmpty()) {
            source.sendSuccess(() -> Component.translatable("commands.banip.info", playersWithAddress.size(), EntitySelector.joinNames(playersWithAddress)), true);
        }
        for (ServerPlayer serverPlayer : playersWithAddress) {
            serverPlayer.connection.disconnect((Component)Component.translatable("multiplayer.disconnect.ip_banned"), PlayerKickEvent.Cause.IP_BANNED);
        }
        return playersWithAddress.size();
    }
}

