/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.MessageArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.UserBanList;
import net.minecraft.server.players.UserBanListEntry;
import org.bukkit.event.player.PlayerKickEvent;

public class BanPlayerCommands {
    private static final SimpleCommandExceptionType ERROR_ALREADY_BANNED = new SimpleCommandExceptionType((Message)Component.translatable("commands.ban.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("ban").requires(Commands.hasPermission(3))).then(((RequiredArgumentBuilder)Commands.argument("targets", GameProfileArgument.gameProfile()).executes(commandContext -> BanPlayerCommands.banPlayers((CommandSourceStack)commandContext.getSource(), GameProfileArgument.getGameProfiles((CommandContext<CommandSourceStack>)commandContext, "targets"), null))).then(Commands.argument("reason", MessageArgument.message()).executes(context -> BanPlayerCommands.banPlayers((CommandSourceStack)context.getSource(), GameProfileArgument.getGameProfiles((CommandContext<CommandSourceStack>)context, "targets"), MessageArgument.getMessage((CommandContext<CommandSourceStack>)context, "reason")))))));
    }

    private static int banPlayers(CommandSourceStack source, Collection<NameAndId> players, @Nullable Component reason) throws CommandSyntaxException {
        UserBanList bans = source.getServer().getPlayerList().getBans();
        int i = 0;
        for (NameAndId nameAndId : players) {
            if (bans.isBanned(nameAndId)) continue;
            UserBanListEntry userBanListEntry = new UserBanListEntry(nameAndId, null, source.getTextName(), null, reason == null ? null : reason.getString());
            bans.add(userBanListEntry);
            ++i;
            source.sendSuccess(() -> Component.translatable("commands.ban.success", Component.literal(nameAndId.name()), userBanListEntry.getReasonMessage()), true);
            ServerPlayer player = source.getServer().getPlayerList().getPlayer(nameAndId.id());
            if (player == null) continue;
            player.connection.disconnect((Component)Component.translatable("multiplayer.disconnect.banned"), PlayerKickEvent.Cause.BANNED);
        }
        if (i == 0) {
            throw ERROR_ALREADY_BANNED.create();
        }
        return i;
    }
}

