/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.GameRules;

public class GameRuleCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext) {
        final LiteralArgumentBuilder literalArgumentBuilder = (LiteralArgumentBuilder)Commands.literal("gamerule").requires(Commands.hasPermission(2));
        new GameRules(commandBuildContext.enabledFeatures()).visitGameRuleTypes(new GameRules.GameRuleTypeVisitor(){

            @Override
            public <T extends GameRules.Value<T>> void visit(GameRules.Key<T> key, GameRules.Type<T> type) {
                LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder1 = Commands.literal(key.getId());
                literalArgumentBuilder.then(((LiteralArgumentBuilder)literalArgumentBuilder1.executes(context -> GameRuleCommand.queryRule((CommandSourceStack)context.getSource(), key))).then(type.createArgument("value").executes(context -> GameRuleCommand.setRule((CommandContext<CommandSourceStack>)context, key))));
            }
        });
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)literalArgumentBuilder);
    }

    static <T extends GameRules.Value<T>> int setRule(CommandContext<CommandSourceStack> context, GameRules.Key<T> gameRule) {
        CommandSourceStack commandSourceStack = (CommandSourceStack)context.getSource();
        Object rule = commandSourceStack.getLevel().getGameRules().getRule(gameRule);
        ((GameRules.Value)rule).setFromArgument(context, "value", gameRule);
        commandSourceStack.getServer().notificationManager().onGameRuleChanged(commandSourceStack.getLevel(), gameRule.getId(), (GameRules.Value<?>)rule);
        commandSourceStack.sendSuccess(() -> Component.translatable("commands.gamerule.set", gameRule.getId(), rule.toString()), true);
        return ((GameRules.Value)rule).getCommandResult();
    }

    static <T extends GameRules.Value<T>> int queryRule(CommandSourceStack source, GameRules.Key<T> gameRule) {
        Object rule = source.getLevel().getGameRules().getRule(gameRule);
        source.sendSuccess(() -> Component.translatable("commands.gamerule.query", gameRule.getId(), rule.toString()), false);
        return ((GameRules.Value)rule).getCommandResult();
    }
}

