/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;

public class GiveCommand {
    public static final int MAX_ALLOWED_ITEMSTACKS = 100;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("give").requires(Commands.hasPermission(2))).then(Commands.argument("targets", EntityArgument.players()).then(((RequiredArgumentBuilder)Commands.argument("item", ItemArgument.item(context)).executes(commandContext -> GiveCommand.giveItem((CommandSourceStack)commandContext.getSource(), ItemArgument.getItem(commandContext, "item"), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)commandContext, "targets"), 1))).then(Commands.argument("count", IntegerArgumentType.integer((int)1)).executes(context1 -> GiveCommand.giveItem((CommandSourceStack)context1.getSource(), ItemArgument.getItem(context1, "item"), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context1, "targets"), IntegerArgumentType.getInteger((CommandContext)context1, (String)"count"))))))));
    }

    private static int giveItem(CommandSourceStack source, ItemInput item, Collection<ServerPlayer> targets, int count) throws CommandSyntaxException {
        ItemStack itemStack = item.createItemStack(1, false);
        Component displayName = itemStack.getDisplayName();
        int maxStackSize = itemStack.getMaxStackSize();
        int i = maxStackSize * 100;
        if (count > i) {
            source.sendFailure(Component.translatable("commands.give.failed.toomanyitems", i, itemStack.getDisplayName()));
            return 0;
        }
        for (ServerPlayer serverPlayer : targets) {
            int i1 = count;
            while (i1 > 0) {
                ItemEntity itemEntity;
                int min = Math.min(maxStackSize, i1);
                i1 -= min;
                ItemStack itemStack1 = item.createItemStack(min, false);
                boolean flag = serverPlayer.getInventory().add(itemStack1);
                if (flag && itemStack1.isEmpty()) {
                    itemEntity = serverPlayer.drop(itemStack, false, false, false, null);
                    if (itemEntity != null) {
                        itemEntity.makeFakeItem();
                    }
                    serverPlayer.level().playSound(null, serverPlayer.getX(), serverPlayer.getY(), serverPlayer.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((serverPlayer.getRandom().nextFloat() - serverPlayer.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    serverPlayer.containerMenu.broadcastChanges();
                    continue;
                }
                itemEntity = serverPlayer.drop(itemStack1, false, false, false, null);
                if (itemEntity == null) continue;
                itemEntity.setNoPickUpDelay();
                itemEntity.setTarget(serverPlayer.getUUID());
            }
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.give.success.single", count, displayName, ((ServerPlayer)targets.iterator().next()).getDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.give.success.single", count, displayName, targets.size()), true);
        }
        return targets.size();
    }
}

