/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceOrIdArgument;
import net.minecraft.commands.arguments.SlotArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class ItemCommands {
    static final Dynamic3CommandExceptionType ERROR_TARGET_NOT_A_CONTAINER = new Dynamic3CommandExceptionType((x, y, z) -> Component.translatableEscape("commands.item.target.not_a_container", x, y, z));
    static final Dynamic3CommandExceptionType ERROR_SOURCE_NOT_A_CONTAINER = new Dynamic3CommandExceptionType((x, y, z) -> Component.translatableEscape("commands.item.source.not_a_container", x, y, z));
    static final DynamicCommandExceptionType ERROR_TARGET_INAPPLICABLE_SLOT = new DynamicCommandExceptionType(invalidSlot -> Component.translatableEscape("commands.item.target.no_such_slot", invalidSlot));
    private static final DynamicCommandExceptionType ERROR_SOURCE_INAPPLICABLE_SLOT = new DynamicCommandExceptionType(invalidSlot -> Component.translatableEscape("commands.item.source.no_such_slot", invalidSlot));
    private static final DynamicCommandExceptionType ERROR_TARGET_NO_CHANGES = new DynamicCommandExceptionType(slot -> Component.translatableEscape("commands.item.target.no_changes", slot));
    private static final Dynamic2CommandExceptionType ERROR_TARGET_NO_CHANGES_KNOWN_ITEM = new Dynamic2CommandExceptionType((stackName, slot) -> Component.translatableEscape("commands.item.target.no_changed.known_item", stackName, slot));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("item").requires(Commands.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal("replace").then(Commands.literal("block").then(Commands.argument("pos", BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument("slot", SlotArgument.slot()).then(Commands.literal("with").then(((RequiredArgumentBuilder)Commands.argument("item", ItemArgument.item(context)).executes(commandContext -> ItemCommands.setBlockItem((CommandSourceStack)commandContext.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandContext, "pos"), SlotArgument.getSlot((CommandContext<CommandSourceStack>)commandContext, "slot"), ItemArgument.getItem(commandContext, "item").createItemStack(1, false)))).then(Commands.argument("count", IntegerArgumentType.integer((int)1, (int)99)).executes(commandContext -> ItemCommands.setBlockItem((CommandSourceStack)commandContext.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)commandContext, "pos"), SlotArgument.getSlot((CommandContext<CommandSourceStack>)commandContext, "slot"), ItemArgument.getItem(commandContext, "item").createItemStack(IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"count"), true))))))).then(((LiteralArgumentBuilder)Commands.literal("from").then(Commands.literal("block").then(Commands.argument("source", BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument("sourceSlot", SlotArgument.slot()).executes(context1 -> ItemCommands.blockToBlock((CommandSourceStack)context1.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context1, "source"), SlotArgument.getSlot((CommandContext<CommandSourceStack>)context1, "sourceSlot"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context1, "pos"), SlotArgument.getSlot((CommandContext<CommandSourceStack>)context1, "slot")))).then(Commands.argument("modifier", ResourceOrIdArgument.lootModifier(context)).executes(context1 -> ItemCommands.blockToBlock((CommandSourceStack)context1.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context1, "source"), SlotArgument.getSlot((CommandContext<CommandSourceStack>)context1, "sourceSlot"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context1, "pos"), SlotArgument.getSlot((CommandContext<CommandSourceStack>)context1, "slot"), ResourceOrIdArgument.getLootModifier((CommandContext<CommandSourceStack>)context1, "modifier")))))))).then(Commands.literal("entity").then(Commands.argument("source", EntityArgument.entity()).then(((RequiredArgumentBuilder)Commands.argument("sourceSlot", SlotArgument.slot()).executes(context1 -> ItemCommands.entityToBlock((CommandSourceStack)context1.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)context1, "source"), SlotArgument.getSlot((CommandContext<CommandSourceStack>)context1, "sourceSlot"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context1, "pos"), SlotArgument.getSlot((CommandContext<CommandSourceStack>)context1, "slot")))).then(Commands.argument("modifier", ResourceOrIdArgument.lootModifier(context)).executes(context1 -> ItemCommands.entityToBlock((CommandSourceStack)context1.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)context1, "source"), SlotArgument.getSlot((CommandContext<CommandSourceStack>)context1, "sourceSlot"), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context1, "pos"), SlotArgument.getSlot((CommandContext<CommandSourceStack>)context1, "slot"), ResourceOrIdArgument.getLootModifier((CommandContext<CommandSourceStack>)context1, "modifier")))))))))))).then(Commands.literal("entity").then(Commands.argument("targets", EntityArgument.entities()).then(((RequiredArgumentBuilder)Commands.argument("slot", SlotArgument.slot()).then(Commands.literal("with").then(((RequiredArgumentBuilder)Commands.argument("item", ItemArgument.item(context)).executes(context1 -> ItemCommands.setEntityItem((CommandSourceStack)context1.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context1, "targets"), SlotArgument.getSlot((CommandContext<CommandSourceStack>)context1, "slot"), ItemArgument.getItem(context1, "item").createItemStack(1, false)))).then(Commands.argument("count", IntegerArgumentType.integer((int)1, (int)99)).executes(context1 -> ItemCommands.setEntityItem((CommandSourceStack)context1.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context1, "targets"), SlotArgument.getSlot((CommandContext<CommandSourceStack>)context1, "slot"), ItemArgument.getItem(context1, "item").createItemStack(IntegerArgumentType.getInteger((CommandContext)context1, (String)"count"), true))))))).then(((LiteralArgumentBuilder)Commands.literal("from").then(Commands.literal("block").then(Commands.argument("source", BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument("sourceSlot", SlotArgument.slot()).executes(context1 -> ItemCommands.blockToEntities((CommandSourceStack)context1.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context1, "source"), SlotArgument.getSlot((CommandContext<CommandSourceStack>)context1, "sourceSlot"), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context1, "targets"), SlotArgument.getSlot((CommandContext<CommandSourceStack>)context1, "slot")))).then(Commands.argument("modifier", ResourceOrIdArgument.lootModifier(context)).executes(context1 -> ItemCommands.blockToEntities((CommandSourceStack)context1.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context1, "source"), SlotArgument.getSlot((CommandContext<CommandSourceStack>)context1, "sourceSlot"), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context1, "targets"), SlotArgument.getSlot((CommandContext<CommandSourceStack>)context1, "slot"), ResourceOrIdArgument.getLootModifier((CommandContext<CommandSourceStack>)context1, "modifier")))))))).then(Commands.literal("entity").then(Commands.argument("source", EntityArgument.entity()).then(((RequiredArgumentBuilder)Commands.argument("sourceSlot", SlotArgument.slot()).executes(context1 -> ItemCommands.entityToEntities((CommandSourceStack)context1.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)context1, "source"), SlotArgument.getSlot((CommandContext<CommandSourceStack>)context1, "sourceSlot"), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context1, "targets"), SlotArgument.getSlot((CommandContext<CommandSourceStack>)context1, "slot")))).then(Commands.argument("modifier", ResourceOrIdArgument.lootModifier(context)).executes(context1 -> ItemCommands.entityToEntities((CommandSourceStack)context1.getSource(), EntityArgument.getEntity((CommandContext<CommandSourceStack>)context1, "source"), SlotArgument.getSlot((CommandContext<CommandSourceStack>)context1, "sourceSlot"), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context1, "targets"), SlotArgument.getSlot((CommandContext<CommandSourceStack>)context1, "slot"), ResourceOrIdArgument.getLootModifier((CommandContext<CommandSourceStack>)context1, "modifier"))))))))))))).then(((LiteralArgumentBuilder)Commands.literal("modify").then(Commands.literal("block").then(Commands.argument("pos", BlockPosArgument.blockPos()).then(Commands.argument("slot", SlotArgument.slot()).then(Commands.argument("modifier", ResourceOrIdArgument.lootModifier(context)).executes(context1 -> ItemCommands.modifyBlockItem((CommandSourceStack)context1.getSource(), BlockPosArgument.getLoadedBlockPos((CommandContext<CommandSourceStack>)context1, "pos"), SlotArgument.getSlot((CommandContext<CommandSourceStack>)context1, "slot"), ResourceOrIdArgument.getLootModifier((CommandContext<CommandSourceStack>)context1, "modifier")))))))).then(Commands.literal("entity").then(Commands.argument("targets", EntityArgument.entities()).then(Commands.argument("slot", SlotArgument.slot()).then(Commands.argument("modifier", ResourceOrIdArgument.lootModifier(context)).executes(context1 -> ItemCommands.modifyEntityItem((CommandSourceStack)context1.getSource(), EntityArgument.getEntities((CommandContext<CommandSourceStack>)context1, "targets"), SlotArgument.getSlot((CommandContext<CommandSourceStack>)context1, "slot"), ResourceOrIdArgument.getLootModifier((CommandContext<CommandSourceStack>)context1, "modifier"))))))))));
    }

    private static int modifyBlockItem(CommandSourceStack source, BlockPos pos, int slot, Holder<LootItemFunction> modifier) throws CommandSyntaxException {
        Container container = ItemCommands.getContainer(source, pos, ERROR_TARGET_NOT_A_CONTAINER);
        if (slot >= 0 && slot < container.getContainerSize()) {
            ItemStack itemStack = ItemCommands.applyModifier(source, modifier, container.getItem(slot));
            container.setItem(slot, itemStack);
            source.sendSuccess(() -> Component.translatable("commands.item.block.set.success", pos.getX(), pos.getY(), pos.getZ(), itemStack.getDisplayName()), true);
            return 1;
        }
        throw ERROR_TARGET_INAPPLICABLE_SLOT.create((Object)slot);
    }

    private static int modifyEntityItem(CommandSourceStack source, Collection<? extends Entity> targets, int sourceSlot, Holder<LootItemFunction> modifier) throws CommandSyntaxException {
        HashMap map = Maps.newHashMapWithExpectedSize((int)targets.size());
        for (Entity entity : targets) {
            ItemStack itemStack;
            SlotAccess slot = entity.getSlot(sourceSlot);
            if (slot == SlotAccess.NULL || !slot.set(itemStack = ItemCommands.applyModifier(source, modifier, slot.get().copy()))) continue;
            map.put(entity, itemStack);
            if (!(entity instanceof ServerPlayer)) continue;
            ((ServerPlayer)entity).containerMenu.broadcastChanges();
        }
        if (map.isEmpty()) {
            throw ERROR_TARGET_NO_CHANGES.create((Object)sourceSlot);
        }
        if (map.size() == 1) {
            Map.Entry entry = map.entrySet().iterator().next();
            source.sendSuccess(() -> Component.translatable("commands.item.entity.set.success.single", ((Entity)entry.getKey()).getDisplayName(), ((ItemStack)entry.getValue()).getDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.item.entity.set.success.multiple", map.size()), true);
        }
        return map.size();
    }

    private static int setBlockItem(CommandSourceStack source, BlockPos pos, int slot, ItemStack item) throws CommandSyntaxException {
        Container container = ItemCommands.getContainer(source, pos, ERROR_TARGET_NOT_A_CONTAINER);
        if (slot >= 0 && slot < container.getContainerSize()) {
            container.setItem(slot, item);
            source.sendSuccess(() -> Component.translatable("commands.item.block.set.success", pos.getX(), pos.getY(), pos.getZ(), item.getDisplayName()), true);
            return 1;
        }
        throw ERROR_TARGET_INAPPLICABLE_SLOT.create((Object)slot);
    }

    static Container getContainer(CommandSourceStack source, BlockPos pos, Dynamic3CommandExceptionType exception) throws CommandSyntaxException {
        BlockEntity blockEntity = source.getLevel().getBlockEntity(pos);
        if (!(blockEntity instanceof Container)) {
            throw exception.create((Object)pos.getX(), (Object)pos.getY(), (Object)pos.getZ());
        }
        return (Container)((Object)blockEntity);
    }

    private static int setEntityItem(CommandSourceStack source, Collection<? extends Entity> targets, int slot, ItemStack item) throws CommandSyntaxException {
        ArrayList list = Lists.newArrayListWithCapacity((int)targets.size());
        for (Entity entity : targets) {
            SlotAccess slot1 = entity.getSlot(slot);
            if (slot1 == SlotAccess.NULL || !slot1.set(item.copy())) continue;
            list.add(entity);
            if (!(entity instanceof ServerPlayer)) continue;
            ((ServerPlayer)entity).containerMenu.broadcastChanges();
        }
        if (list.isEmpty()) {
            throw ERROR_TARGET_NO_CHANGES_KNOWN_ITEM.create((Object)item.getDisplayName(), (Object)slot);
        }
        if (list.size() == 1) {
            source.sendSuccess(() -> Component.translatable("commands.item.entity.set.success.single", ((Entity)list.iterator().next()).getDisplayName(), item.getDisplayName()), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.item.entity.set.success.multiple", list.size(), item.getDisplayName()), true);
        }
        return list.size();
    }

    private static int blockToEntities(CommandSourceStack source, BlockPos pos, int sourceSlot, Collection<? extends Entity> targets, int slot) throws CommandSyntaxException {
        return ItemCommands.setEntityItem(source, targets, slot, ItemCommands.getBlockItem(source, pos, sourceSlot));
    }

    private static int blockToEntities(CommandSourceStack source, BlockPos pos, int sourceSlot, Collection<? extends Entity> targets, int slot, Holder<LootItemFunction> modifier) throws CommandSyntaxException {
        return ItemCommands.setEntityItem(source, targets, slot, ItemCommands.applyModifier(source, modifier, ItemCommands.getBlockItem(source, pos, sourceSlot)));
    }

    private static int blockToBlock(CommandSourceStack source, BlockPos sourcePos, int sourceSlot, BlockPos pos, int slot) throws CommandSyntaxException {
        return ItemCommands.setBlockItem(source, pos, slot, ItemCommands.getBlockItem(source, sourcePos, sourceSlot));
    }

    private static int blockToBlock(CommandSourceStack source, BlockPos sourcePos, int sourceSlot, BlockPos pos, int slot, Holder<LootItemFunction> modifier) throws CommandSyntaxException {
        return ItemCommands.setBlockItem(source, pos, slot, ItemCommands.applyModifier(source, modifier, ItemCommands.getBlockItem(source, sourcePos, sourceSlot)));
    }

    private static int entityToBlock(CommandSourceStack source, Entity sourceEntity, int sourceSlot, BlockPos pos, int slot) throws CommandSyntaxException {
        return ItemCommands.setBlockItem(source, pos, slot, ItemCommands.getEntityItem(sourceEntity, sourceSlot));
    }

    private static int entityToBlock(CommandSourceStack source, Entity sourceEntity, int sourceSlot, BlockPos pos, int slot, Holder<LootItemFunction> modifier) throws CommandSyntaxException {
        return ItemCommands.setBlockItem(source, pos, slot, ItemCommands.applyModifier(source, modifier, ItemCommands.getEntityItem(sourceEntity, sourceSlot)));
    }

    private static int entityToEntities(CommandSourceStack source, Entity sourceEntity, int sourceSlot, Collection<? extends Entity> targets, int slot) throws CommandSyntaxException {
        return ItemCommands.setEntityItem(source, targets, slot, ItemCommands.getEntityItem(sourceEntity, sourceSlot));
    }

    private static int entityToEntities(CommandSourceStack source, Entity sourceEntity, int sourceSlot, Collection<? extends Entity> targets, int slot, Holder<LootItemFunction> modifier) throws CommandSyntaxException {
        return ItemCommands.setEntityItem(source, targets, slot, ItemCommands.applyModifier(source, modifier, ItemCommands.getEntityItem(sourceEntity, sourceSlot)));
    }

    private static ItemStack applyModifier(CommandSourceStack source, Holder<LootItemFunction> modifier, ItemStack stack) {
        ServerLevel level = source.getLevel();
        LootParams lootParams = new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, source.getPosition()).withOptionalParameter(LootContextParams.THIS_ENTITY, source.getEntity()).create(LootContextParamSets.COMMAND);
        LootContext lootContext = new LootContext.Builder(lootParams).create(Optional.empty());
        lootContext.pushVisitedElement(LootContext.createVisitedEntry(modifier.value()));
        ItemStack itemStack = (ItemStack)modifier.value().apply(stack, lootContext);
        itemStack.limitSize(itemStack.getMaxStackSize());
        return itemStack;
    }

    private static ItemStack getEntityItem(Entity entity, int slot) throws CommandSyntaxException {
        SlotAccess slot1 = entity.getSlot(slot);
        if (slot1 == SlotAccess.NULL) {
            throw ERROR_SOURCE_INAPPLICABLE_SLOT.create((Object)slot);
        }
        return slot1.get().copy();
    }

    private static ItemStack getBlockItem(CommandSourceStack source, BlockPos pos, int slot) throws CommandSyntaxException {
        Container container = ItemCommands.getContainer(source, pos, ERROR_SOURCE_NOT_A_CONTAINER);
        if (slot >= 0 && slot < container.getContainerSize()) {
            return container.getItem(slot).copy();
        }
        throw ERROR_SOURCE_INAPPLICABLE_SLOT.create((Object)slot);
    }
}

