/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;

public class StopSoundCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        RequiredArgumentBuilder requiredArgumentBuilder = (RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument("targets", EntityArgument.players()).executes(context -> StopSoundCommand.stopSound((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), null, null))).then(Commands.literal("*").then(Commands.argument("sound", ResourceLocationArgument.id()).suggests(SuggestionProviders.cast(SuggestionProviders.AVAILABLE_SOUNDS)).executes(context -> StopSoundCommand.stopSound((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), null, ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)context, "sound")))));
        for (SoundSource soundSource : SoundSource.values()) {
            requiredArgumentBuilder.then(((LiteralArgumentBuilder)Commands.literal(soundSource.getName()).executes(context -> StopSoundCommand.stopSound((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), soundSource, null))).then(Commands.argument("sound", ResourceLocationArgument.id()).suggests(SuggestionProviders.cast(SuggestionProviders.AVAILABLE_SOUNDS)).executes(context -> StopSoundCommand.stopSound((CommandSourceStack)context.getSource(), EntityArgument.getPlayers((CommandContext<CommandSourceStack>)context, "targets"), soundSource, ResourceLocationArgument.getId((CommandContext<CommandSourceStack>)context, "sound")))));
        }
        dispatcher.register((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal("stopsound").requires(Commands.hasPermission(2))).then((ArgumentBuilder)requiredArgumentBuilder)));
    }

    private static int stopSound(CommandSourceStack source, Collection<ServerPlayer> targets, @Nullable SoundSource soundSource, @Nullable ResourceLocation sound) {
        ClientboundStopSoundPacket clientboundStopSoundPacket = new ClientboundStopSoundPacket(sound, soundSource);
        for (ServerPlayer serverPlayer : targets) {
            serverPlayer.connection.send(clientboundStopSoundPacket);
        }
        if (soundSource != null) {
            if (sound != null) {
                source.sendSuccess(() -> Component.translatable("commands.stopsound.success.source.sound", Component.translationArg(sound), soundSource.getName()), true);
            } else {
                source.sendSuccess(() -> Component.translatable("commands.stopsound.success.source.any", soundSource.getName()), true);
            }
        } else if (sound != null) {
            source.sendSuccess(() -> Component.translatable("commands.stopsound.success.sourceless.sound", Component.translationArg(sound)), true);
        } else {
            source.sendSuccess(() -> Component.translatable("commands.stopsound.success.sourceless.any"), true);
        }
        return targets.size();
    }
}

