/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.internalapi;

import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.jsonrpc.JsonRpcLogger;
import net.minecraft.server.jsonrpc.internalapi.MinecraftGameRuleService;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.jsonrpc.methods.GameRulesService;
import net.minecraft.server.jsonrpc.methods.InvalidParameterJsonRpcException;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.GameRules;

public class MinecraftGameRuleServiceImpl
implements MinecraftGameRuleService {
    private final DedicatedServer server;
    private final JsonRpcLogger jsonrpcLogger;

    public MinecraftGameRuleServiceImpl(DedicatedServer server, JsonRpcLogger jsonrpcLogger) {
        this.server = server;
        this.jsonrpcLogger = jsonrpcLogger;
    }

    @Override
    public GameRulesService.TypedRule updateGameRule(GameRulesService.UntypedRule rule, ClientInfo client) {
        GameRules.Value<?> ruleValue = this.getRuleValue(rule.key());
        String string = ruleValue.serialize();
        if (ruleValue instanceof GameRules.BooleanValue) {
            GameRules.BooleanValue booleanValue = (GameRules.BooleanValue)ruleValue;
            booleanValue.set(Boolean.parseBoolean(rule.value()), this.server.overworld());
        } else {
            if (!(ruleValue instanceof GameRules.IntegerValue)) {
                throw new InvalidParameterJsonRpcException("Unknown rule type for key: " + rule.key());
            }
            GameRules.IntegerValue integerValue = (GameRules.IntegerValue)ruleValue;
            integerValue.set(Integer.parseInt(rule.value()), this.server.overworld());
        }
        GameRulesService.TypedRule typedRule = this.getTypedRule(rule.key(), ruleValue);
        this.jsonrpcLogger.log(client, "Game rule '{}' updated from '{}' to '{}'", typedRule.key(), string, typedRule.value());
        this.server.notificationManager().onGameRuleChanged(this.server.overworld(), rule.key(), ruleValue);
        return typedRule;
    }

    @Override
    public <T extends GameRules.Value<T>> T getRule(GameRules.Key<T> key) {
        return this.server.getGameRules().getRule(key);
    }

    @Override
    public GameRulesService.TypedRule getTypedRule(String key, GameRules.Value<?> value) {
        GameRules.Value<?> value2 = value;
        Objects.requireNonNull(value2);
        GameRules.Value<?> value3 = value2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GameRules.BooleanValue.class, GameRules.IntegerValue.class}, value3, n)) {
            case 0 -> {
                GameRules.BooleanValue booleanValue = (GameRules.BooleanValue)value3;
                yield new GameRulesService.TypedRule(key, String.valueOf(booleanValue.get()), GameRulesService.RuleType.BOOL);
            }
            case 1 -> {
                GameRules.IntegerValue integerValue = (GameRules.IntegerValue)value3;
                yield new GameRulesService.TypedRule(key, String.valueOf(integerValue.get()), GameRulesService.RuleType.INT);
            }
            default -> throw new InvalidParameterJsonRpcException("Unknown rule type");
        };
    }

    @Override
    public Stream<Map.Entry<GameRules.Key<?>, GameRules.Type<?>>> getAvailableGameRules() {
        FeatureFlagSet featureFlagSet = this.server.getWorldData().getLevelSettings().getDataConfiguration().enabledFeatures();
        return GameRules.availableRules(featureFlagSet);
    }

    private Optional<GameRules.Key<?>> getRuleKey(String id) {
        Stream<Map.Entry<GameRules.Key<?>, GameRules.Type<?>>> availableGameRules = this.getAvailableGameRules();
        return availableGameRules.filter(entry -> ((GameRules.Key)entry.getKey()).getId().equals(id)).findFirst().map(Map.Entry::getKey);
    }

    private GameRules.Value<?> getRuleValue(String id) {
        GameRules.Key<?> key = this.getRuleKey(id).orElseThrow(() -> new InvalidParameterJsonRpcException("Game rule '" + id + "' does not exist"));
        return this.server.getGameRules().getRule(key);
    }
}

