/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.methods;

import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.server.jsonrpc.api.PlayerDto;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.StoredUserEntry;
import net.minecraft.server.players.UserWhiteListEntry;

public class AllowlistService {
    public static List<PlayerDto> get(MinecraftApi api) {
        return api.allowListService().getEntries().stream().filter(userWhiteListEntry -> userWhiteListEntry.getUser() != null).map(userWhiteListEntry -> PlayerDto.from((NameAndId)userWhiteListEntry.getUser())).toList();
    }

    public static List<PlayerDto> add(MinecraftApi api, List<PlayerDto> players, ClientInfo client) {
        List<CompletableFuture> list = players.stream().map(playerDto -> api.playerListService().getUser(playerDto.id(), playerDto.name())).toList();
        for (Optional optional : Util.sequence(list).join()) {
            optional.ifPresent(nameAndId -> api.allowListService().add(new UserWhiteListEntry((NameAndId)nameAndId), client));
        }
        return AllowlistService.get(api);
    }

    public static List<PlayerDto> clear(MinecraftApi api, ClientInfo client) {
        api.allowListService().clear(client);
        return AllowlistService.get(api);
    }

    public static List<PlayerDto> remove(MinecraftApi api, List<PlayerDto> players, ClientInfo client) {
        List<CompletableFuture> list = players.stream().map(playerDto -> api.playerListService().getUser(playerDto.id(), playerDto.name())).toList();
        for (Optional optional : Util.sequence(list).join()) {
            optional.ifPresent(nameAndId -> api.allowListService().remove((NameAndId)nameAndId, client));
        }
        api.allowListService().kickUnlistedPlayers(client);
        return AllowlistService.get(api);
    }

    public static List<PlayerDto> set(MinecraftApi api, List<PlayerDto> players, ClientInfo client) {
        List<CompletableFuture> list = players.stream().map(playerDto -> api.playerListService().getUser(playerDto.id(), playerDto.name())).toList();
        Set set = Util.sequence(list).join().stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        Set set1 = api.allowListService().getEntries().stream().map(StoredUserEntry::getUser).collect(Collectors.toSet());
        set1.stream().filter(nameAndId -> !set.contains(nameAndId)).forEach(nameAndId -> api.allowListService().remove((NameAndId)nameAndId, client));
        set.stream().filter(nameAndId -> !set1.contains(nameAndId)).forEach(nameAndId -> api.allowListService().add(new UserWhiteListEntry((NameAndId)nameAndId), client));
        api.allowListService().kickUnlistedPlayers(client);
        return AllowlistService.get(api);
    }
}

