/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.methods;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.jsonrpc.IncomingRpcMethod;
import net.minecraft.server.jsonrpc.OutgoingRpcMethod;
import net.minecraft.server.jsonrpc.api.MethodInfo;
import net.minecraft.server.jsonrpc.api.Schema;
import net.minecraft.server.jsonrpc.api.SchemaComponent;

public class DiscoveryService {
    public static DiscoverResponse discover(List<SchemaComponent> components) {
        ArrayList<MethodInfo.Named> list = new ArrayList<MethodInfo.Named>(BuiltInRegistries.INCOMING_RPC_METHOD.size() + BuiltInRegistries.OUTGOING_RPC_METHOD.size());
        BuiltInRegistries.INCOMING_RPC_METHOD.listElements().forEach(reference -> {
            if (((IncomingRpcMethod)reference.value()).attributes().discoverable()) {
                list.add(((IncomingRpcMethod)reference.value()).info().named(reference.key().location()));
            }
        });
        BuiltInRegistries.OUTGOING_RPC_METHOD.listElements().forEach(reference -> {
            if (((OutgoingRpcMethod)reference.value()).attributes().discoverable()) {
                list.add(((OutgoingRpcMethod)reference.value()).info().named(reference.key().location()));
            }
        });
        HashMap<String, Schema> map = new HashMap<String, Schema>();
        for (SchemaComponent schemaComponent : components) {
            map.put(schemaComponent.name(), schemaComponent.schema());
        }
        DiscoverInfo discoverInfo = new DiscoverInfo("Minecraft Server JSON-RPC", "1.0.0");
        return new DiscoverResponse("1.3.2", discoverInfo, list, new DiscoverComponents(map));
    }

    public record DiscoverInfo(String title, String version) {
        public static final MapCodec<DiscoverInfo> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("title").forGetter(DiscoverInfo::title), (App)Codec.STRING.fieldOf("version").forGetter(DiscoverInfo::version)).apply((Applicative)instance, DiscoverInfo::new));
    }

    public record DiscoverResponse(String jsonRpcProtocolVersion, DiscoverInfo discoverInfo, List<MethodInfo.Named> methods, DiscoverComponents components) {
        public static final MapCodec<DiscoverResponse> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("openrpc").forGetter(DiscoverResponse::jsonRpcProtocolVersion), (App)DiscoverInfo.CODEC.codec().fieldOf("info").forGetter(DiscoverResponse::discoverInfo), (App)Codec.list(MethodInfo.Named.CODEC).fieldOf("methods").forGetter(DiscoverResponse::methods), (App)DiscoverComponents.CODEC.codec().fieldOf("components").forGetter(DiscoverResponse::components)).apply((Applicative)instance, DiscoverResponse::new));
    }

    public record DiscoverComponents(Map<String, Schema> schemas) {
        public static final MapCodec<DiscoverComponents> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, Schema.CODEC).fieldOf("schemas").forGetter(DiscoverComponents::schemas)).apply((Applicative)instance, DiscoverComponents::new));
    }
}

