/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.jsonrpc.methods;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.server.jsonrpc.internalapi.MinecraftApi;
import net.minecraft.server.jsonrpc.methods.ClientInfo;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.GameRules;

public class GameRulesService {
    public static List<TypedRule> get(MinecraftApi api) {
        List<GameRules.Key> list = api.gameRuleService().getAvailableGameRules().map(Map.Entry::getKey).toList();
        ArrayList<TypedRule> list1 = new ArrayList<TypedRule>();
        for (GameRules.Key key : list) {
            Object rule = api.gameRuleService().getRule(key);
            list1.add(GameRulesService.getTypedRule(api, key.getId(), rule));
        }
        return list1;
    }

    public static TypedRule getTypedRule(MinecraftApi api, String key, GameRules.Value<?> value) {
        return api.gameRuleService().getTypedRule(key, value);
    }

    public static TypedRule update(MinecraftApi api, UntypedRule rule, ClientInfo client) {
        return api.gameRuleService().updateGameRule(rule, client);
    }

    public record TypedRule(String key, String value, RuleType type) {
        public static final MapCodec<TypedRule> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("key").forGetter(TypedRule::key), (App)Codec.STRING.fieldOf("value").forGetter(TypedRule::value), (App)StringRepresentable.fromEnum(RuleType::values).fieldOf("type").forGetter(TypedRule::type)).apply((Applicative)instance, TypedRule::new));
    }

    public record UntypedRule(String key, String value) {
        public static final MapCodec<UntypedRule> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("key").forGetter(UntypedRule::key), (App)Codec.STRING.fieldOf("value").forGetter(UntypedRule::value)).apply((Applicative)instance, UntypedRule::new));
    }

    public static enum RuleType implements StringRepresentable
    {
        INT("integer"),
        BOOL("boolean");

        private final String name;

        private RuleType(String name) {
            this.name = name;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }
    }
}

